/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.user;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarPickerHelper;
import com.atlassian.jira.avatar.AvatarPickerHelperImpl;
import com.atlassian.jira.avatar.Selection;
import com.atlassian.jira.icon.IconType;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.opensymphony.module.propertyset.PropertySet;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Component
@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001B\u0001\u0003\u0001E\u0011q#V:fe\u00063\u0018\r^1s\u0007J,\u0017\r^3TKJ4\u0018nY3\u000b\u0005\r!\u0011\u0001B;tKJT!!\u0002\u0004\u0002\u0011\r,8\u000f^8nKJT!a\u0002\u0005\u0002\u000f\u0019,\u0017\r^;sK*\u0011\u0011BC\u0001\tS:$XM\u001d8bY*\u00111\u0002D\u0001\fg\u0016\u0014h/[2fI\u0016\u001c8N\u0003\u0002\u000e\u001d\u0005I\u0011\r\u001e7bgNL\u0017M\u001c\u0006\u0002\u001f\u0005\u00191m\\7\u0004\u0001M\u0011\u0001A\u0005\t\u0003'Yi\u0011\u0001\u0006\u0006\u0002+\u0005)1oY1mC&\u0011q\u0003\u0006\u0002\u0007\u0003:L(+\u001a4\t\u0011e\u0001!\u0011!Q\u0001\ni\tQ\"\u0019<bi\u0006\u0014X*\u00198bO\u0016\u0014\bCA\u000e!\u001b\u0005a\"BA\u000f\u001f\u0003\u0019\tg/\u0019;be*\u0011q\u0004D\u0001\u0005U&\u0014\u0018-\u0003\u0002\"9\ti\u0011I^1uCJl\u0015M\\1hKJD\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001J\u0001\u0014kN,'\u000f\u0015:pa\u0016\u0014H/_'b]\u0006<WM\u001d\t\u0003K\u001dj\u0011A\n\u0006\u0003\u0007yI!\u0001\u000b\u0014\u0003'U\u001bXM\u001d)s_B,'\u000f^=NC:\fw-\u001a:\t\u0011)\u0002!\u0011!Q\u0001\n-\n!#\u0019<bi\u0006\u0014\b+[2lKJDU\r\u001c9feB\u00111\u0004L\u0005\u0003[q\u0011!#\u0011<bi\u0006\u0014\b+[2lKJDU\r\u001c9fe\")q\u0006\u0001C\u0001a\u00051A(\u001b8jiz\"B!M\u001a5kA\u0011!\u0007A\u0007\u0002\u0005!)\u0011D\fa\u00015!)1E\fa\u0001I!)!F\fa\u0001W!\u0012af\u000e\t\u0003q\rk\u0011!\u000f\u0006\u0003um\n!\"\u00198o_R\fG/[8o\u0015\taT(A\u0004gC\u000e$xN]=\u000b\u0005yz\u0014!\u00022fC:\u001c(B\u0001!B\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"\u0001\"\u0002\u0007=\u0014x-\u0003\u0002Es\tI\u0011)\u001e;po&\u0014X\r\u001a\u0005\u0006\r\u0002!\taR\u0001\u0010GJ,\u0017\r^3B]\u0012\f5o]5h]R\u0019\u0001jS*\u0011\u0005MI\u0015B\u0001&\u0015\u0005\u0011)f.\u001b;\t\u000b\r)\u0005\u0019\u0001'\u0011\u00055\u000bV\"\u0001(\u000b\u0005\ry%B\u0001)\u000b\u0003\r\t\u0007/[\u0005\u0003%:\u00131b\u00115fG.,G-V:fe\")A+\u0012a\u0001+\u00069A-\u0019;b+JL\u0007C\u0001,Z\u001d\t\u0019r+\u0003\u0002Y)\u00051\u0001K]3eK\u001aL!AW.\u0003\rM#(/\u001b8h\u0015\tAF\u0003C\u0003^\u0001\u0011\u0005a,A\bva2|\u0017\r\u001a+f[B|'/\u0019:z)\u0011y\u0016N\u001b;\u0011\u0007\u0001\u001cgM\u0004\u0002\u001cC&\u0011!\rH\u0001\u0017\u0003Z\fG/\u0019:QS\u000e\\WM\u001d%fYB,'/S7qY&\u0011A-\u001a\u0002\u0007%\u0016\u001cX\u000f\u001c;\u000b\u0005\td\u0002C\u00011h\u0013\tAWMA\nUK6\u0004xN]1ss\u00063\u0018\r^1s\u0005\u0016\fg\u000eC\u0003\u00049\u0002\u0007A\nC\u0003l9\u0002\u0007A.\u0001\u0004tiJ,\u0017-\u001c\t\u0003[Jl\u0011A\u001c\u0006\u0003_B\f!![8\u000b\u0003E\fAA[1wC&\u00111O\u001c\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW\u000eC\u0003v9\u0002\u0007Q+A\u0006d_:$XM\u001c;UsB,\u0007\"B<\u0001\t\u0013A\u0018\u0001F2sK\u0006$XMU1oI>lg)\u001b7f\u001d\u0006lW\r\u0006\u0002Vs\")1A\u001ea\u0001\u0019\")1\u0010\u0001C\u0005y\u0006a2M]3bi\u0016Le\u000e];u'R\u0014X-Y7Ge>lG)\u0019;b+JLGC\u00017~\u0011\u0015!&\u00101\u0001VQ\t\u0001q\u0010\u0005\u0003\u0002\u0002\u0005\u001dQBAA\u0002\u0015\r\t)aP\u0001\u000bgR,'/Z8usB,\u0017\u0002BA\u0005\u0003\u0007\u0011\u0011bQ8na>tWM\u001c;")
public class UserAvatarCreateService {
    private final AvatarManager avatarManager;
    private final UserPropertyManager userPropertyManager;
    private final AvatarPickerHelper avatarPickerHelper;

    public void createAndAssign(CheckedUser user, String dataUri) {
        String fileName = this.createRandomFileName(user);
        BufferedImage image = ImageIO.read(this.createInputStreamFromDataUri(dataUri));
        Selection selection = new Selection(0, 0, image.getWidth(), image.getWidth());
        InputStream inputStreamToConvert = this.createInputStreamFromDataUri(dataUri);
        Avatar createdAvatar = this.avatarManager.create(fileName, "image/png", user.forJIRA(), inputStreamToConvert, selection);
        PropertySet userPropertySet = this.userPropertyManager.getPropertySet(user.forJIRA());
        userPropertySet.setLong("user.avatar.id", BoxesRunTime.unboxToLong((Object)createdAvatar.getId()));
    }

    public AvatarPickerHelperImpl.Result<AvatarPickerHelperImpl.TemporaryAvatarBean> uploadTemporary(CheckedUser user, InputStream stream, String contentType) {
        AvatarPickerHelperImpl.Result result = this.avatarPickerHelper.upload(stream, this.createRandomFileName(user), contentType, -1L, user.getKey(), IconType.USER_ICON_TYPE);
        return result;
    }

    private String createRandomFileName(CheckedUser user) {
        return new StringBuilder().append((Object)user.getName()).append((Object)new BigInteger(100, new SecureRandom()).toString(32)).toString();
    }

    private InputStream createInputStreamFromDataUri(String dataUri) {
        return new ByteArrayInputStream(Base64.decodeBase64((String)dataUri.replaceFirst("data:image/png;base64,", "")));
    }

    @Autowired
    public UserAvatarCreateService(AvatarManager avatarManager, UserPropertyManager userPropertyManager, AvatarPickerHelper avatarPickerHelper) {
        this.avatarManager = avatarManager;
        this.userPropertyManager = userPropertyManager;
        this.avatarPickerHelper = avatarPickerHelper;
    }
}

