/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.user;

import com.atlassian.servicedesk.internal.feature.customer.user.InvitationToken;
import java.io.IOException;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TokenUtils {
    private Logger logger = LoggerFactory.getLogger(TokenUtils.class);
    private final ObjectMapper mapper = new ObjectMapper();

    public String toJson(InvitationToken invitationToken) {
        try {
            return this.mapper.writeValueAsString((Object)invitationToken);
        }
        catch (IOException e) {
            this.logger.error("Unable to convert invitation token to json {}", (Object)invitationToken);
            return null;
        }
    }

    public InvitationToken fromJson(String tokenAsJson) {
        try {
            return (InvitationToken)this.mapper.readValue(tokenAsJson, InvitationToken.class);
        }
        catch (IOException e) {
            this.logger.error("Unable to parse invitation token from json {}", (Object)tokenAsJson);
            return null;
        }
    }
}

