/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.user;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.project.Project;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.notifications.model.ServiceDeskEmail;
import com.atlassian.servicedesk.internal.api.project.ProjectUrlsProvider;
import com.atlassian.servicedesk.internal.feature.customer.InternalPortalServiceScala;
import com.atlassian.servicedesk.internal.feature.customer.user.InvitationToken;
import com.atlassian.servicedesk.internal.notifications.ServiceDeskNotificationInternalSender;
import com.atlassian.servicedesk.internal.notifications.render.SDUserNotificationRenderer;
import com.atlassian.servicedesk.internal.utils.Logger;
import com.atlassian.servicedesk.internal.utils.Logging;
import com.atlassian.servicedesk.internal.utils.Logging$class;
import java.net.URI;
import java.net.URLEncoder;
import javax.ws.rs.core.UriBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Option;
import scala.collection.JavaConverters$;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@Component
@ScalaSignature(bytes="\u0006\u0001\u00055d\u0001B\u0001\u0003\u0001E\u0011\u0011$\u00138wSR,gj\u001c;jM&\u001c\u0017\r^5p]N+'O^5dK*\u00111\u0001B\u0001\u0005kN,'O\u0003\u0002\u0006\r\u0005A1-^:u_6,'O\u0003\u0002\b\u0011\u00059a-Z1ukJ,'BA\u0005\u000b\u0003!Ig\u000e^3s]\u0006d'BA\u0006\r\u0003-\u0019XM\u001d<jG\u0016$Wm]6\u000b\u00055q\u0011!C1uY\u0006\u001c8/[1o\u0015\u0005y\u0011aA2p[\u000e\u00011c\u0001\u0001\u00131A\u00111CF\u0007\u0002))\tQ#A\u0003tG\u0006d\u0017-\u0003\u0002\u0018)\t1\u0011I\\=SK\u001a\u0004\"!\u0007\u000f\u000e\u0003iQ!a\u0007\u0005\u0002\u000bU$\u0018\u000e\\:\n\u0005uQ\"a\u0002'pO\u001eLgn\u001a\u0005\t?\u0001\u0011\t\u0011)A\u0005A\u0005)\u0012\r\u001d9mS\u000e\fG/[8o!J|\u0007/\u001a:uS\u0016\u001c\bCA\u0011)\u001b\u0005\u0011#BA\u0012%\u0003)\u0001(o\u001c9feRLWm\u001d\u0006\u0003K\u0019\naaY8oM&<'BA\u0014\r\u0003\u0011Q\u0017N]1\n\u0005%\u0012#!F!qa2L7-\u0019;j_:\u0004&o\u001c9feRLWm\u001d\u0005\tW\u0001\u0011\t\u0011)A\u0005Y\u00059Ro]3s\u001d>$\u0018NZ5dCRLwN\\*feZL7-\u001a\t\u0003[Ij\u0011A\f\u0006\u0003_A\naA]3oI\u0016\u0014(BA\u0019\t\u00035qw\u000e^5gS\u000e\fG/[8og&\u00111G\f\u0002\u001b'\u0012+6/\u001a:O_RLg-[2bi&|gNU3oI\u0016\u0014XM\u001d\u0005\tk\u0001\u0011\t\u0011)A\u0005m\u00051Ro]3s\u001d>$\u0018NZ5dCRLwN\\*f]\u0012,'\u000f\u0005\u00028q5\t\u0001'\u0003\u0002:a\t)3+\u001a:wS\u000e,G)Z:l\u001d>$\u0018NZ5dCRLwN\\%oi\u0016\u0014h.\u00197TK:$WM\u001d\u0005\tw\u0001\u0011\t\u0011)A\u0005y\u0005i\u0001o\u001c:uC2\u001cVM\u001d<jG\u0016\u0004\"!\u0010 \u000e\u0003\u0011I!a\u0010\u0003\u00035%sG/\u001a:oC2\u0004vN\u001d;bYN+'O^5dKN\u001b\u0017\r\\1\t\u0011\u0005\u0003!\u0011!Q\u0001\n\t\u000b!\u0003\u001d:pU\u0016\u001cG/\u0016:m!J|g/\u001b3feB\u00111\tS\u0007\u0002\t*\u0011QIR\u0001\baJ|'.Z2u\u0015\t9\u0005\"A\u0002ba&L!!\u0013#\u0003'A\u0013xN[3diV\u0013Hn\u001d)s_ZLG-\u001a:\t\u000b-\u0003A\u0011\u0001'\u0002\rqJg.\u001b;?)\u0019iu\nU)S'B\u0011a\nA\u0007\u0002\u0005!)qD\u0013a\u0001A!)1F\u0013a\u0001Y!)QG\u0013a\u0001m!)1H\u0013a\u0001y!)\u0011I\u0013a\u0001\u0005\"\u0012!*\u0016\t\u0003-\u0006l\u0011a\u0016\u0006\u00031f\u000b!\"\u00198o_R\fG/[8o\u0015\tQ6,A\u0004gC\u000e$xN]=\u000b\u0005qk\u0016!\u00022fC:\u001c(B\u00010`\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"\u00011\u0002\u0007=\u0014x-\u0003\u0002c/\nI\u0011)\u001e;po&\u0014X\r\u001a\u0005\u0006I\u0002!\t!Z\u0001 g\u0016tG-Q4f]RLeN^5uCRLwN\u001c(pi&4\u0017nY1uS>tGC\u00024niZ\f\u0019\u0002\u0005\u0002hW6\t\u0001N\u0003\u0002jU\u0006)Qn\u001c3fY*\u0011\u0011GR\u0005\u0003Y\"\u0014\u0001cU3sm&\u001cW\rR3tW\u0016k\u0017-\u001b7\t\u000b\r\u0019\u0007\u0019\u00018\u0011\u0005=\u0014X\"\u00019\u000b\u0005\r\t(BA$\u000b\u0013\t\u0019\bOA\u0006DQ\u0016\u001c7.\u001a3Vg\u0016\u0014\b\"B;d\u0001\u0004q\u0017!B1hK:$\b\"B<d\u0001\u0004A\u0018\u0001\u00039s_*,7\r^:\u0011\u000be\f\u0019!!\u0003\u000f\u0005i|hBA>\u007f\u001b\u0005a(BA?\u0011\u0003\u0019a$o\\8u}%\tQ#C\u0002\u0002\u0002Q\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0006\u0005\u001d!\u0001\u0002'jgRT1!!\u0001\u0015!\u0011\tY!a\u0004\u000e\u0005\u00055!BA#'\u0013\u0011\t\t\"!\u0004\u0003\u000fA\u0013xN[3di\"9\u0011QC2A\u0002\u0005]\u0011!\u0002;pW\u0016t\u0007#B\n\u0002\u001a\u0005u\u0011bAA\u000e)\t1q\n\u001d;j_:\u00042ATA\u0010\u0013\r\t\tC\u0001\u0002\u0010\u0013:4\u0018\u000e^1uS>tGk\\6f]\"9\u0011Q\u0005\u0001\u0005\n\u0005\u001d\u0012\u0001\u00062vS2$\u0017iZ3oi&sg/\u001b;bi&|g\u000eF\u0005g\u0003S\tY#!\f\u00020!11!a\tA\u00029Da!^A\u0012\u0001\u0004q\u0007BB<\u0002$\u0001\u0007\u0001\u0010\u0003\u0005\u0002\u0016\u0005\r\u0002\u0019AA\f\u0011\u001d\t\u0019\u0004\u0001C\u0005\u0003k\t\u0011cZ3u\u0003\u001e,g\u000e^%om&$X-\u0016*M)\u0011\t9$!\u0012\u0011\t\u0005e\u0012q\b\b\u0004'\u0005m\u0012bAA\u001f)\u00051\u0001K]3eK\u001aLA!!\u0011\u0002D\t11\u000b\u001e:j]\u001eT1!!\u0010\u0015\u0011\u001d)\u0015\u0011\u0007a\u0001\u0003\u0013A\u0001\"!\u0013\u0001\t\u0003\u0011\u00111J\u0001\u0007K:\u001cw\u000eZ3\u0015\t\u0005]\u0012Q\n\u0005\t\u0003\u001f\n9\u00051\u0001\u00028\u0005!a.Y7f\u0011!\t\u0019\u0006\u0001C\u0001\u0005\u0005U\u0013A\u00073fG>\u0014\u0018\r^3J]ZLG/Z+sY^KG\u000f\u001b)be\u0006lG\u0003CA\u001c\u0003/\nI&a\u0017\t\r\r\t\t\u00061\u0001o\u0011!\t)\"!\u0015A\u0002\u0005]\u0001\u0002CA/\u0003#\u0002\r!a\u000e\u0002\u0013%tg/\u001b;f+Jd\u0007f\u0001\u0001\u0002bA!\u00111MA5\u001b\t\t)GC\u0002\u0002hu\u000b!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\tY'!\u001a\u0003\u0013\r{W\u000e]8oK:$\b")
public class InviteNotificationService
implements Logging {
    private final ApplicationProperties applicationProperties;
    private final SDUserNotificationRenderer userNotificationService;
    private final ServiceDeskNotificationInternalSender userNotificationSender;
    private final ProjectUrlsProvider projectUrlProvider;
    private final Logger log;

    @Override
    public Logger log() {
        return this.log;
    }

    @Override
    public void com$atlassian$servicedesk$internal$utils$Logging$_setter_$log_$eq(Logger x$1) {
        this.log = x$1;
    }

    public ServiceDeskEmail sendAgentInvitationNotification(CheckedUser user, CheckedUser agent, List<Project> projects, Option<InvitationToken> token) {
        ServiceDeskEmail notification = this.buildAgentInvitation(user, agent, projects, token);
        this.userNotificationSender.send(notification);
        return notification;
    }

    private ServiceDeskEmail buildAgentInvitation(CheckedUser user, CheckedUser agent, List<Project> projects, Option<InvitationToken> token) {
        String invitationLink = this.getAgentInviteURL((Project)projects.apply(0));
        invitationLink = this.decorateInviteUrlWithParam(agent, token, invitationLink);
        return this.userNotificationService.createInvitationNotification(user, agent, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(projects).asJava(), invitationLink);
    }

    private String getAgentInviteURL(Project project) {
        return UriBuilder.fromUri((URI)this.projectUrlProvider.getUrls(project.getKey(), ProjectUrlsProvider.UrlMode.WITHOUT_CONTEXT).projectBase()).path("invite").build(new Object[0]).toASCIIString();
    }

    public String encode(String name) {
        return URLEncoder.encode(name, this.applicationProperties.getEncoding());
    }

    public String decorateInviteUrlWithParam(CheckedUser user, Option<InvitationToken> token, String inviteUrl) {
        String encodedUserName = this.encode(user.getName());
        String inviteUrlWithParam = new StringBuilder().append((Object)inviteUrl).append((Object)"?username=").append((Object)encodedUserName).toString();
        if (token.isDefined()) {
            inviteUrlWithParam = new StringBuilder().append((Object)inviteUrlWithParam).append((Object)"&token=").append((Object)((InvitationToken)token.get()).getValue()).toString();
        }
        return inviteUrlWithParam;
    }

    @Autowired
    public InviteNotificationService(ApplicationProperties applicationProperties, SDUserNotificationRenderer userNotificationService, ServiceDeskNotificationInternalSender userNotificationSender, InternalPortalServiceScala portalService, ProjectUrlsProvider projectUrlProvider) {
        this.applicationProperties = applicationProperties;
        this.userNotificationService = userNotificationService;
        this.userNotificationSender = userNotificationSender;
        this.projectUrlProvider = projectUrlProvider;
        Logging$class.$init$(this);
    }
}

