/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.user;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.project.Project;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.customer.CustomerContextService;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.internal.feature.customer.user.CustomerServiceValidator;
import com.atlassian.servicedesk.internal.feature.customer.user.invite.PublicAccessCustomerInviteService;
import com.atlassian.servicedesk.internal.feature.servicedesk.InternalServiceDeskAccessService;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.atlassian.servicedesk.internal.user.permission.ServiceDeskPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerServiceValidatorImpl
implements CustomerServiceValidator {
    private final PublicAccessCustomerInviteService publicAccessCustomerInviteService;
    private final ServiceDeskPermissions serviceDeskPermissions;
    private final CustomerContextService customerContextService;
    private final InternalServiceDeskAccessService internalServiceDeskAccessService;
    private final FeatureManager featureManager;

    @Autowired
    public CustomerServiceValidatorImpl(PublicAccessCustomerInviteService publicAccessCustomerInviteService, ServiceDeskPermissions serviceDeskPermissions, CustomerContextService customerContextService, InternalServiceDeskAccessService internalServiceDeskAccessService, FeatureManager featureManager) {
        this.publicAccessCustomerInviteService = publicAccessCustomerInviteService;
        this.serviceDeskPermissions = serviceDeskPermissions;
        this.customerContextService = customerContextService;
        this.internalServiceDeskAccessService = internalServiceDeskAccessService;
        this.featureManager = featureManager;
    }

    @Override
    public boolean isUserAllowedInviteCustomers(CheckedUser user, Project project, ServiceDesk serviceDesk) {
        return (Boolean)this.customerContextService.runOutOfCustomerContext(() -> this.serviceDeskPermissions.canViewAgentView((SDUser)user, project)) != false && (this.serviceDeskPermissions.canAdministerServiceDesk((SDUser)user, project) || this.publicAccessCustomerInviteService.isSignupAndInviteSupported(user, serviceDesk, project));
    }

    @Override
    public boolean isUserAllowedInviteOutsiderCustomer(CheckedUser user, Project project, ServiceDesk serviceDesk) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.OUTSIDER_COMMENTS)) {
            return false;
        }
        return this.isUserAllowedInviteCustomers(user, project, serviceDesk);
    }

    @Override
    public boolean isCustomerForProject(CheckedUser customer, Project project) {
        return (Boolean)this.customerContextService.runInCustomerContext(() -> this.serviceDeskPermissions.canCreateRequest((SDUser)customer, project));
    }
}

