/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.user;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.user.search.UserSearchParams;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.customer.CustomerCreateParameters;
import com.atlassian.servicedesk.api.customer.CustomerService;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequest;
import com.atlassian.servicedesk.api.util.paging.PagedResponseImpl;
import com.atlassian.servicedesk.internal.api.error.ValidationErrors;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.api.project.InternalServiceDeskProjectManager;
import com.atlassian.servicedesk.internal.api.search.user.UserSearchManager;
import com.atlassian.servicedesk.internal.api.search.user.UserSearchManagerHelper;
import com.atlassian.servicedesk.internal.errors.ValidationErrorsHelper;
import com.atlassian.servicedesk.internal.feature.customer.CustomerManager;
import com.atlassian.servicedesk.internal.feature.customer.user.CustomerCreateParametersImpl;
import com.atlassian.servicedesk.internal.feature.customer.user.CustomerServiceValidator;
import com.atlassian.servicedesk.internal.feature.customer.user.InternalCustomerService;
import com.atlassian.servicedesk.internal.feature.customer.user.invite.CustomerInviteManager;
import com.atlassian.servicedesk.internal.feature.customer.user.invite.result.InviteCustomerResult;
import com.atlassian.servicedesk.internal.feature.customer.user.signup.SignupManager;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.atlassian.servicedesk.internal.user.permission.ServiceDeskPermissions;
import com.atlassian.servicedesk.internal.util.paging.LazyPagedResponse;
import com.atlassian.servicedesk.internal.util.paging.LazyPagedResponseImpl;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={CustomerService.class})
public class CustomerServiceImpl
implements InternalCustomerService,
CustomerService {
    private static final Logger logger = LoggerFactory.getLogger(CustomerServiceImpl.class);
    private final CustomerServiceValidator customerServiceValidator;
    private final CustomerInviteManager customerInviteManager;
    private final ErrorResultHelper errorResultHelper;
    private final ServiceDeskPermissions serviceDeskPermissions;
    private final CommonErrors commonErrors;
    private final UserSearchManager userSearchManager;
    private final UserSearchManagerHelper userSearchManagerHelper;
    private final UserFactory userFactory;
    private final SignupManager signupManager;
    private final FeatureManager featureManager;
    private final CustomerManager customerManager;
    private final InternalServiceDeskProjectManager projectManager;
    private final ValidationErrorsHelper validationErrorsHelper;

    @Autowired
    public CustomerServiceImpl(CustomerInviteManager customerInviteManager, CustomerServiceValidator customerServiceValidator, ErrorResultHelper errorResultHelper, ServiceDeskPermissions serviceDeskPermissions, CommonErrors commonErrors, UserSearchManager userSearchManager, UserSearchManagerHelper userSearchManagerHelper, UserFactory userFactory, SignupManager signupManager, FeatureManager featureManager, CustomerManager customerManager, InternalServiceDeskProjectManager projectManager, ValidationErrorsHelper validationErrorsHelper) {
        this.customerInviteManager = customerInviteManager;
        this.customerServiceValidator = customerServiceValidator;
        this.errorResultHelper = errorResultHelper;
        this.serviceDeskPermissions = serviceDeskPermissions;
        this.commonErrors = commonErrors;
        this.userSearchManager = userSearchManager;
        this.userSearchManagerHelper = userSearchManagerHelper;
        this.userFactory = userFactory;
        this.signupManager = signupManager;
        this.featureManager = featureManager;
        this.customerManager = customerManager;
        this.projectManager = projectManager;
        this.validationErrorsHelper = validationErrorsHelper;
    }

    @Override
    @Deprecated
    public io.atlassian.fugue.Either<AnError, LazyPagedResponse<CheckedUser>> searchCustomers(CheckedUser user, String nameOrEmailQuery, LimitedPagedRequest pagedRequest, ServiceDesk serviceDesk, Project project) {
        if (!this.serviceDeskPermissions.canViewAgentView((SDUser)user, project)) {
            return io.atlassian.fugue.Either.left((Object)this.commonErrors.AGENT_PERMISSIONS_ERROR());
        }
        UserSearchParams params = this.userSearchManagerHelper.buildCustomerUserSearchParamsWithoutOrganizations(project, serviceDesk, Option.some((Object)this.getSearchLimit(pagedRequest)));
        Stream searchResults = this.userSearchManager.search(nameOrEmailQuery, params);
        LazyPagedResponse<CheckedUser> response = this.buildPagedPageResponse(pagedRequest, searchResults);
        return io.atlassian.fugue.Either.right(response);
    }

    @Override
    public io.atlassian.fugue.Either<AnError, CustomerInviteManager.CustomerInviteValidationResult> validateInviteCustomers(CheckedUser user, ServiceDesk serviceDesk, Project project, Set<String> emails) {
        if (!this.customerServiceValidator.isUserAllowedInviteCustomers(user, project, serviceDesk)) {
            return io.atlassian.fugue.Either.left((Object)this.errorResultHelper.forbidden403("sd.error.servicedesk.customer.invite.permissions", new Object[0]).build());
        }
        return this.customerInviteManager.validateInviteCustomersByEmailOrUsername(user, serviceDesk, project, emails);
    }

    @Override
    public io.atlassian.fugue.Either<AnError, InviteCustomerResult> inviteCustomers(CustomerInviteManager.CustomerInviteValidationResult customerInviteValidationResult) {
        Objects.requireNonNull(customerInviteValidationResult, "customerInviteValidationResult");
        if (!this.customerServiceValidator.isUserAllowedInviteCustomers(customerInviteValidationResult.getCheckedUser(), customerInviteValidationResult.getProject(), customerInviteValidationResult.getServiceDesk())) {
            return io.atlassian.fugue.Either.left((Object)this.errorResultHelper.forbidden403("sd.error.servicedesk.customer.invite.permissions", new Object[0]).build());
        }
        return this.customerInviteManager.inviteCustomers(customerInviteValidationResult);
    }

    @Override
    public io.atlassian.fugue.Either<AnError, InviteCustomerResult> inviteCustomersToOrganizationByName(@Nonnull CustomerInviteManager.CustomerInviteValidationResult customerInviteValidationResult, @Nonnull String organisationName) {
        Objects.requireNonNull(customerInviteValidationResult, "customerInviteValidationResult");
        Objects.requireNonNull(organisationName, "organisationName");
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return io.atlassian.fugue.Either.left((Object)this.commonErrors.FEATURE_NOT_ENABLED());
        }
        if (!this.customerServiceValidator.isUserAllowedInviteCustomers(customerInviteValidationResult.getCheckedUser(), customerInviteValidationResult.getProject(), customerInviteValidationResult.getServiceDesk())) {
            return io.atlassian.fugue.Either.left((Object)this.errorResultHelper.forbidden403("sd.error.servicedesk.customer.invite.permissions", new Object[0]).build());
        }
        return this.customerInviteManager.inviteCustomersToOrganisationByName(customerInviteValidationResult, organisationName);
    }

    @Override
    public io.atlassian.fugue.Either<AnError, InviteCustomerResult> inviteCustomersToOrganization(@Nonnull CustomerInviteManager.CustomerInviteValidationResult customerInviteValidationResult, @Nonnull CustomerOrganization customerOrganisation) {
        Objects.requireNonNull(customerInviteValidationResult, "customerInviteValidationResult");
        Objects.requireNonNull(customerOrganisation, "customerOrganisation");
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return io.atlassian.fugue.Either.left((Object)this.commonErrors.FEATURE_NOT_ENABLED());
        }
        if (!this.customerServiceValidator.isUserAllowedInviteCustomers(customerInviteValidationResult.getCheckedUser(), customerInviteValidationResult.getProject(), customerInviteValidationResult.getServiceDesk())) {
            return io.atlassian.fugue.Either.left((Object)this.errorResultHelper.forbidden403("sd.error.servicedesk.customer.invite.permissions", new Object[0]).build());
        }
        return this.customerInviteManager.inviteCustomersToOrganisation(customerInviteValidationResult, customerOrganisation);
    }

    public Either<AnError, CheckedUser> createCustomer(@Nonnull ApplicationUser user, @Nonnull CustomerCreateParameters params) {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)params);
        return StepsConverters.olderEither((io.atlassian.fugue.Either)Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(user))).then(loggedInUser -> {
            if (!this.serviceDeskPermissions.canAdministerJIRA((SDUser)loggedInUser)) {
                return io.atlassian.fugue.Either.left((Object)this.errorResultHelper.forbidden403("sd.rest.error.permission", new Object[]{"JIRA Administrators global permission"}).build());
            }
            return io.atlassian.fugue.Either.right((Object)loggedInUser);
        }).then((loggedInUser, userWithPermission) -> {
            io.atlassian.fugue.Either<AnError, io.atlassian.fugue.Either<ValidationErrors, CheckedUser>> signupResult = this.signupManager.signUpCustomerThroughAPI(params.getEmail(), params.getFullName());
            return (io.atlassian.fugue.Either)signupResult.fold(io.atlassian.fugue.Either::left, r -> r.leftMap(e -> this.validationErrorsHelper.convertToAnError((CheckedUser)loggedInUser, (ValidationErrors)e)));
        }).yield((loggedInUser, userWithPermission, customer) -> customer));
    }

    public Either<AnError, List<CheckedUser>> addCustomersToServiceDesk(@Nonnull ApplicationUser applicationUser, @Nonnull ServiceDesk serviceDesk, @Nonnull Set<String> usernameOrEmails) {
        Preconditions.checkNotNull((Object)applicationUser);
        Preconditions.checkNotNull((Object)serviceDesk);
        Preconditions.checkNotNull(usernameOrEmails);
        return StepsConverters.olderEither((io.atlassian.fugue.Either)Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(applicationUser))).then(user -> this.isUserAllowedToInviteCustomers((CheckedUser)user, serviceDesk)).then((user, userWithPermission) -> io.atlassian.fugue.Either.right(usernameOrEmails.stream().map(usernameOrEmail -> this.customerManager.validateExistingCustomerByEmailOrUsername(applicationUser, (String)usernameOrEmail)).collect(Collectors.toList()))).then((user, userWithPermission, validatedUsers) -> this.addCustomers(applicationUser, serviceDesk, (List<io.atlassian.fugue.Either<ValidationErrors, CheckedUser>>)validatedUsers)).then((user, userWithPermission, validationResult, inviteResults) -> inviteResults.leftMap(errors -> {
            String usernames = errors.stream().flatMap(ve -> ve.getFieldErrors().keySet().stream()).collect(Collectors.joining(", "));
            return this.errorResultHelper.badRequest400("sd.rest.error.bad.request.users.not.found", new Object[]{usernames}).build();
        })).yield((user, userWithPermission, validationResult, inviteResults, addUsers) -> addUsers));
    }

    private io.atlassian.fugue.Either<AnError, CheckedUser> isUserAllowedToInviteCustomers(CheckedUser user, ServiceDesk serviceDesk) {
        return Steps.begin((io.atlassian.fugue.Either)this.projectManager.getProject(Long.valueOf(serviceDesk.getProjectId()))).then(project -> {
            if (!this.customerServiceValidator.isUserAllowedInviteCustomers(user, (Project)project, serviceDesk)) {
                return io.atlassian.fugue.Either.left((Object)this.errorResultHelper.forbidden403("sd.error.servicedesk.customer.invite.permissions", new Object[0]).build());
            }
            return io.atlassian.fugue.Either.right((Object)user);
        }).yield((project, userWithPermission) -> userWithPermission);
    }

    private io.atlassian.fugue.Either<AnError, io.atlassian.fugue.Either<List<ValidationErrors>, List<CheckedUser>>> addCustomers(ApplicationUser applicationUser, ServiceDesk serviceDesk, List<io.atlassian.fugue.Either<ValidationErrors, CheckedUser>> validatedUsers) {
        List validationErrors = validatedUsers.stream().filter(io.atlassian.fugue.Either::isLeft).map(errors -> (ValidationErrors)errors.left().get()).collect(Collectors.toList());
        if (!validationErrors.isEmpty()) {
            return io.atlassian.fugue.Either.right((Object)io.atlassian.fugue.Either.left(validationErrors));
        }
        Optional<io.atlassian.fugue.Either> errorOccured = validatedUsers.stream().map(validatedUserResult -> {
            CheckedUser validatedUser = (CheckedUser)validatedUserResult.right().get();
            return this.customerManager.addCustomerToServiceDesk(applicationUser, serviceDesk, validatedUser);
        }).filter(io.atlassian.fugue.Either::isLeft).findFirst();
        List users = validatedUsers.stream().map(validatedUser -> (CheckedUser)validatedUser.right().get()).collect(Collectors.toList());
        return errorOccured.orElse(io.atlassian.fugue.Either.right((Object)true)).map(added -> io.atlassian.fugue.Either.right((Object)users));
    }

    public CustomerCreateParameters.Builder newCreateBuilder() {
        return new CustomerCreateParametersImpl.BuilderImpl();
    }

    @VisibleForTesting
    LazyPagedResponse<CheckedUser> buildPagedPageResponse(LimitedPagedRequest pagedRequest, Stream<ApplicationUser> users) {
        boolean hasMore;
        int actualLimit = this.getActualRequestLimit(pagedRequest);
        List applicationUsers = users.limit((long)pagedRequest.getStart() + this.maxInt(this.plusOne(actualLimit))).collect(Collectors.toList());
        int total = applicationUsers.size();
        List checkedUsers = applicationUsers.stream().skip(pagedRequest.getStart()).flatMap(this::applicationUserToStream).collect(Collectors.toList());
        boolean bl = hasMore = checkedUsers.size() > actualLimit;
        if (hasMore) {
            checkedUsers.remove(actualLimit);
            --total;
        }
        return LazyPagedResponseImpl.from(PagedResponseImpl.from(checkedUsers, (boolean)hasMore).pageRequest(pagedRequest).build(), total);
    }

    private Stream<CheckedUser> applicationUserToStream(ApplicationUser applicationUser) {
        return (Stream)this.userFactory.wrap(applicationUser).fold(anError -> {
            logger.warn("This conversion should never be failing .... but did .... pagination results may be misleading : {}", (Object)applicationUser);
            return Stream.empty();
        }, Stream::of);
    }

    private int getSearchLimit(LimitedPagedRequest pagedRequest) {
        return (int)this.maxInt((long)pagedRequest.getStart() + this.plusOne(this.getActualRequestLimit(pagedRequest)));
    }

    private int getActualRequestLimit(LimitedPagedRequest pagedRequest) {
        return Math.min(pagedRequest.getLimit(), pagedRequest.getMaxLimit());
    }

    private long plusOne(int number) {
        return (long)number + 1L;
    }

    private long maxInt(long number) {
        return Math.min(Integer.MAX_VALUE, number);
    }
}

