/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.user;

import com.atlassian.core.AtlassianCoreException;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.timezone.TimeZoneService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.preferences.ExtendedPreferences;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.LocaleParser;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.error.ValidationErrors;
import com.atlassian.servicedesk.internal.feature.customer.user.UserAvatarCreateService;
import com.atlassian.servicedesk.internal.feature.customer.user.UserLanguageHelper;
import com.atlassian.servicedesk.internal.feature.emailchannel.EmailUtil;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.atlassian.servicedesk.internal.rest.customers.request.ProfileUpdateRequest;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class CustomerProfileService {
    private static final int MAX_FIELD_LENGTH = 255;
    private static Logger log = LoggerFactory.getLogger(CustomerProfileService.class);
    private final CrowdService crowdService;
    private final UserFactory sdUserFactory;
    private final TimeZoneService timezoneService;
    private final UserAvatarCreateService userAvatarService;
    private final UserPreferencesManager userPreferencesManager;
    private final I18nHelper i18nHelper;
    private final ApplicationProperties applicationProperties;
    private final FeatureManager featureManager;
    private final UserLanguageHelper userLanguageHelper;

    @Autowired
    public CustomerProfileService(@Qualifier(value="crowdService") CrowdService crowdService, UserFactory sdUserFactory, TimeZoneService timezoneService, UserAvatarCreateService userAvatarService, UserPreferencesManager userPreferencesManager, I18nHelper i18nHelper, ApplicationProperties applicationProperties, FeatureManager featureManager, UserLanguageHelper userLanguageHelper) {
        this.crowdService = crowdService;
        this.sdUserFactory = sdUserFactory;
        this.timezoneService = timezoneService;
        this.userAvatarService = userAvatarService;
        this.userPreferencesManager = userPreferencesManager;
        this.i18nHelper = i18nHelper;
        this.applicationProperties = applicationProperties;
        this.featureManager = featureManager;
        this.userLanguageHelper = userLanguageHelper;
    }

    public Either<ValidationErrors, Either<AnError, CheckedUser>> updateProfile(CheckedUser user, ProfileUpdateRequest req) {
        return (Either)this.validateRequest(req).fold(() -> Either.right(this.updateUserWithValidatedRequest(user, req)), Either::left);
    }

    private Either<AnError, CheckedUser> updateUserWithValidatedRequest(CheckedUser user, ProfileUpdateRequest req) {
        try {
            CheckedUser updatedUser = this.updateUserBasicInfo(user, req);
            this.updateUserTimezone(req, updatedUser);
            this.updateUserAvatar(req, updatedUser);
            this.updateNotificationType(req, updatedUser);
            this.updateUserLocale(req, updatedUser);
            return Either.right((Object)updatedUser);
        }
        catch (AtlassianCoreException | InvalidUserException | OperationNotPermittedException e) {
            throw new RuntimeException(e);
        }
    }

    private void updateNotificationType(ProfileUpdateRequest req, CheckedUser updatedUser) throws AtlassianCoreException {
        if (req.getNotificationType().isDefined()) {
            String notificationType = (String)req.getNotificationType().get();
            this.getUserPreferences(updatedUser).setText("user.notifications.mimetype", notificationType);
        }
    }

    private void updateUserAvatar(ProfileUpdateRequest req, CheckedUser updatedUser) {
        req.getAvatar().forEach(avatarUri -> this.userAvatarService.createAndAssign(updatedUser, (String)avatarUri));
    }

    private void updateUserTimezone(ProfileUpdateRequest req, CheckedUser updatedUser) {
        req.getTimezone().forEach(timeZone -> {
            if ("JIRA".equals(timeZone)) {
                this.timezoneService.clearUserDefaultTimeZone(this.getJiraServiceContext(updatedUser));
            } else {
                this.timezoneService.setUserDefaultTimeZone(timeZone, this.getJiraServiceContext(updatedUser));
            }
        });
    }

    private CheckedUser updateUserBasicInfo(CheckedUser user, ProfileUpdateRequest req) throws InvalidUserException, OperationNotPermittedException {
        if (req.getDisplayName().isDefined() || req.getEmail().isDefined()) {
            UserTemplate template = new UserTemplate(ApplicationUsers.toDirectoryUser((ApplicationUser)user.forJIRA()));
            req.getDisplayName().forEach(arg_0 -> ((UserTemplate)template).setDisplayName(arg_0));
            req.getEmail().forEach(arg_0 -> ((UserTemplate)template).setEmailAddress(arg_0));
            ApplicationUser userFromTemplate = ApplicationUsers.from((User)this.crowdService.updateUser((User)template));
            return (CheckedUser)this.sdUserFactory.wrap(userFromTemplate).getOrThrow(() -> new RuntimeException("Wrapping user has failed as this was a left, not a right"));
        }
        return user;
    }

    private void updateUserLocale(ProfileUpdateRequest req, CheckedUser checkedUser) throws AtlassianCoreException {
        if (req.getLanguageKey().isDefined() && this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_MULTI_LANGUAGE)) {
            Locale inputLocale;
            String languageKey = (String)req.getLanguageKey().get();
            Locale defaultLocale = this.applicationProperties.getDefaultLocale();
            if (Objects.equals(defaultLocale, inputLocale = LocaleParser.parseLocale((String)languageKey))) {
                String currentLocale = this.getUserPreferences(checkedUser).getString("jira.user.locale");
                if (currentLocale != null) {
                    this.getUserPreferences(checkedUser).remove("jira.user.locale");
                }
            } else {
                this.getUserPreferences(checkedUser).setString("jira.user.locale", (String)req.getLanguageKey().get());
            }
        }
    }

    private ExtendedPreferences getUserPreferences(CheckedUser checkedUser) {
        return this.userPreferencesManager.getExtendedPreferences(checkedUser.forJIRA());
    }

    @VisibleForTesting
    Option<ValidationErrors> validateRequest(ProfileUpdateRequest req) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        this.validateUserName(req, (ErrorCollection)errorCollection);
        this.validateEmail(req, (ErrorCollection)errorCollection);
        this.validateLanguageKey(req, (ErrorCollection)errorCollection);
        if (errorCollection.hasAnyErrors()) {
            return Option.some((Object)ValidationErrors.newBuilder((ErrorCollection)errorCollection).build());
        }
        return Option.none();
    }

    private void validateUserName(ProfileUpdateRequest req, ErrorCollection errorCollection) {
        if (req.getDisplayName().isDefined()) {
            String fullName = (String)req.getDisplayName().get();
            if (StringUtils.isEmpty((String)fullName)) {
                errorCollection.addError("displayName", this.getText("cv.profile.error.name.empty"));
            } else if (fullName.length() > 255) {
                errorCollection.addError("displayName", this.getText("cv.profile.error.name.too.long"));
            }
        }
    }

    private void validateEmail(ProfileUpdateRequest req, ErrorCollection errorCollection) {
        if (req.getEmail().isDefined()) {
            String email = (String)req.getEmail().get();
            if (StringUtils.isEmpty((String)email)) {
                errorCollection.addError("email", this.getText("cv.profile.error.email.empty"));
            } else if (email.length() > 255) {
                errorCollection.addError("email", this.getText("cv.profile.error.email.too.long"));
            } else if (!EmailUtil.isEmailAddressValid(email)) {
                errorCollection.addError("email", this.getText("cv.profile.error.email.invalid"));
            }
        }
    }

    private void validateLanguageKey(ProfileUpdateRequest req, ErrorCollection errorCollection) {
        if (req.getLanguageKey().isDefined()) {
            if (!this.isAvailableInInstalledLanguages((String)req.getLanguageKey().get())) {
                errorCollection.addError("languageKey", this.getText("cv.profile.error.languageKey.invalid"));
            }
            req.getLanguageKey().isEmpty();
        }
    }

    boolean isAvailableInInstalledLanguages(String languageKey) {
        return this.userLanguageHelper.getInstalledLocales().contains(LocaleParser.parseLocale((String)languageKey));
    }

    private String getText(String i18nKey) {
        return this.i18nHelper.getText(i18nKey);
    }

    private JiraServiceContext getJiraServiceContext(CheckedUser user) {
        return new JiraServiceContextImpl(user.forJIRA());
    }
}

