/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.user;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.exception.FailedAuthenticationException;
import com.atlassian.jira.plugin.user.PasswordPolicyManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.error.ValidationErrors;
import com.atlassian.servicedesk.internal.rest.customers.request.ChangePasswordRequest;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class CustomerPasswordService {
    private final CrowdService crowdService;
    private final PasswordPolicyManager passwordPolicyManager;
    private final UserUtil userUtil;
    private final ErrorResultHelper errorResultHelper;
    private final I18nHelper i18nHelper;

    @Autowired
    public CustomerPasswordService(@Qualifier(value="crowdService") CrowdService crowdService, PasswordPolicyManager passwordPolicyManager, UserUtil userUtil, ErrorResultHelper errorResultHelper, I18nHelper i18nHelper) {
        this.crowdService = crowdService;
        this.passwordPolicyManager = passwordPolicyManager;
        this.userUtil = userUtil;
        this.errorResultHelper = errorResultHelper;
        this.i18nHelper = i18nHelper;
    }

    public Either<ValidationErrors, Either<AnError, CheckedUser>> changePassword(CheckedUser user, ChangePasswordRequest req) {
        return (Either)this.validatePasswordChange(user, req).fold(() -> Either.right(this.changePasswordWithValidatedRequest(user, req)), Either::left);
    }

    private Either<AnError, CheckedUser> changePasswordWithValidatedRequest(CheckedUser user, ChangePasswordRequest req) {
        try {
            this.userUtil.changePassword(user.forJIRA(), (String)req.getPassword().get());
            return Either.right((Object)user);
        }
        catch (Exception ex) {
            return Either.left((Object)this.errorResultHelper.badRequest400("admin.setpassword.osuser.immutable.exception", new Object[0]).build());
        }
    }

    @VisibleForTesting
    Option<ValidationErrors> validatePasswordChange(CheckedUser user, ChangePasswordRequest req) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (req.getCurrent().isEmpty()) {
            errorCollection.addError("current", this.getText("cv.profile.changepassword.current.none.error"));
        } else {
            try {
                this.crowdService.authenticate(user.getName(), (String)req.getCurrent().get());
            }
            catch (FailedAuthenticationException e) {
                errorCollection.addError("current", this.getText("cv.profile.changepassword.current.incorrect.error"));
            }
        }
        if (req.getPassword().isEmpty()) {
            errorCollection.addError("password", this.getText("cv.profile.changepassword.new.none.error"));
        }
        if (req.getConfirm().isEmpty()) {
            errorCollection.addError("confirm", this.getText("cv.profile.changepassword.confirm.none.error"));
        }
        if (errorCollection.hasAnyErrors()) {
            return Option.some((Object)ValidationErrors.newBuilder((ErrorCollection)errorCollection).build());
        }
        String currentPassword = (String)req.getCurrent().get();
        String newPassword = (String)req.getPassword().get();
        String confirmPassword = (String)req.getConfirm().get();
        if (!confirmPassword.equals(newPassword)) {
            errorCollection.addError("confirm", this.getText("cv.profile.changepassword.confirm.incorrect.error"));
        } else if (!this.passwordPolicyManager.checkPolicy(user.forJIRA(), currentPassword, newPassword).isEmpty()) {
            errorCollection.addError("password", this.getText("sd.password.set.rejected"));
        }
        if (errorCollection.hasAnyErrors()) {
            return Option.some((Object)ValidationErrors.newBuilder((ErrorCollection)errorCollection).build());
        }
        return Option.none();
    }

    private String getText(String i18nKey) {
        return this.i18nHelper.getText(i18nKey);
    }
}

