/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.transitions.configurations;

import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.workflows.SDWorkflowService;
import com.atlassian.servicedesk.internal.feature.customer.transitions.configurations.WorkflowCustomerTransitionConfiguration;
import com.atlassian.servicedesk.internal.feature.customer.transitions.configurations.WorkflowCustomerTransitionConfigurationManager;
import com.atlassian.servicedesk.internal.feature.customer.transitions.configurations.WorkflowCustomerTransitionConfigurationService;
import com.atlassian.servicedesk.internal.feature.customer.transitions.error.CustomerTransitionError;
import com.atlassian.servicedesk.internal.rest.customers.transitions.configurations.WorkflowCustomerTransitionRequest;
import com.opensymphony.workflow.loader.ActionDescriptor;
import io.atlassian.fugue.Either;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkflowCustomerTransitionConfigurationServiceImpl
implements WorkflowCustomerTransitionConfigurationService {
    private final WorkflowCustomerTransitionConfigurationManager configurationManager;
    private final CustomerTransitionError customerTransitionError;
    private final SDWorkflowService sdWorkflowService;

    @Autowired
    public WorkflowCustomerTransitionConfigurationServiceImpl(WorkflowCustomerTransitionConfigurationManager configurationManager, CustomerTransitionError customerTransitionError, SDWorkflowService sdWorkflowService) {
        this.configurationManager = configurationManager;
        this.customerTransitionError = customerTransitionError;
        this.sdWorkflowService = sdWorkflowService;
    }

    @Override
    public Either<AnError, List<WorkflowCustomerTransitionConfiguration>> getConfigurations(CheckedUser user, JiraWorkflow workflow) {
        return Steps.begin(this.canConfigureTransition(user, workflow)).yield(checkedUser -> this.configurationManager.getConfigurations(workflow));
    }

    @Override
    public Either<AnError, WorkflowCustomerTransitionConfiguration> activateConfiguration(CheckedUser user, JiraWorkflow workflow, ActionDescriptor actionDescriptor, WorkflowCustomerTransitionRequest configureCustomerTransitionRequest) {
        return Steps.begin(this.canConfigureTransition(user, workflow)).then(checkedUser -> this.configurationManager.activateConfiguration(workflow, actionDescriptor, configureCustomerTransitionRequest)).yield((checkedUser, updatedConfiguration) -> updatedConfiguration);
    }

    @Override
    public Either<AnError, WorkflowCustomerTransitionConfiguration> deactivateConfiguration(CheckedUser user, JiraWorkflow workflow, ActionDescriptor actionDescriptor) {
        return Steps.begin(this.canConfigureTransition(user, workflow)).then(checkedUser -> this.configurationManager.deactivateConfiguration(workflow, actionDescriptor)).yield((checkedUser, updatedConfiguration) -> updatedConfiguration);
    }

    private Either<AnError, CheckedUser> canConfigureTransition(@Nonnull CheckedUser user, @Nonnull JiraWorkflow workflow) {
        if (this.sdWorkflowService.hasEditWorkflowPermission(user, workflow)) {
            return Either.right((Object)user);
        }
        return Either.left((Object)this.customerTransitionError.NO_CONFIGURE_TRANSITION_PERMISSION());
    }
}

