/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.transitions.configurations;

import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.internal.api.util.WorkflowHelper;
import com.atlassian.servicedesk.internal.feature.customer.transitions.configurations.WorkflowCustomerTransitionConfiguration;
import com.atlassian.servicedesk.internal.feature.customer.transitions.configurations.WorkflowCustomerTransitionConfigurationManager;
import com.atlassian.servicedesk.internal.rest.customers.transitions.configurations.WorkflowCustomerTransitionRequest;
import com.opensymphony.workflow.loader.ActionDescriptor;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Maybe;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkflowCustomerTransitionConfigurationManagerImpl
implements WorkflowCustomerTransitionConfigurationManager {
    private final WorkflowHelper workflowHelper;

    @Autowired
    public WorkflowCustomerTransitionConfigurationManagerImpl(WorkflowHelper workflowHelper) {
        this.workflowHelper = workflowHelper;
    }

    @Override
    public Option<WorkflowCustomerTransitionConfiguration> getConfiguration(ActionDescriptor actionDescriptor) {
        Map transitionProperties = actionDescriptor.getMetaAttributes();
        if (!transitionProperties.containsKey("servicedesk.customer.transition.active")) {
            return Option.none();
        }
        return Option.some((Object)this.buildTransitionConfiguration(actionDescriptor));
    }

    @Override
    public List<WorkflowCustomerTransitionConfiguration> getConfigurations(JiraWorkflow workflow) {
        return this.workflowHelper.getAllActions(workflow).stream().map(this::getConfiguration).filter(Maybe::isDefined).map(Maybe::get).collect(Collectors.toList());
    }

    @Override
    public Either<AnError, WorkflowCustomerTransitionConfiguration> activateConfiguration(JiraWorkflow workflow, ActionDescriptor actionDescriptor, WorkflowCustomerTransitionRequest configureCustomerTransitionRequest) {
        return this.updateActive(workflow, actionDescriptor, true, configureCustomerTransitionRequest.getResolutionId()).map(this::buildTransitionConfiguration);
    }

    @Override
    public Either<AnError, WorkflowCustomerTransitionConfiguration> deactivateConfiguration(JiraWorkflow workflow, ActionDescriptor actionDescriptor) {
        return this.updateActive(workflow, actionDescriptor, false, null).map(this::buildTransitionConfiguration);
    }

    private Either<AnError, ActionDescriptor> updateActive(JiraWorkflow workflow, ActionDescriptor actionDescriptor, boolean active, String resolutionId) {
        Map transitionProperties = actionDescriptor.getMetaAttributes();
        transitionProperties.put("servicedesk.customer.transition.active", active);
        if (resolutionId != null) {
            transitionProperties.put("servicedesk.customer.transition.resolution", resolutionId);
        }
        return this.workflowHelper.saveWorkflow(workflow).map(savedWorkflow -> actionDescriptor);
    }

    private WorkflowCustomerTransitionConfiguration buildTransitionConfiguration(ActionDescriptor actionDescriptor) {
        Map transitionProperties = actionDescriptor.getMetaAttributes();
        boolean active = Boolean.parseBoolean(this.getPropertyAsString(transitionProperties, "servicedesk.customer.transition.active"));
        String resolutionId = this.getPropertyAsString(transitionProperties, "servicedesk.customer.transition.resolution");
        return new WorkflowCustomerTransitionConfiguration.Builder().transitionId(String.valueOf(actionDescriptor.getId())).resolutionId(resolutionId).isActive(active).build();
    }

    private String getPropertyAsString(Map propertySet, String key) {
        return propertySet.getOrDefault(key, "").toString();
    }
}

