/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.transitions;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.request.transition.CustomerTransition;
import com.atlassian.servicedesk.api.request.transition.CustomerTransitionExecutionParameters;
import com.atlassian.servicedesk.api.request.transition.CustomerTransitionQuery;
import com.atlassian.servicedesk.api.request.transition.CustomerTransitionService;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequest;
import com.atlassian.servicedesk.api.util.paging.PagedResponse;
import com.atlassian.servicedesk.api.util.paging.PagedResponseImpl;
import com.atlassian.servicedesk.internal.api.error.ValidationErrors;
import com.atlassian.servicedesk.internal.errors.ValidationErrorsHelper;
import com.atlassian.servicedesk.internal.feature.customer.request.InternalCustomerRequestService;
import com.atlassian.servicedesk.internal.feature.customer.transitions.CustomerTransitionExecutionParametersImpl;
import com.atlassian.servicedesk.internal.feature.customer.transitions.CustomerTransitionInternalService;
import com.atlassian.servicedesk.internal.feature.customer.transitions.CustomerTransitionQueryImpl;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class CustomerTransitionServiceImpl
implements CustomerTransitionService {
    private CustomerTransitionInternalService customerTransitionInternalService;
    private InternalCustomerRequestService internalCustomerRequestService;
    private ValidationErrorsHelper validationErrorsHelper;
    private UserFactory userFactory;

    @Autowired
    public CustomerTransitionServiceImpl(CustomerTransitionInternalService customerTransitionInternalService, InternalCustomerRequestService internalCustomerRequestService, ValidationErrorsHelper validationErrorsHelper, UserFactory userFactory) {
        this.customerTransitionInternalService = customerTransitionInternalService;
        this.internalCustomerRequestService = internalCustomerRequestService;
        this.validationErrorsHelper = validationErrorsHelper;
        this.userFactory = userFactory;
    }

    public CustomerTransitionQuery.Builder newQueryBuilder() {
        return CustomerTransitionQueryImpl.builder();
    }

    public Either<AnError, PagedResponse<CustomerTransition>> getCustomerTransitions(@Nonnull ApplicationUser user, @Nonnull CustomerTransitionQuery customerTransitionQuery) {
        return StepsConverters.olderEither((io.atlassian.fugue.Either)Steps.begin((io.atlassian.fugue.Either)this.internalCustomerRequestService.getRequestForId(user, customerTransitionQuery.issue()).map(issue -> this.customerTransitionInternalService.getAvailableCustomerTransitions(user, (Issue)issue))).yield(availableTransitions -> PagedResponseImpl.toPagedResponse((LimitedPagedRequest)customerTransitionQuery.pagedRequest(), (List)availableTransitions)));
    }

    public CustomerTransitionExecutionParameters.Builder newExecuteParameterBuilder() {
        return CustomerTransitionExecutionParametersImpl.builder();
    }

    public Either<AnError, Issue> executeCustomerTransition(ApplicationUser user, CustomerTransitionExecutionParameters customerTransitionExecutionParameters) {
        return StepsConverters.olderEither((io.atlassian.fugue.Either)Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(user))).then(checkedUser -> this.customerTransitionInternalService.executeCustomerTransition(user, customerTransitionExecutionParameters)).then((checkedUser, r) -> r.leftMap(e -> this.validationErrorsHelper.convertToAnError((CheckedUser)checkedUser, (ValidationErrors)e))).yield((checkedUser, r, issue) -> issue));
    }
}

