/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.transitions;

import com.atlassian.servicedesk.api.request.CustomerRequest;
import com.atlassian.servicedesk.api.request.transition.CustomerTransitionExecutionParameters;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CustomerTransitionExecutionParametersImpl
implements CustomerTransitionExecutionParameters {
    private CustomerRequest request;
    private Integer transitionId;
    private String comment;

    public CustomerTransitionExecutionParametersImpl(CustomerRequest request, Integer transitionId, String comment) {
        this.request = request;
        this.transitionId = transitionId;
        this.comment = comment;
    }

    public CustomerRequest request() {
        return this.request;
    }

    public Integer transitionId() {
        return this.transitionId;
    }

    public String comment() {
        return this.comment;
    }

    public static CustomerTransitionExecutionParameters.Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements CustomerTransitionExecutionParameters.Builder {
        private Integer transitionId;
        private CustomerRequest request;
        private String comment;

        public Builder request(@Nonnull CustomerRequest request) {
            this.request = request;
            return this;
        }

        public Builder transitionId(@Nonnull Integer transition) {
            this.transitionId = transition;
            return this;
        }

        public Builder comment(@Nullable String comment) {
            this.comment = comment;
            return this;
        }

        public CustomerTransitionExecutionParametersImpl build() {
            return new CustomerTransitionExecutionParametersImpl(this.request, this.transitionId, this.comment);
        }
    }
}

