/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.search.user;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.feature.customer.search.user.CustomerSearchManager;
import com.atlassian.servicedesk.internal.feature.customer.search.user.CustomerSearchService;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.atlassian.servicedesk.internal.user.permission.ServiceDeskPermissions;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerSearchServiceImpl
implements CustomerSearchService {
    private final CustomerSearchManager customerSearchManager;
    private final CommonErrors commonErrors;
    private final FeatureManager featureManager;
    private final ServiceDeskPermissions serviceDeskPermissions;

    @Autowired
    public CustomerSearchServiceImpl(CustomerSearchManager customerSearchManager, CommonErrors commonErrors, FeatureManager featureManager, ServiceDeskPermissions serviceDeskPermissions) {
        this.customerSearchManager = customerSearchManager;
        this.commonErrors = commonErrors;
        this.featureManager = featureManager;
        this.serviceDeskPermissions = serviceDeskPermissions;
    }

    @Override
    @Nonnull
    public Either<AnError, Collection<CheckedUser>> searchForCustomers(@Nonnull CheckedUser searcher, @Nonnull Project project, @Nonnull String queryString, int limit) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return Either.left((Object)this.commonErrors.FEATURE_NOT_ENABLED());
        }
        if (!this.serviceDeskPermissions.canViewServiceDesk((SDUser)searcher, project)) {
            return Either.left((Object)this.commonErrors.PORTAL_NOT_AUTHORISED());
        }
        return this.customerSearchManager.searchForCustomers(searcher, project, queryString, limit);
    }

    @Override
    @Nonnull
    public Either<AnError, Collection<CheckedUser>> searchForCustomers(@Nonnull CheckedUser searcher, @Nonnull Project project, @Nonnull ServiceDesk serviceDesk, @Nonnull String queryString, int limit, @Nonnull String fieldName, @Nonnull Option<String> fieldConfigId) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return Either.left((Object)this.commonErrors.FEATURE_NOT_ENABLED());
        }
        if (!this.serviceDeskPermissions.canViewServiceDesk((SDUser)searcher, project)) {
            return Either.left((Object)this.commonErrors.PORTAL_NOT_AUTHORISED());
        }
        return this.customerSearchManager.searchForCustomers(searcher, project, serviceDesk, queryString, limit, fieldName, fieldConfigId);
    }
}

