/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.search.permission;

import com.atlassian.jira.project.Project;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.internal.feature.customer.search.permission.CustomerShareSearchCapabilityChecker;
import com.atlassian.servicedesk.internal.feature.reqparticipants.settings.ParticipantSettingsManager;
import com.atlassian.servicedesk.internal.user.permission.ServiceDeskPermissions;
import com.atlassian.servicedesk.workinprogressapi.participantsettings.ParticipantSettingsConfiguration;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerShareSearchCapabilityCheckerImpl
implements CustomerShareSearchCapabilityChecker {
    private final ParticipantSettingsManager participantSettingsManager;
    private final ServiceDeskPermissions serviceDeskPermissions;

    @Autowired
    public CustomerShareSearchCapabilityCheckerImpl(ParticipantSettingsManager participantSettingsManager, ServiceDeskPermissions serviceDeskPermissions) {
        this.participantSettingsManager = participantSettingsManager;
        this.serviceDeskPermissions = serviceDeskPermissions;
    }

    @Override
    public boolean canSearchAllCustomersInProject(@Nonnull CheckedUser user, @Nonnull ServiceDesk serviceDesk, @Nonnull Project project) {
        if (this.serviceDeskPermissions.canViewAgentView((SDUser)user, project)) {
            return true;
        }
        ParticipantSettingsConfiguration settings = this.participantSettingsManager.getSettings(serviceDesk);
        return settings.getParticipantAutocompleteEnabled() && settings.getParticipantManagementEnabled();
    }

    @Override
    public boolean canSearchAllOrganizationsInProject(@Nonnull CheckedUser user, @Nonnull ServiceDesk serviceDesk, @Nonnull Project project) {
        if (this.serviceDeskPermissions.canViewAgentView((SDUser)user, project)) {
            return true;
        }
        ParticipantSettingsConfiguration settings = this.participantSettingsManager.getSettings(serviceDesk);
        return settings.getParticipantAutocompleteEnabled() && settings.getParticipantManagementEnabled();
    }
}

