/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.search.organization;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.ServiceDeskManager;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.feature.customer.search.organization.OrganizationSearchManager;
import com.atlassian.servicedesk.internal.feature.customer.search.permission.CustomerShareSearchCapabilityChecker;
import com.atlassian.servicedesk.internal.feature.customer.search.util.SearchCollectionUtil;
import com.atlassian.servicedesk.internal.feature.organization.dao.CustomerOrganizationMemberQStore;
import com.atlassian.servicedesk.internal.feature.organization.dao.CustomerOrganizationProjectQStore;
import com.atlassian.servicedesk.internal.feature.organization.model.CustomerOrganizationWithMemberCount;
import com.atlassian.servicedesk.internal.feature.organization.model.CustomerOrganizationWithOtherProjectCount;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public class OrganizationSearchManagerImpl
implements OrganizationSearchManager {
    private final CustomerShareSearchCapabilityChecker shareSearchCapabilityChecker;
    private final ServiceDeskManager serviceDeskManager;
    private final CustomerOrganizationProjectQStore customerOrganizationProjectQStore;
    private final CustomerOrganizationMemberQStore memberQStore;

    @Autowired
    public OrganizationSearchManagerImpl(CustomerShareSearchCapabilityChecker shareSearchCapabilityChecker, ServiceDeskManager serviceDeskManager, CustomerOrganizationProjectQStore customerOrganizationProjectQStore, CustomerOrganizationMemberQStore memberQStore) {
        this.shareSearchCapabilityChecker = shareSearchCapabilityChecker;
        this.serviceDeskManager = serviceDeskManager;
        this.customerOrganizationProjectQStore = customerOrganizationProjectQStore;
        this.memberQStore = memberQStore;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, Collection<CustomerOrganization>> searchForOrganizations(CheckedUser searcher, Project project, String queryString, Set<CustomerOrganization> excludedOrganizations, int limit) {
        io.atlassian.fugue.Either serviceDeskForProject = StepsConverters.newerEither((Either)this.serviceDeskManager.getServiceDeskForProject(project));
        if (serviceDeskForProject.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)serviceDeskForProject.left().get());
        }
        if (this.shareSearchCapabilityChecker.canSearchAllOrganizationsInProject(searcher, (ServiceDesk)serviceDeskForProject.right().get(), project)) {
            return io.atlassian.fugue.Either.right(this.searchForOrganizationsInProject(project, queryString, excludedOrganizations, limit));
        }
        return io.atlassian.fugue.Either.right(this.searchForMyOrganizationsInProject(searcher, project, queryString, excludedOrganizations, limit));
    }

    @Override
    public io.atlassian.fugue.Either<AnError, Collection<CustomerOrganizationWithMemberCount>> searchForOrganizationsWithMemberCount(String queryString, int limit) {
        List<CustomerOrganizationWithMemberCount> result = this.memberQStore.findOrganizationWithMemberCount(queryString);
        return io.atlassian.fugue.Either.right(SearchCollectionUtil.limitReturnResult(result, limit));
    }

    @Override
    public io.atlassian.fugue.Either<AnError, Collection<CustomerOrganizationWithOtherProjectCount>> searchForOrganizationsWithOtherProjectCount(Project projectToExcludeFromCount, String queryString, int limit) {
        return io.atlassian.fugue.Either.right(this.customerOrganizationProjectQStore.findAllOrganizationsWithOtherProjectsCount(projectToExcludeFromCount.getId(), queryString, limit));
    }

    private Collection<CustomerOrganization> searchForMyOrganizationsInProject(CheckedUser searcher, Project project, String queryString, Set<CustomerOrganization> excludedOrganizations, int limit) {
        Collection<CustomerOrganization> customerOrganizations = this.customerOrganizationProjectQStore.findUserOrganization(searcher.getKey(), project.getId(), queryString);
        return SearchCollectionUtil.limitReturnResult(this.filterExcludedOrganizations(customerOrganizations, excludedOrganizations), limit);
    }

    private Collection<CustomerOrganization> searchForOrganizationsInProject(Project project, String queryString, Set<CustomerOrganization> excludedOrganizations, int limit) {
        Collection<CustomerOrganization> customerOrganizations = this.customerOrganizationProjectQStore.findOrganizationsInProject(project.getId(), queryString);
        return SearchCollectionUtil.limitReturnResult(this.filterExcludedOrganizations(customerOrganizations, excludedOrganizations), limit);
    }

    private Collection<CustomerOrganization> filterExcludedOrganizations(Collection<CustomerOrganization> customerOrganizations, Set<CustomerOrganization> excludedOrganizations) {
        HashSet<CustomerOrganization> result = new HashSet<CustomerOrganization>(customerOrganizations);
        result.removeAll(excludedOrganizations);
        return result;
    }
}

