/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.search.organization;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.feature.customer.search.organization.OrganisationSearchService;
import com.atlassian.servicedesk.internal.feature.customer.search.organization.OrganizationSearchManager;
import com.atlassian.servicedesk.internal.feature.organization.model.CustomerOrganizationWithMemberCount;
import com.atlassian.servicedesk.internal.feature.organization.model.CustomerOrganizationWithOtherProjectCount;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.atlassian.servicedesk.internal.user.license.ServiceDeskUserLicenseService;
import com.atlassian.servicedesk.internal.user.permission.ServiceDeskPermissions;
import io.atlassian.fugue.Either;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public class OrganisationSearchServiceImpl
implements OrganisationSearchService {
    private final OrganizationSearchManager organizationSearchManager;
    private final ServiceDeskPermissions serviceDeskPermissions;
    private final FeatureManager featureManager;
    private final CommonErrors commonErrors;
    private final ServiceDeskUserLicenseService userLicenseService;

    @Autowired
    public OrganisationSearchServiceImpl(OrganizationSearchManager organizationSearchManager, ServiceDeskPermissions serviceDeskPermissions, FeatureManager featureManager, CommonErrors commonErrors, ServiceDeskUserLicenseService userLicenseService) {
        this.organizationSearchManager = organizationSearchManager;
        this.serviceDeskPermissions = serviceDeskPermissions;
        this.featureManager = featureManager;
        this.commonErrors = commonErrors;
        this.userLicenseService = userLicenseService;
    }

    @Override
    public Either<AnError, Collection<CustomerOrganization>> searchForOrganisations(CheckedUser searcher, Project project, String queryString, int limit) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return Either.left((Object)this.commonErrors.FEATURE_NOT_ENABLED());
        }
        if (!this.serviceDeskPermissions.canViewServiceDesk((SDUser)searcher, project)) {
            return Either.left((Object)this.commonErrors.PORTAL_NOT_AUTHORISED());
        }
        return this.organizationSearchManager.searchForOrganizations(searcher, project, queryString, Collections.emptySet(), limit);
    }

    @Override
    public Either<AnError, Collection<CustomerOrganizationWithMemberCount>> searchForOrganisationsWithMemberCount(CheckedUser searcher, String queryString, int limit) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return Either.left((Object)this.commonErrors.FEATURE_NOT_ENABLED());
        }
        if (!this.userLicenseService.hasValidAgentLicense((SDUser)searcher)) {
            return Either.left((Object)this.commonErrors.AGENT_PERMISSIONS_ERROR());
        }
        return this.organizationSearchManager.searchForOrganizationsWithMemberCount(queryString, limit);
    }

    @Override
    public Either<AnError, Collection<CustomerOrganizationWithOtherProjectCount>> searchForOrganisationsWithOtherProjectCount(CheckedUser searcher, Project projectToExcludeFromCount, String queryString, int limit) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return Either.left((Object)this.commonErrors.FEATURE_NOT_ENABLED());
        }
        if (!this.userLicenseService.hasValidAgentLicense((SDUser)searcher)) {
            return Either.left((Object)this.commonErrors.AGENT_PERMISSIONS_ERROR());
        }
        return this.organizationSearchManager.searchForOrganizationsWithOtherProjectCount(projectToExcludeFromCount, queryString, limit);
    }
}

