/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request.requesttype.icon;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.servicedesk.internal.api.requesttype.RequestTypeSystemIconService;
import com.atlassian.servicedesk.internal.api.requesttype.icons.RequestTypeSystemIcon;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.icon.RequestTypeIconDefinition;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class RequestTypeSystemIconServiceImpl
implements RequestTypeSystemIconService {
    private final AvatarManager avatarManager;

    @Autowired
    public RequestTypeSystemIconServiceImpl(AvatarManager avatarManager) {
        this.avatarManager = avatarManager;
    }

    public Long getDefaultIconID() {
        return this.avatarManager.getDefaultAvatarId(RequestTypeIconDefinition.ICON_TYPE);
    }

    public Long getIconIdForSystemIcon(RequestTypeSystemIcon systemIcon) {
        List systemAvatars = this.avatarManager.getAllSystemAvatars(RequestTypeIconDefinition.ICON_TYPE);
        Optional<Avatar> avatar = systemAvatars.stream().filter(a -> a.getFileName().equals(systemIcon.getFilename())).findFirst();
        return avatar.map(Avatar::getId).orElse(0L);
    }
}

