/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request.requesttype.field.value;

import com.atlassian.servicedesk.internal.ao.schema.current.ServiceDeskDbSchema;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.field.value.PartialRequestTypeFieldValue;
import java.util.Comparator;
import org.apache.commons.lang.StringUtils;

public class RequestTypeFieldValue {
    private final int id;
    private final int fieldId;
    private final String fieldName;
    private final String value;
    private int order;

    public RequestTypeFieldValue(int id, int fieldId, String fieldName, String value, int order) {
        this.id = id;
        this.fieldId = fieldId;
        this.fieldName = fieldName;
        this.value = value;
        this.order = order;
    }

    public RequestTypeFieldValue(ServiceDeskDbSchema.RequestTypeFieldValueAO valueAO) {
        this.id = valueAO.getID();
        this.fieldId = valueAO.getField().getID();
        this.fieldName = StringUtils.defaultString((String)valueAO.getFieldName());
        this.value = StringUtils.defaultString((String)valueAO.getValue());
        this.order = valueAO.getValueOrder();
    }

    public RequestTypeFieldValue(PartialRequestTypeFieldValue v) {
        this.id = 0;
        this.fieldId = 0;
        this.fieldName = v.getFieldName();
        this.value = v.getValue();
        this.order = v.getOrder();
    }

    public int getId() {
        return this.id;
    }

    public int getFieldId() {
        return this.fieldId;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getValue() {
        return this.value;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestTypeFieldValue that = (RequestTypeFieldValue)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return this.id;
    }

    public static class RequestTypeFieldValueOrderComparator
    implements Comparator<RequestTypeFieldValue> {
        @Override
        public int compare(RequestTypeFieldValue e1, RequestTypeFieldValue e2) {
            return Integer.compare(e1.getOrder(), e2.getOrder());
        }
    }
}

