/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request.requesttype.field;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.field.CustomerRequestCreateMeta;
import com.atlassian.servicedesk.api.field.FieldId;
import com.atlassian.servicedesk.api.field.RequestTypeField;
import com.atlassian.servicedesk.api.field.RequestTypeFieldQuery;
import com.atlassian.servicedesk.api.field.RequestTypeFieldService;
import com.atlassian.servicedesk.api.field.RequestTypeFieldValue;
import com.atlassian.servicedesk.api.field.impl.RequestTypeFieldValueImpl;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.feature.servicedesk.InternalServiceDeskService;
import com.atlassian.servicedesk.internal.api.project.InternalServiceDeskProjectManager;
import com.atlassian.servicedesk.internal.api.requesttype.RequestTypeInternalService;
import com.atlassian.servicedesk.internal.feature.customer.portal.InternalPortalService;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.field.CustomerRequestCreateMetaImpl;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.field.RequestTypeFieldImpl;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.field.RequestTypeFieldInternalManager;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.field.RequestTypeFieldMetaPredicate;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.field.RequestTypeFieldQueryImpl;
import com.atlassian.servicedesk.internal.feature.jira.issuetype.ServiceDeskIssueTypeManager;
import com.atlassian.servicedesk.internal.feature.reqparticipants.permission.RequestParticipantPermissionService;
import com.atlassian.servicedesk.internal.rest.responses.JiraFieldValue;
import com.atlassian.servicedesk.internal.rest.responses.UserFieldView;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class RequestTypeFieldServiceImpl
implements RequestTypeFieldService {
    private final UserFactory userFactory;
    private final RequestTypeFieldInternalManager requestTypeFieldInternalManager;
    private final InternalServiceDeskService serviceDeskService;
    private final InternalServiceDeskProjectManager sdProjectManager;
    private final InternalPortalService portalService;
    private final RequestTypeInternalService requestTypeService;
    private final ServiceDeskIssueTypeManager sdIssueTypeManager;
    private final RequestParticipantPermissionService requestParticipantPermissionService;

    @Autowired
    public RequestTypeFieldServiceImpl(UserFactory userFactory, RequestTypeFieldInternalManager requestTypeFieldInternalManager, InternalServiceDeskService serviceDeskService, InternalServiceDeskProjectManager sdProjectManager, InternalPortalService portalService, RequestTypeInternalService requestTypeService, ServiceDeskIssueTypeManager sdIssueTypeManager, RequestParticipantPermissionService requestParticipantPermissionService) {
        this.userFactory = userFactory;
        this.requestTypeFieldInternalManager = requestTypeFieldInternalManager;
        this.serviceDeskService = serviceDeskService;
        this.sdProjectManager = sdProjectManager;
        this.portalService = portalService;
        this.requestTypeService = requestTypeService;
        this.sdIssueTypeManager = sdIssueTypeManager;
        this.requestParticipantPermissionService = requestParticipantPermissionService;
    }

    public RequestTypeFieldQuery.Builder newQueryBuilder() {
        return RequestTypeFieldQueryImpl.builder();
    }

    @Nonnull
    public Either<AnError, CustomerRequestCreateMeta> getCustomerRequestCreateMeta(ApplicationUser user, RequestTypeFieldQuery requestTypeFieldQuery) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"requestTypeFieldQuery", (Object)requestTypeFieldQuery);
        return Steps.begin((Either)this.userFactory.wrap(user)).then(checkedUser -> StepsConverters.olderEither(this.getAllFieldsByRequestType((CheckedUser)checkedUser, requestTypeFieldQuery))).yield((checkedUser, meta) -> meta);
    }

    private io.atlassian.fugue.Either<AnError, CustomerRequestCreateMeta> getAllFieldsByRequestType(CheckedUser checkedUser, RequestTypeFieldQuery requestTypeFieldQuery) {
        return Steps.begin((io.atlassian.fugue.Either)this.serviceDeskService.getServiceDeskById(checkedUser, (long)requestTypeFieldQuery.serviceDesk())).then(serviceDesk -> this.sdProjectManager.getProject(Long.valueOf(serviceDesk.getProjectId()))).then((serviceDesk, project) -> this.portalService.getPortalByProject(checkedUser, (Project)project)).then((serviceDesk, project, portal) -> this.getRequestType(checkedUser, (Project)project, (Portal)portal, requestTypeFieldQuery.requestType())).then((serviceDesk, project, portal, requestType) -> this.sdIssueTypeManager.getIssueTypeForProject(requestType.getIssueTypeId(), (Project)project)).yield((serviceDesk, project, portal, requestType, issueType) -> this.getRequestTypeField((ServiceDesk)serviceDesk, checkedUser, (Project)project, (RequestType)requestType, (IssueType)issueType));
    }

    private io.atlassian.fugue.Either<AnError, RequestType> getRequestType(CheckedUser checkedUser, Project project, Portal portal, int requestTypeId) {
        return this.requestTypeService.getValidRequestTypeByPortal(checkedUser, project, portal, Integer.valueOf(requestTypeId));
    }

    private CustomerRequestCreateMeta getRequestTypeField(ServiceDesk serviceDesk, CheckedUser checkedUser, Project project, RequestType requestType, IssueType issueType) {
        List<UserFieldView> userFieldViews = this.requestTypeFieldInternalManager.getUserFieldViewForRequestType(checkedUser, project, requestType, issueType);
        Iterable visibleFields = Iterables.filter(userFieldViews, (Predicate)new RequestTypeFieldMetaPredicate());
        ArrayList requestTypeFields = Lists.newArrayList((Iterable)Iterables.transform((Iterable)visibleFields, this.asPublicField(serviceDesk, requestType)));
        boolean canRaiseOnBehalfOf2 = this.canRaiseOnBehalfOf(userFieldViews);
        boolean canAddRequestParticipants = this.requestParticipantPermissionService.canCreateRequestWithAnyParticipant(checkedUser, serviceDesk, project);
        return new CustomerRequestCreateMetaImpl(requestTypeFields, canRaiseOnBehalfOf2, canAddRequestParticipants);
    }

    private boolean canRaiseOnBehalfOf(List<UserFieldView> userFieldViews) {
        return userFieldViews.stream().anyMatch(f -> "reporter".equals(f.getFieldId()));
    }

    private Function<UserFieldView, RequestTypeField> asPublicField(ServiceDesk serviceDesk, RequestType requestType) {
        return input -> new RequestTypeFieldImpl(serviceDesk, requestType, FieldId.withId((String)input.getFieldId()), input.getLabel(), input.getDescription(), input.isRequired(), (List)this.asPublicFieldValues().apply(input.getValues()));
    }

    private Function<List<JiraFieldValue>, List<RequestTypeFieldValue>> asPublicFieldValues() {
        return input -> (List)Option.option((Object)input).map(l -> Lists.transform((List)l, this.asPublicFieldValue())).getOrElse(Collections.emptyList());
    }

    private Function<JiraFieldValue, RequestTypeFieldValue> asPublicFieldValue() {
        return input -> RequestTypeFieldValueImpl.builder().value(input.getValue()).label(input.getLabel()).children(Lists.transform(input.getChildren(), this.asPublicFieldValue())).build();
    }
}

