/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request.requesttype;

import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.field.RequestTypeFieldInternal;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Option;
import java.util.List;
import javax.annotation.Nonnull;

public class RequestTypeWithFields {
    private final RequestType requestType;
    private final List<RequestTypeFieldInternal> fields;

    private RequestTypeWithFields(@Nonnull RequestType requestType, @Nonnull List<RequestTypeFieldInternal> fields) {
        this.requestType = requestType;
        this.fields = ImmutableList.copyOf(fields);
    }

    public RequestType getRequestType() {
        return this.requestType;
    }

    public List<RequestTypeFieldInternal> getFields() {
        return this.fields;
    }

    public static Option<RequestTypeWithFields> build(RequestType requestType, List<RequestTypeFieldInternal> requestTypeFields) {
        if (requestTypeFields.size() == 0) {
            return Option.none();
        }
        boolean allFieldsMatchRequestType = requestTypeFields.stream().allMatch(field -> field.getFormId() == requestType.getId());
        if (allFieldsMatchRequestType) {
            return Option.some((Object)new RequestTypeWithFields(requestType, requestTypeFields));
        }
        return Option.none();
    }
}

