/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request.requesttype;

import com.atlassian.annotations.Internal;
import com.atlassian.fugue.Option;
import com.atlassian.servicedesk.api.requesttype.RequestTypeQuery;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequest;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequestImpl;
import com.atlassian.servicedesk.api.util.paging.PagedRequest;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

@Internal
public class RequestTypeQueryImpl
implements RequestTypeQuery {
    private final Option<Boolean> isValid;
    private final Option<Integer> serviceDesk;
    private final Option<Integer> requestType;
    private final Option<Integer> group;
    private final Option<Long> issue;
    private final Option<Boolean> requestOverrideSecurity;
    private final Option<Boolean> filterHidden;
    private final LimitedPagedRequest pagedRequest;

    private RequestTypeQueryImpl(Integer serviceDesk, Integer requestType, Integer group, Long issue, Boolean requestOverrideSecurity, Boolean isValid, Boolean filterHidden, LimitedPagedRequest pagedRequest) {
        this.serviceDesk = Option.option((Object)serviceDesk);
        this.requestType = Option.option((Object)requestType);
        this.group = Option.option((Object)group);
        this.issue = Option.option((Object)issue);
        this.requestOverrideSecurity = Option.option((Object)requestOverrideSecurity);
        this.isValid = Option.option((Object)isValid);
        this.pagedRequest = pagedRequest;
        this.filterHidden = Option.some((Object)filterHidden);
    }

    public Option<Integer> serviceDesk() {
        return this.serviceDesk;
    }

    public Option<Integer> requestType() {
        return this.requestType;
    }

    public Option<Integer> group() {
        return this.group;
    }

    public Option<Long> issue() {
        return this.issue;
    }

    public Option<Boolean> requestOverrideSecurity() {
        return this.requestOverrideSecurity;
    }

    public Option<Boolean> getFilterHidden() {
        return this.filterHidden;
    }

    public LimitedPagedRequest pagedRequest() {
        return this.pagedRequest;
    }

    public Option<Boolean> isValid() {
        return this.isValid;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestTypeQueryImpl that = (RequestTypeQueryImpl)o;
        return Objects.equal(this.serviceDesk, that.serviceDesk) && Objects.equal(this.requestType, that.requestType) && Objects.equal(this.group, that.group) && Objects.equal(this.issue, that.issue) && Objects.equal(this.requestOverrideSecurity, that.requestOverrideSecurity) && Objects.equal((Object)this.pagedRequest, (Object)that.pagedRequest);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.serviceDesk, this.requestType, this.group, this.issue, this.requestOverrideSecurity, this.pagedRequest});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("serviceDesk", this.serviceDesk).add("requestType", this.requestType).add("group", this.group).add("issue", this.issue).add("requestOverrideSecurity", this.requestOverrideSecurity).add("pagedRequest", (Object)this.pagedRequest).toString();
    }

    public static final class Builder
    implements RequestTypeQuery.Builder {
        private Integer serviceDesk;
        private Integer requestType;
        private Integer group;
        private Long issue;
        private Boolean requestOverrideSecurity;
        private LimitedPagedRequest pagedRequest = LimitedPagedRequestImpl.create((int)100);
        private Boolean isValid;
        private Boolean filterHidden = false;

        private Builder() {
        }

        public Builder serviceDesk(Integer serviceDesk) {
            this.serviceDesk = serviceDesk;
            return this;
        }

        public Builder requestType(Integer requestType) {
            this.requestType = requestType;
            return this;
        }

        public RequestTypeQuery.Builder group(Integer group) {
            this.group = group;
            return this;
        }

        public Builder issue(Long issue) {
            this.issue = issue;
            return this;
        }

        public Builder requestOverrideSecurity(Boolean requestOverrideSecurity) {
            this.requestOverrideSecurity = requestOverrideSecurity;
            return this;
        }

        public Builder pagedRequest(PagedRequest pagedRequest) {
            this.pagedRequest = LimitedPagedRequestImpl.create((PagedRequest)pagedRequest, (int)100);
            return this;
        }

        public Builder isValid(Boolean isValid) {
            this.isValid = isValid;
            return this;
        }

        public Builder filterHidden(Boolean filter2) {
            this.filterHidden = filter2;
            return this;
        }

        public RequestTypeQueryImpl build() {
            return new RequestTypeQueryImpl(this.serviceDesk, this.requestType, this.group, this.issue, this.requestOverrideSecurity, this.isValid, this.filterHidden, this.pagedRequest);
        }
    }
}

