/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request.requesttype;

import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;
import com.atlassian.fugue.Option;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.internal.api.requesttype.RequestTypeInternal;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.CreateRequestTypeParams;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.RequestType;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.RequestTypeImpl;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.RequestTypeQStore;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.UpdateRequestTypeParams;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.icon.RequestTypeIconDefinition;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.requesttypegroup.GroupToRequestType;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.requesttypegroup.RequestTypeGroup;
import com.atlassian.servicedesk.internal.querydsl.mapping.Tables;
import com.atlassian.servicedesk.internal.requesttype.group.GroupToRequestTypeQStore;
import com.atlassian.servicedesk.internal.requesttype.group.RequestTypeGroupImpl;
import com.atlassian.servicedesk.internal.requesttype.group.RequestTypeQstoreHelper;
import com.atlassian.servicedesk.internal.util.db.DatabaseUtils;
import com.google.common.collect.ImmutableList;
import com.querydsl.core.Tuple;
import com.querydsl.core.group.GroupBy;
import com.querydsl.core.types.ConstructorExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.MappingProjection;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import io.atlassian.fugue.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class RequestTypeQStoreImpl
implements RequestTypeQStore {
    private static final Expression[] REQUEST_TYPE_FIELDS = new Expression[]{Tables.REQUEST_TYPE.ID, Tables.REQUEST_TYPE.VIEWPORT_ID, Tables.REQUEST_TYPE.ICON_ID, Tables.REQUEST_TYPE.ISSUE_TYPE_ID, Tables.REQUEST_TYPE.NAME, Tables.REQUEST_TYPE.INTRO, Tables.REQUEST_TYPE.DESCRIPTION, Tables.REQUEST_TYPE.FORM_ORDER, Tables.REQUEST_TYPE.KEY};
    private final DatabaseAccessor databaseAccessor;
    private final GroupToRequestTypeQStore groupToRequestTypeQStore;

    @Autowired
    public RequestTypeQStoreImpl(DatabaseAccessor databaseAccessor, GroupToRequestTypeQStore groupToRequestTypeQStore) {
        this.databaseAccessor = databaseAccessor;
        this.groupToRequestTypeQStore = groupToRequestTypeQStore;
    }

    @Override
    public List<com.atlassian.servicedesk.api.requesttype.RequestType> getRequestTypesWithGroups(Portal portal) {
        List requestTypeTuples = (List)this.databaseAccessor.runInTransaction(conn -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)conn.select((Expression[])Tables.REQUEST_TYPE.all()).from((Expression)Tables.REQUEST_TYPE)).innerJoin((EntityPath)Tables.PORTAL)).on((Predicate)Tables.REQUEST_TYPE.VIEWPORT_ID.eq(Tables.PORTAL.ID))).where((Predicate)Tables.REQUEST_TYPE.VIEWPORT_ID.eq((Object)portal.getId()).and((Predicate)RequestTypeQstoreHelper.CORRECT_ISSUE_TYPE_CONDITION))).orderBy(new OrderSpecifier[]{Tables.PORTAL.NAME.asc(), Tables.REQUEST_TYPE.FORM_ORDER.asc()})).fetch());
        List<GroupToRequestType> groupToRequestTypes = this.groupToRequestTypeQStore.getGroupToRequestType(portal.getId());
        RequestTypeMapper requestTypeMapper = RequestTypeMapper.withGroupMapping(groupToRequestTypes);
        return requestTypeTuples.stream().map(requestTypeMapper).collect(Collectors.toList());
    }

    @Override
    public List<com.atlassian.servicedesk.api.requesttype.RequestType> getRequestTypesByIds(Collection<Integer> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        List requestTypeTuples = (List)this.databaseAccessor.runInTransaction(conn -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)conn.select((Expression[])Tables.REQUEST_TYPE.all()).from((Expression)Tables.REQUEST_TYPE)).innerJoin((EntityPath)Tables.PORTAL)).on((Predicate)Tables.REQUEST_TYPE.VIEWPORT_ID.eq(Tables.PORTAL.ID))).where((Predicate)Tables.REQUEST_TYPE.ID.in(ids).and((Predicate)RequestTypeQstoreHelper.CORRECT_ISSUE_TYPE_CONDITION))).orderBy(new OrderSpecifier[]{Tables.PORTAL.NAME.asc(), Tables.REQUEST_TYPE.FORM_ORDER.asc()})).fetch());
        List<GroupToRequestType> groupToRequestTypes = this.getGroupMappingByRequestTypes(ids);
        return requestTypeTuples.stream().map(x -> RequestTypeMapper.withGroupMapping(groupToRequestTypes).apply((Tuple)x)).collect(Collectors.toList());
    }

    private List<GroupToRequestType> getGroupMappingByRequestTypes(Collection<Integer> requestTypeIds) {
        return (List)this.databaseAccessor.runInTransaction(conn -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)conn.select((Expression)Projections.constructor(GroupToRequestType.class, (Expression[])new Expression[]{Tables.GROUP_TO_REQUEST_TYPE.GROUP_ID, Tables.REQUEST_TYPE_GROUP.GROUP_NAME, Tables.REQUEST_TYPE_GROUP.ORDER, Tables.GROUP_TO_REQUEST_TYPE.REQUEST_TYPE_ID, Tables.GROUP_TO_REQUEST_TYPE.ORDER})).from((Expression)Tables.GROUP_TO_REQUEST_TYPE)).join((EntityPath)Tables.REQUEST_TYPE_GROUP)).on((Predicate)Tables.GROUP_TO_REQUEST_TYPE.GROUP_ID.eq(Tables.REQUEST_TYPE_GROUP.ID))).where((Predicate)Tables.GROUP_TO_REQUEST_TYPE.REQUEST_TYPE_ID.in(requestTypeIds))).fetch());
    }

    @Override
    public List<com.atlassian.servicedesk.api.requesttype.RequestType> getRequestTypesByPortalIds(Collection<Integer> portalIds) {
        if (portalIds.isEmpty()) {
            return Collections.emptyList();
        }
        Map requestTypeToGroupsMap = (Map)this.databaseAccessor.runInTransaction(conn -> (Map)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)conn.select(RequestTypeQStoreImpl.MAPPER()).from((Expression)Tables.REQUEST_TYPE)).join((EntityPath)Tables.PORTAL)).on((Predicate)Tables.PORTAL.ID.eq(Tables.REQUEST_TYPE.VIEWPORT_ID))).leftJoin((EntityPath)Tables.GROUP_TO_REQUEST_TYPE)).on((Predicate)Tables.REQUEST_TYPE.ID.eq(Tables.GROUP_TO_REQUEST_TYPE.REQUEST_TYPE_ID))).leftJoin((EntityPath)Tables.REQUEST_TYPE_GROUP)).on((Predicate)Tables.REQUEST_TYPE_GROUP.ID.eq(Tables.GROUP_TO_REQUEST_TYPE.GROUP_ID))).where((Predicate)Tables.REQUEST_TYPE.VIEWPORT_ID.in(portalIds).and((Predicate)RequestTypeQstoreHelper.CORRECT_ISSUE_TYPE_CONDITION))).orderBy(new OrderSpecifier[]{Tables.PORTAL.NAME.asc(), Tables.REQUEST_TYPE.FORM_ORDER.asc()})).transform(GroupBy.groupBy(RequestTypeQStoreImpl.MAPPER()).as((Expression)GroupBy.list((Expression)new GroupMapper()))));
        List<RequestTypeImpl> requestTypes = this.mapToRequestTypeList(requestTypeToGroupsMap);
        return new ArrayList<RequestTypeImpl>(requestTypes);
    }

    @Override
    public List<com.atlassian.servicedesk.api.requesttype.RequestType> searchRequestTypes(Collection<Integer> portalIds, String searchTerm, int maxNumResults) {
        String term = StringUtils.trim((String)searchTerm).toLowerCase();
        List requestTypeTuples = (List)this.databaseAccessor.runInTransaction(conn -> {
            Predicate searchExpression = ExpressionUtils.allOf((Predicate[])new Predicate[]{ExpressionUtils.anyOf((Predicate[])new Predicate[]{Tables.REQUEST_TYPE.NAME.containsIgnoreCase(term), DatabaseUtils.containsIgnoreCase(conn, (StringExpression)Tables.REQUEST_TYPE.DESCRIPTION, term), DatabaseUtils.containsIgnoreCase(conn, (StringExpression)Tables.REQUEST_TYPE.INTRO, term)}), RequestTypeQstoreHelper.CORRECT_ISSUE_TYPE_CONDITION});
            return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)conn.select((Expression[])Tables.REQUEST_TYPE.all()).from((Expression)Tables.REQUEST_TYPE)).innerJoin((EntityPath)Tables.PORTAL)).on((Predicate)Tables.REQUEST_TYPE.VIEWPORT_ID.eq(Tables.PORTAL.ID))).where((Predicate)Tables.REQUEST_TYPE.VIEWPORT_ID.in(portalIds))).where(searchExpression)).orderBy(new OrderSpecifier[]{Tables.PORTAL.NAME.asc(), Tables.REQUEST_TYPE.FORM_ORDER.asc()})).limit((long)maxNumResults)).fetch();
        });
        return requestTypeTuples.stream().map(RequestTypeMapper.newInstance()).collect(Collectors.toList());
    }

    @Override
    public List<com.atlassian.servicedesk.api.requesttype.RequestType> getRequestTypeByName(Portal portal, String name) {
        List requestTypeTuples = (List)this.databaseAccessor.runInTransaction(conn -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)conn.select((Expression[])Tables.REQUEST_TYPE.all()).from((Expression)Tables.REQUEST_TYPE)).innerJoin((EntityPath)Tables.PORTAL)).on((Predicate)Tables.REQUEST_TYPE.VIEWPORT_ID.eq(Tables.PORTAL.ID))).where((Predicate)Tables.REQUEST_TYPE.VIEWPORT_ID.eq((Object)portal.getId()))).where((Predicate)Tables.REQUEST_TYPE.NAME.equalsIgnoreCase(name))).orderBy(new OrderSpecifier[]{Tables.PORTAL.NAME.asc(), Tables.REQUEST_TYPE.FORM_ORDER.asc()})).fetch());
        return requestTypeTuples.stream().map(RequestTypeMapper.newInstance()).collect(Collectors.toList());
    }

    @Override
    public List<com.atlassian.servicedesk.api.requesttype.RequestType> loadValidRequestTypes(Set<Integer> portalIds, Map<Integer, Set<String>> portalRequestTypes, Set<String> requestTypeNames) {
        Set<String> lowerNames = this.lowerCase(requestTypeNames);
        List tuples = (List)this.databaseAccessor.runInTransaction(conn -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)conn.select((Expression[])Tables.REQUEST_TYPE.all()).from((Expression)Tables.REQUEST_TYPE)).innerJoin((EntityPath)Tables.PORTAL)).on((Predicate)Tables.REQUEST_TYPE.VIEWPORT_ID.eq(Tables.PORTAL.ID))).where((Predicate)Tables.REQUEST_TYPE.VIEWPORT_ID.in((Collection)portalIds).and((Predicate)RequestTypeQstoreHelper.CORRECT_ISSUE_TYPE_CONDITION))).orderBy(new OrderSpecifier[]{Tables.PORTAL.NAME.asc(), Tables.REQUEST_TYPE.FORM_ORDER.asc()})).fetch());
        List requestTypes = tuples.stream().map(RequestTypeMapper.newInstance()).filter(input -> {
            Integer portalId = (int)input.getPortalId();
            Set requestTypeKeys = (Set)portalRequestTypes.get(portalId);
            return requestTypeKeys != null && requestTypeKeys.contains(input.getKey()) || lowerNames.contains(input.getName().toLowerCase());
        }).collect(Collectors.toList());
        return ImmutableList.copyOf(requestTypes);
    }

    @Override
    public List<RequestTypeInternal> getRequestTypesInGroup(int groupId, long projectId) {
        BooleanExpression where = Tables.REQUEST_TYPE.ID.eqAny((SubQueryExpression)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)SQLExpressions.select(Tables.REQUEST_TYPE.ID).from((Expression)Tables.REQUEST_TYPE)).join((EntityPath)Tables.PORTAL)).on((Predicate)Tables.PORTAL.ID.eq(Tables.REQUEST_TYPE.VIEWPORT_ID))).join((EntityPath)Tables.GROUP_TO_REQUEST_TYPE)).on((Predicate)Tables.REQUEST_TYPE.ID.eq(Tables.GROUP_TO_REQUEST_TYPE.REQUEST_TYPE_ID))).join((EntityPath)Tables.REQUEST_TYPE_GROUP)).on((Predicate)Tables.GROUP_TO_REQUEST_TYPE.GROUP_ID.eq(Tables.REQUEST_TYPE_GROUP.ID))).where((Predicate)Tables.GROUP_TO_REQUEST_TYPE.GROUP_ID.eq((Object)groupId).and((Predicate)Tables.PORTAL.PROJECT_ID.eq((Object)projectId)).and((Predicate)Tables.REQUEST_TYPE_GROUP.DELETED_TIME.isNull()))).and((Predicate)Tables.REQUEST_TYPE_GROUP.DELETED_TIME.isNull().and((Predicate)RequestTypeQstoreHelper.CORRECT_ISSUE_TYPE_CONDITION));
        return new ArrayList<RequestTypeInternal>(this.getRequestTypesWithGroups(where));
    }

    @Override
    public int createRequestType(CreateRequestTypeParams createRequestTypeParams) {
        return (Integer)this.databaseAccessor.runInTransaction(conn -> (Integer)conn.insert((RelationalPath)Tables.REQUEST_TYPE).set(Tables.REQUEST_TYPE.VIEWPORT_ID, (Object)createRequestTypeParams.getPortalId()).set(Tables.REQUEST_TYPE.ICON_ID, (Object)createRequestTypeParams.getIcon()).set(Tables.REQUEST_TYPE.ISSUE_TYPE_ID, (Object)createRequestTypeParams.getIssueTypeId()).set((Path)Tables.REQUEST_TYPE.INTRO, (Object)createRequestTypeParams.getDescription()).set((Path)Tables.REQUEST_TYPE.NAME, (Object)createRequestTypeParams.getName()).set((Path)Tables.REQUEST_TYPE.KEY, (Object)UUID.randomUUID().toString()).set((Path)Tables.REQUEST_TYPE.DESCRIPTION, (Object)createRequestTypeParams.getHelpText()).set(Tables.REQUEST_TYPE.FORM_ORDER, (Object)createRequestTypeParams.getOrder()).executeWithKey(Tables.REQUEST_TYPE.ID));
    }

    @Override
    public io.atlassian.fugue.Option<com.atlassian.servicedesk.api.requesttype.RequestType> getRequestTypeByIdAndProject(int id, Project project) {
        Map requestTypeToGroupsMap = (Map)this.databaseAccessor.runInTransaction(conn -> (Map)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)conn.select(RequestTypeQStoreImpl.MAPPER()).from((Expression)Tables.REQUEST_TYPE)).join((EntityPath)Tables.PORTAL)).on((Predicate)Tables.PORTAL.ID.eq(Tables.REQUEST_TYPE.VIEWPORT_ID))).leftJoin((EntityPath)Tables.GROUP_TO_REQUEST_TYPE)).on((Predicate)Tables.REQUEST_TYPE.ID.eq(Tables.GROUP_TO_REQUEST_TYPE.REQUEST_TYPE_ID))).leftJoin((EntityPath)Tables.REQUEST_TYPE_GROUP)).on((Predicate)Tables.REQUEST_TYPE_GROUP.ID.eq(Tables.GROUP_TO_REQUEST_TYPE.GROUP_ID).and((Predicate)Tables.REQUEST_TYPE_GROUP.DELETED_TIME.isNull()))).where((Predicate)Tables.REQUEST_TYPE.ID.eq((Object)id).and((Predicate)Tables.PORTAL.PROJECT_ID.eq((Object)project.getId())).and((Predicate)RequestTypeQstoreHelper.CORRECT_ISSUE_TYPE_CONDITION))).transform(GroupBy.groupBy(RequestTypeQStoreImpl.MAPPER()).as((Expression)GroupBy.list((Expression)new GroupMapper()))));
        List<RequestTypeImpl> requestTypes = this.mapToRequestTypeList(requestTypeToGroupsMap);
        if (requestTypes.size() > 0) {
            return io.atlassian.fugue.Option.option((Object)requestTypes.get(0));
        }
        return io.atlassian.fugue.Option.none();
    }

    @Override
    public io.atlassian.fugue.Option<com.atlassian.servicedesk.api.requesttype.RequestType> getRequestTypeById(int id) {
        return (io.atlassian.fugue.Option)this.databaseAccessor.runInTransaction(conn -> {
            Map requestTypeToGroupsMap = (Map)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)conn.select(RequestTypeQStoreImpl.MAPPER()).from((Expression)Tables.REQUEST_TYPE)).leftJoin((EntityPath)Tables.GROUP_TO_REQUEST_TYPE)).on((Predicate)Tables.REQUEST_TYPE.ID.eq(Tables.GROUP_TO_REQUEST_TYPE.REQUEST_TYPE_ID))).leftJoin((EntityPath)Tables.REQUEST_TYPE_GROUP)).on((Predicate)Tables.REQUEST_TYPE_GROUP.ID.eq(Tables.GROUP_TO_REQUEST_TYPE.GROUP_ID).and((Predicate)Tables.REQUEST_TYPE_GROUP.DELETED_TIME.isNull()))).where((Predicate)Tables.REQUEST_TYPE.ID.eq((Object)id).and((Predicate)RequestTypeQstoreHelper.CORRECT_ISSUE_TYPE_CONDITION))).transform(GroupBy.groupBy(RequestTypeQStoreImpl.MAPPER()).as((Expression)GroupBy.list((Expression)new GroupMapper())));
            List<RequestTypeImpl> requestTypes = this.mapToRequestTypeList(requestTypeToGroupsMap);
            return Iterables.first(requestTypes).map(rt -> rt);
        });
    }

    @Override
    public io.atlassian.fugue.Option<com.atlassian.servicedesk.api.requesttype.RequestType> updateRequestType(int id, UpdateRequestTypeParams updateRequestTypeParams) {
        this.databaseAccessor.runInTransaction(conn -> conn.update((RelationalPath)Tables.REQUEST_TYPE).set((Path)Tables.REQUEST_TYPE.NAME, (Object)updateRequestTypeParams.getName()).set((Path)Tables.REQUEST_TYPE.INTRO, (Object)updateRequestTypeParams.getDescription()).set(Tables.REQUEST_TYPE.ICON_ID, (Object)updateRequestTypeParams.getIcon()).set(Tables.REQUEST_TYPE.FORM_ORDER, (Object)updateRequestTypeParams.getOrder()).where((Predicate)Tables.REQUEST_TYPE.ID.eq((Object)id)).execute());
        return this.getRequestTypeById(id);
    }

    @Override
    public io.atlassian.fugue.Option<com.atlassian.servicedesk.api.requesttype.RequestType> updateRequestTypeHelpText(int id, String helpText) {
        this.databaseAccessor.runInTransaction(conn -> conn.update((RelationalPath)Tables.REQUEST_TYPE).set((Path)Tables.REQUEST_TYPE.DESCRIPTION, (Object)helpText).where((Predicate)Tables.REQUEST_TYPE.ID.eq((Object)id)).execute());
        return this.getRequestTypeById(id);
    }

    @Override
    public boolean deleteRequestType(int id) {
        Long amountDeleted = (Long)this.databaseAccessor.runInTransaction(conn -> conn.delete((RelationalPath)Tables.REQUEST_TYPE).where((Predicate)Tables.REQUEST_TYPE.ID.eq((Object)id)).execute());
        return amountDeleted == 1L;
    }

    @Override
    public List<com.atlassian.servicedesk.api.requesttype.RequestType> getHiddenRequestTypes(Project project) {
        return new ArrayList<com.atlassian.servicedesk.api.requesttype.RequestType>((Collection)this.databaseAccessor.runInTransaction(conn -> this.getHiddenRequestTypesQuery(project, (DatabaseConnection)conn).fetch()));
    }

    @Override
    public long countHiddenRequestTypes(Project project) {
        return (Long)this.databaseAccessor.runInTransaction(conn -> this.getHiddenRequestTypesQuery(project, (DatabaseConnection)conn).fetchCount());
    }

    private SQLQuery<RequestTypeImpl> getHiddenRequestTypesQuery(Project project, DatabaseConnection conn) {
        return (SQLQuery)((SQLQuery)conn.select(RequestTypeQStoreImpl.MAPPER()).from((Expression)Tables.REQUEST_TYPE)).where((Predicate)Tables.REQUEST_TYPE.ID.eqAny((SubQueryExpression)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)SQLExpressions.select(Tables.REQUEST_TYPE.ID).from((Expression)Tables.REQUEST_TYPE)).join((EntityPath)Tables.PORTAL)).on((Predicate)Tables.PORTAL.ID.eq(Tables.REQUEST_TYPE.VIEWPORT_ID))).leftJoin((EntityPath)Tables.GROUP_TO_REQUEST_TYPE)).on((Predicate)Tables.REQUEST_TYPE.ID.eq(Tables.GROUP_TO_REQUEST_TYPE.REQUEST_TYPE_ID))).leftJoin((EntityPath)Tables.REQUEST_TYPE_GROUP)).on((Predicate)Tables.REQUEST_TYPE_GROUP.ID.eq(Tables.GROUP_TO_REQUEST_TYPE.GROUP_ID).and((Predicate)Tables.REQUEST_TYPE_GROUP.DELETED_TIME.isNull()))).where((Predicate)Tables.PORTAL.PROJECT_ID.eq((Object)project.getId()))).groupBy(Tables.REQUEST_TYPE.ID)).having((Predicate)SQLExpressions.count(Tables.REQUEST_TYPE_GROUP.ID).eq((Object)0L))).and((Predicate)RequestTypeQstoreHelper.CORRECT_ISSUE_TYPE_CONDITION));
    }

    @Override
    public List<com.atlassian.servicedesk.api.requesttype.RequestType> getRequestTypesNotInGroup(long projectId, int groupId) {
        BooleanExpression where = Tables.REQUEST_TYPE.ID.notIn((SubQueryExpression)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)SQLExpressions.select(Tables.REQUEST_TYPE.ID).from((Expression)Tables.REQUEST_TYPE)).join((EntityPath)Tables.PORTAL)).on((Predicate)Tables.PORTAL.ID.eq(Tables.REQUEST_TYPE.VIEWPORT_ID))).join((EntityPath)Tables.GROUP_TO_REQUEST_TYPE)).on((Predicate)Tables.REQUEST_TYPE.ID.eq(Tables.GROUP_TO_REQUEST_TYPE.REQUEST_TYPE_ID))).where((Predicate)Tables.GROUP_TO_REQUEST_TYPE.GROUP_ID.eq((Object)groupId).and((Predicate)Tables.PORTAL.PROJECT_ID.eq((Object)projectId)))).and((Predicate)Tables.PORTAL.PROJECT_ID.eq((Object)projectId)).and((Predicate)RequestTypeQstoreHelper.CORRECT_ISSUE_TYPE_CONDITION);
        return new ArrayList<RequestTypeInternal>(this.getRequestTypesWithGroups(where));
    }

    private ArrayList<RequestTypeInternal> getRequestTypesWithGroups(BooleanExpression where) {
        Map requestTypeToGroupsMap = (Map)this.databaseAccessor.runInTransaction(conn -> (Map)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)conn.select(RequestTypeQStoreImpl.MAPPER()).from((Expression)Tables.REQUEST_TYPE)).leftJoin((EntityPath)Tables.PORTAL)).on((Predicate)Tables.PORTAL.ID.eq(Tables.REQUEST_TYPE.VIEWPORT_ID))).leftJoin((EntityPath)Tables.GROUP_TO_REQUEST_TYPE)).on((Predicate)Tables.REQUEST_TYPE.ID.eq(Tables.GROUP_TO_REQUEST_TYPE.REQUEST_TYPE_ID))).leftJoin((EntityPath)Tables.REQUEST_TYPE_GROUP)).on((Predicate)Tables.REQUEST_TYPE_GROUP.ID.eq(Tables.GROUP_TO_REQUEST_TYPE.GROUP_ID).and((Predicate)Tables.REQUEST_TYPE_GROUP.DELETED_TIME.isNull()))).where((Predicate)where)).transform(GroupBy.groupBy(RequestTypeQStoreImpl.MAPPER()).as((Expression)GroupBy.list((Expression)new GroupMapper()))));
        return new ArrayList<RequestTypeInternal>(this.mapToRequestTypeList(requestTypeToGroupsMap));
    }

    private List<RequestTypeImpl> mapToRequestTypeList(Map<RequestTypeImpl, List<RequestTypeGroupImpl>> transform) {
        return transform.entrySet().stream().map(entry -> {
            RequestTypeImpl requestType = (RequestTypeImpl)entry.getKey();
            requestType.setGroups(new ArrayList<com.atlassian.servicedesk.api.requesttype.RequestTypeGroup>((Collection)entry.getValue()));
            return requestType;
        }).collect(Collectors.toList());
    }

    private Set<String> lowerCase(Set<String> strings) {
        HashSet<String> lowerStrings = new HashSet<String>();
        if (strings != null) {
            for (String string : strings) {
                lowerStrings.add(StringUtils.lowerCase((String)StringUtils.trim((String)string)));
            }
        }
        return lowerStrings;
    }

    private static ConstructorExpression<RequestTypeImpl> MAPPER() {
        return Projections.constructor(RequestTypeImpl.class, (Expression[])REQUEST_TYPE_FIELDS);
    }

    private static class RequestTypeMapper
    implements Function<Tuple, RequestType> {
        @TenantAware(value=TenancyScope.TENANTED)
        private Map<Integer, List<RequestTypeGroup>> requestTypeIdGroupsMap = new HashMap<Integer, List<RequestTypeGroup>>();

        private RequestTypeMapper() {
        }

        static RequestTypeMapper withGroupMapping(List<GroupToRequestType> requestTypeGroups) {
            RequestTypeMapper instance = RequestTypeMapper.newInstance();
            instance.requestTypeIdGroupsMap = RequestTypeMapper.requestTypeIdToGroup(requestTypeGroups);
            return instance;
        }

        static RequestTypeMapper newInstance() {
            return new RequestTypeMapper();
        }

        @Override
        public RequestType apply(Tuple tuple) {
            int id = (Integer)tuple.get(Tables.REQUEST_TYPE.ID);
            long issueTypeId = (Long)tuple.get(Tables.REQUEST_TYPE.ISSUE_TYPE_ID);
            int portalId = (Integer)io.atlassian.fugue.Option.option((Object)tuple.get(Tables.REQUEST_TYPE.VIEWPORT_ID)).getOrThrow(() -> new IllegalStateException("Invariant problem. Parent Portal of Request Type can not be null"));
            long iconId = (Long)io.atlassian.fugue.Option.option((Object)tuple.get(Tables.REQUEST_TYPE.ICON_ID)).orElse(() -> io.atlassian.fugue.Option.option((Object)ComponentAccessor.getAvatarManager().getDefaultAvatarId(RequestTypeIconDefinition.ICON_TYPE))).getOrElse((Object)-1L);
            int order = (Integer)io.atlassian.fugue.Option.option((Object)tuple.get(Tables.REQUEST_TYPE.FORM_ORDER)).getOrElse((Object)0);
            String key = (String)tuple.get((Expression)Tables.REQUEST_TYPE.KEY);
            String name = (String)tuple.get((Expression)Tables.REQUEST_TYPE.NAME);
            String intro = StringUtils.defaultString((String)((String)tuple.get((Expression)Tables.REQUEST_TYPE.INTRO)));
            String description = StringUtils.defaultString((String)((String)tuple.get((Expression)Tables.REQUEST_TYPE.DESCRIPTION)));
            List<RequestTypeGroup> groups = this.requestTypeIdGroupsMap.containsKey(id) ? this.requestTypeIdGroupsMap.get(id) : Collections.emptyList();
            return RequestType.apply(id, portalId, key, iconId, issueTypeId, name, intro, description, order, groups);
        }

        private static Map<Integer, List<RequestTypeGroup>> requestTypeIdToGroup(List<GroupToRequestType> requestTypeGroups) {
            HashMap<Integer, List<RequestTypeGroup>> requestTypeIdGroupsMap = new HashMap<Integer, List<RequestTypeGroup>>();
            for (GroupToRequestType rtg : requestTypeGroups) {
                ArrayList<RequestTypeGroup> groups = (ArrayList<RequestTypeGroup>)requestTypeIdGroupsMap.get(rtg.getRequestTypeId());
                if (groups == null) {
                    groups = new ArrayList<RequestTypeGroup>();
                }
                groups.add(new RequestTypeGroup(rtg.getGroupId(), rtg.getGroupName(), (Option<Integer>)StepsConverters.olderOption(rtg.getGroupOrder())));
                requestTypeIdGroupsMap.put(rtg.getRequestTypeId(), groups);
            }
            return requestTypeIdGroupsMap;
        }
    }

    private class GroupMapper
    extends MappingProjection<RequestTypeGroupImpl> {
        public GroupMapper() {
            super(RequestTypeGroupImpl.class, new Expression[]{Tables.REQUEST_TYPE_GROUP.ID, Tables.REQUEST_TYPE_GROUP.GROUP_NAME, Tables.REQUEST_TYPE_GROUP.ORDER});
        }

        protected RequestTypeGroupImpl map(Tuple tuple) {
            Integer id = (Integer)tuple.get(Tables.REQUEST_TYPE_GROUP.ID);
            String name = (String)tuple.get((Expression)Tables.REQUEST_TYPE_GROUP.GROUP_NAME);
            Integer order = (Integer)tuple.get(Tables.REQUEST_TYPE_GROUP.ORDER);
            if (id == null) {
                return null;
            }
            return new RequestTypeGroupImpl(id, name, order);
        }
    }
}

