/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request.requesttype;

import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.internal.api.requesttype.RESTfulTableRequestType;
import com.atlassian.servicedesk.internal.api.requesttype.RequestTypeInternal;
import com.atlassian.servicedesk.internal.api.requesttype.group.RequestTypeGroupManager;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.enabled.ConfluenceKBEnabledQStore;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.labels.ConfluenceKBLabelQStore;
import com.atlassian.servicedesk.internal.errors.ServiceDeskError;
import com.atlassian.servicedesk.internal.errors.ServiceDeskHttpError;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.CreateRequestTypeParams;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.PartialRequestType;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.RequestTypeFieldQStore;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.RequestTypeImpl;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.RequestTypeInternalManagerScala;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.RequestTypeQStore;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.UpdateRequestTypeParams;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.field.PartialRequestTypeField;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.field.RequestTypeFieldInternal;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.field.RequestTypeFieldManager;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.requesttypegroup.RequestTypeGroup;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.status.StatusMappingQStore;
import com.atlassian.servicedesk.internal.feature.emailchannel.EmailChannelScala;
import com.atlassian.servicedesk.internal.feature.emailchannel.emailplatform.EmailPlatformChannelManager;
import com.atlassian.servicedesk.internal.fields.ServiceDeskJIRAFieldService;
import com.atlassian.servicedesk.internal.requesttype.group.GroupToRequestTypeQStore;
import com.atlassian.servicedesk.internal.utils.Convert;
import com.atlassian.servicedesk.internal.utils.ErrorConverterHelper;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestTypeInternalManager {
    private final RequestTypeInternalManagerScala requestTypeManagerScala;
    private final ErrorConverterHelper errorConverterHelper;
    private final RequestTypeQStore requestTypeQStore;
    private final ErrorResultHelper errorResultHelper;
    private final RequestTypeFieldManager requestTypeFieldManager;
    private final ServiceDeskJIRAFieldService sdJIRAFieldService;
    private final ConfluenceKBLabelQStore confluenceKBLabelQStore;
    private final ConfluenceKBEnabledQStore confluenceKBEnabledQStore;
    private final StatusMappingQStore statusMappingQStore;
    private final RequestTypeFieldQStore requestTypeFieldQStore;
    private final GroupToRequestTypeQStore groupToRequestTypeQStore;
    private final RequestTypeGroupManager requestTypeGroupManager;
    private final EmailPlatformChannelManager emailChannelManager;

    @Autowired
    public RequestTypeInternalManager(RequestTypeInternalManagerScala requestTypeManagerScala, ErrorConverterHelper errorConverterHelper, RequestTypeQStore requestTypeQStore, ErrorResultHelper errorResultHelper, RequestTypeFieldManager requestTypeFieldManager, ServiceDeskJIRAFieldService sdJIRAFieldService, ConfluenceKBLabelQStore confluenceKBLabelQStore, ConfluenceKBEnabledQStore confluenceKBEnabledQStore, StatusMappingQStore statusMappingQStore, RequestTypeFieldQStore requestTypeFieldQStore, GroupToRequestTypeQStore groupToRequestTypeQStore, RequestTypeGroupManager requestTypeGroupManager, EmailPlatformChannelManager emailChannelManager) {
        this.requestTypeManagerScala = requestTypeManagerScala;
        this.errorConverterHelper = errorConverterHelper;
        this.requestTypeQStore = requestTypeQStore;
        this.errorResultHelper = errorResultHelper;
        this.requestTypeFieldManager = requestTypeFieldManager;
        this.sdJIRAFieldService = sdJIRAFieldService;
        this.confluenceKBLabelQStore = confluenceKBLabelQStore;
        this.confluenceKBEnabledQStore = confluenceKBEnabledQStore;
        this.statusMappingQStore = statusMappingQStore;
        this.requestTypeFieldQStore = requestTypeFieldQStore;
        this.groupToRequestTypeQStore = groupToRequestTypeQStore;
        this.requestTypeGroupManager = requestTypeGroupManager;
        this.emailChannelManager = emailChannelManager;
    }

    public Either<AnError, RequestType> addRequestTypeFromREST(Project project, Portal portal, RESTfulTableRequestType rtRequest, IssueType issueType) {
        return this.errorConverterHelper.toJavaErrorEither(this.requestTypeManagerScala.addRequestTypeFromREST(project, portal, rtRequest, issueType));
    }

    public Either<ServiceDeskError, RequestType> addRequestTypeUnchecked(Project project, Portal portal, PartialRequestType partialRequestType, IssueType issueType) {
        return Convert.toJavaEither(this.requestTypeManagerScala.addRequestTypeUnchecked(project, portal, partialRequestType, issueType));
    }

    public List<RequestTypeGroup> dissociateGroupsFromRequestType(List<RequestTypeGroup> groups, RequestType requestType) {
        return Convert.toJavaList(this.requestTypeManagerScala.dissociateGroupsFromRequestType(Convert.toScalaList(groups), requestType));
    }

    public Either<ServiceDeskHttpError, RequestType> getAnyRequestType(Integer id) {
        return Convert.toJavaEither(this.requestTypeManagerScala.getAnyRequestType(id));
    }

    public Either<ServiceDeskHttpError, RequestType> getValidRequestType(Integer id, Project project) {
        return Steps.begin(this.getAnyRequestType(id)).then(requestType -> this.isValidRequestTypeForProject((RequestType)requestType, project)).yield((requestType, validRequestType) -> validRequestType);
    }

    public Either<AnError, RequestType> getRequestTypeByKey(Portal portal, String key) {
        return this.errorConverterHelper.toJavaErrorEither(this.requestTypeManagerScala.getRequestTypeByKey(portal, key));
    }

    public List<RequestType> getAllValidRequestTypes(Portal portal, Project project) {
        return Convert.toJavaList(this.requestTypeManagerScala.getAllValidRequestTypes(portal, project));
    }

    public List<RequestType> getAllRequestTypes(Portal portal) {
        return Convert.toJavaList(this.requestTypeManagerScala.getAllRequestTypes(portal));
    }

    public List<RequestType> getRequestTypesByPortalIds(Set<Integer> portalIds) {
        return Convert.toJavaList(this.requestTypeManagerScala.getRequestTypesByPortalIds(Convert.toScalaSetInt(portalIds)));
    }

    public List<RequestType> searchRequestTypes(Set<Integer> portalIds, String searchTerm, Integer maxNumResults) {
        List<RequestType> requestTypes = this.requestTypeQStore.searchRequestTypes(portalIds, searchTerm, maxNumResults);
        requestTypes.sort((o1, o2) -> o1.getName().compareTo(o2.getName()));
        return requestTypes;
    }

    public List<RequestType> loadValidRequestTypes(Set<Integer> portalIds, Map<Integer, Set<String>> portalRequestType, Set<String> requestTypeNames) {
        return this.requestTypeQStore.loadValidRequestTypes(portalIds, portalRequestType, requestTypeNames);
    }

    public Either<AnError, RequestType> deleteRequestType(int requestTypeId) {
        Either<AnError, RequestType> requestTypeResponse = this.getRequestTypeById(requestTypeId);
        RequestType requestType = (RequestType)requestTypeResponse.right().get();
        return this.deleteRequestType(requestType);
    }

    public Either<AnError, RequestType> deleteRequestType(RequestType requestType) {
        this.confluenceKBLabelQStore.deleteKBLabels(requestType);
        this.confluenceKBEnabledQStore.deleteKBEnabled(requestType);
        this.statusMappingQStore.deleteStatusMapping(requestType);
        this.requestTypeFieldQStore.deleteFieldsForRequestType(requestType);
        this.groupToRequestTypeQStore.disassociateAllGroupsFromRequestType(requestType);
        if (this.requestTypeQStore.deleteRequestType(requestType.getId())) {
            return Either.right((Object)requestType);
        }
        return Either.left((Object)this.errorResultHelper.notFound404("sd.internal.requesttype.error.delete", new Object[]{requestType.getId()}).build());
    }

    public Either<ServiceDeskHttpError, RequestType> isValidRequestTypeForProject(RequestType requestType, Project project) {
        return Convert.toJavaEither(this.requestTypeManagerScala.isValidRequestTypeForProject(requestType, project));
    }

    public Either<AnError, RequestType> getRequestTypeById(int id) {
        return this.requestTypeQStore.getRequestTypeById(id).toRight(() -> this.errorResultHelper.notFound404("sd.customerview.error.requestTypeNotFound", new Object[]{id}).build());
    }

    public Either<AnError, RequestType> getRequestTypeByIdWithAdditionalProjectCheck(int id, Project project) {
        return this.requestTypeQStore.getRequestTypeByIdAndProject(id, project).toRight(() -> this.errorResultHelper.notFound404("sd.customerview.error.requestTypeNotFound", new Object[]{id}).build());
    }

    public Either<AnError, RequestType> createRequestType(CreateRequestTypeParams createRequestTypeParams, Project project, IssueType issueType) {
        return Steps.begin(this.doCreateRequestType(createRequestTypeParams, project)).then(requestType -> this.createFields((RequestType)requestType, project, issueType)).yield((requestType, fields) -> requestType);
    }

    private Either<AnError, RequestType> doCreateRequestType(CreateRequestTypeParams createRequestTypeParams, Project project) {
        int id = this.requestTypeQStore.createRequestType(createRequestTypeParams);
        if (createRequestTypeParams.hasGroup()) {
            this.groupToRequestTypeQStore.associateGroupToRequestType(id, createRequestTypeParams.getGroupId());
            Either<AnError, RequestTypeInternal> moveResult = this.requestTypeGroupManager.moveRequestTypeInGroup(id, project.getId(), createRequestTypeParams.getGroupId(), (Option<Integer>)Option.none());
            if (moveResult.isLeft()) {
                return Either.left((Object)moveResult.left().get());
            }
        }
        return this.requestTypeQStore.getRequestTypeById(id).toRight(() -> this.errorResultHelper.internalServiceError500("sd.internal.requesttype.error.insert", new Object[0]).build());
    }

    public Either<AnError, RequestType> updateRequestType(int id, UpdateRequestTypeParams updateRequestTypeParams, Project project) {
        return Steps.begin(this.getRequestTypeByIdWithAdditionalProjectCheck(id, project)).then(requestType -> {
            this.requestTypeGroupManager.mapRequestTypeToGroups(id, updateRequestTypeParams.getGroupIds(), project);
            return this.requestTypeQStore.updateRequestType(id, updateRequestTypeParams).toRight(() -> this.errorResultHelper.internalServiceError500("sd.internal.requesttype.error.update", new Object[0]).build());
        }).yield((requestType, result) -> result);
    }

    public Either<AnError, RequestType> updateRequestTypeHelpText(int id, String helpText, Project project) {
        return Steps.begin(this.getRequestTypeByIdWithAdditionalProjectCheck(id, project)).then(requestType -> this.requestTypeQStore.updateRequestTypeHelpText(id, helpText).toRight(() -> this.errorResultHelper.internalServiceError500("sd.internal.requesttype.error.update", new Object[0]).build())).yield((requestType, result) -> result);
    }

    private Either<AnError, List<RequestTypeFieldInternal>> createFields(RequestType requestType, Project project, IssueType issueType) {
        List<PartialRequestTypeField> partialRequestTypeFields = this.sdJIRAFieldService.getRequiredFieldsAsPartialRequestTypeField(project, issueType);
        List<RequestTypeFieldInternal> internalFields = partialRequestTypeFields.stream().map(RequestTypeFieldInternal::new).collect(Collectors.toList());
        return this.requestTypeFieldManager.createFields(requestType, internalFields);
    }

    public List<RequestType> getHiddenRequestTypes(ServiceDesk serviceDesk, Project project) {
        List<RequestType> requestTypes = this.requestTypeQStore.getHiddenRequestTypes(project);
        this.populateEmailUsage(serviceDesk, requestTypes);
        return requestTypes;
    }

    public long countHiddenRequestTypes(Project project) {
        return this.requestTypeQStore.countHiddenRequestTypes(project);
    }

    public List<RequestType> getRequestTypesNotInGroup(long projectId, int groupId) {
        return this.requestTypeQStore.getRequestTypesNotInGroup(projectId, groupId);
    }

    public void populateEmailUsage(ServiceDesk serviceDesk, List<RequestType> requestTypes) {
        List<EmailChannelScala> channels = this.emailChannelManager.getValidEmailChannelsByServiceDesk(serviceDesk);
        RequestType emailRequest = null;
        if (!channels.isEmpty()) {
            emailRequest = ((EmailChannelScala)channels.stream().findFirst().get()).requestType();
        }
        for (RequestType requestType : requestTypes) {
            if (!(requestType instanceof RequestTypeImpl)) continue;
            if (emailRequest != null && emailRequest.getId() == requestType.getId()) {
                ((RequestTypeImpl)requestType).setUsedByEmail((Option<Boolean>)Option.some((Object)true));
                continue;
            }
            ((RequestTypeImpl)requestType).setUsedByEmail((Option<Boolean>)Option.some((Object)false));
        }
    }

    public List<RequestType> getRequestTypesOnlyInGroup(long projectId, int groupId) {
        List<RequestTypeInternal> requestTypesInGroup = this.requestTypeQStore.getRequestTypesInGroup(groupId, projectId);
        return requestTypesInGroup.stream().filter(requestType -> requestType.getGroups().size() == 1).collect(Collectors.toList());
    }

    public List<RequestType> getRequestTypeForPortalAndName(Portal portal, String name) {
        return this.requestTypeQStore.getRequestTypeByName(portal, name);
    }
}

