/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request.requesttype;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.servicedesk.api.requesttype.RequestTypeGroup;
import com.atlassian.servicedesk.internal.api.requesttype.RequestTypeInternal;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.icon.RequestTypeIconDefinition;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class RequestTypeImpl
implements RequestTypeInternal {
    private final int id;
    private final long portalId;
    private final long iconId;
    private final long issueTypeId;
    private final String name;
    private final String description;
    private final String helpText;
    private final int order;
    private final String key;
    private final List<RequestTypeGroup> groups;
    private Option<Boolean> usedByEmail = Option.none();

    public RequestTypeImpl(int id, Integer portalId, Long iconId, long issueTypeId, String name, String description, String helpText, Integer order, String key) {
        this(id, (Long)Option.option((Object)portalId).map(Integer::longValue).getOrNull(), iconId, issueTypeId, name, description, helpText, order, key);
    }

    public RequestTypeImpl(int id, Long portalId, Long iconId, long issueTypeId, String name, String description, String helpText, Integer order, String key) {
        this.id = id;
        this.portalId = (Long)Option.option((Object)portalId).getOrThrow(() -> new IllegalStateException("Invariant problem. Parent Portal of Request Type can not be null"));
        this.iconId = (Long)Option.option((Object)iconId).orElse(() -> Option.option((Object)ComponentAccessor.getAvatarManager().getDefaultAvatarId(RequestTypeIconDefinition.ICON_TYPE))).getOrElse((Object)-1L);
        this.issueTypeId = issueTypeId;
        this.name = name;
        this.description = description;
        this.helpText = helpText;
        this.order = (Integer)Option.option((Object)order).getOrElse((Object)0);
        this.key = key;
        this.groups = new ArrayList<RequestTypeGroup>();
    }

    public long getPortalId() {
        return this.portalId;
    }

    public long getIssueTypeId() {
        return this.issueTypeId;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public String getDescription() {
        return this.description;
    }

    public String getHelpText() {
        return this.helpText;
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    public int getOrder() {
        return this.order;
    }

    public int getId() {
        return this.id;
    }

    public long getIconId() {
        return this.iconId;
    }

    public List<RequestTypeGroup> getGroups() {
        return Collections.unmodifiableList(this.groups);
    }

    public void setGroups(List<RequestTypeGroup> groups) {
        this.groups.clear();
        Option.option(groups).forEach(this.groups::addAll);
    }

    public Option<Boolean> isUsedByEmail() {
        return this.usedByEmail;
    }

    public void setUsedByEmail(Option<Boolean> usedByEmail) {
        this.usedByEmail = usedByEmail;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestTypeImpl that = (RequestTypeImpl)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.portalId != that.portalId) {
            return false;
        }
        if (this.iconId != that.iconId) {
            return false;
        }
        if (this.issueTypeId != that.issueTypeId) {
            return false;
        }
        if (this.order != that.order) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.helpText != null ? !this.helpText.equals(that.helpText) : that.helpText != null) {
            return false;
        }
        if (this.groups != null ? !this.groups.equals(that.groups) : that.groups != null) {
            return false;
        }
        return this.key != null ? this.key.equals(that.key) : that.key == null;
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + (int)(this.portalId ^ this.portalId >>> 32);
        result = 31 * result + (int)(this.iconId ^ this.iconId >>> 32);
        result = 31 * result + (int)(this.issueTypeId ^ this.issueTypeId >>> 32);
        result = 31 * result + this.name.hashCode();
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.helpText != null ? this.helpText.hashCode() : 0);
        result = 31 * result + this.order;
        result = 31 * result + (this.groups != null ? this.groups.hashCode() : 0);
        result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
        return result;
    }
}

