/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request.requesttype;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.RequestTypeFieldValueMapper;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.field.value.RequestTypeFieldValue;
import com.atlassian.servicedesk.internal.querydsl.mapping.Tables;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestTypeFieldValueQStore {
    private final DatabaseAccessor databaseAccessor;

    @Autowired
    public RequestTypeFieldValueQStore(DatabaseAccessor databaseAccessor) {
        this.databaseAccessor = databaseAccessor;
    }

    public void createValues(int requestTypeFieldInternalId, List<RequestTypeFieldValue> values2) {
        Long rowCreated;
        if (!values2.isEmpty() && (rowCreated = (Long)this.databaseAccessor.runInTransaction(conn -> this.insertValues(requestTypeFieldInternalId, values2, (DatabaseConnection)conn))) != (long)values2.size()) {
            throw new RuntimeException("Expected " + values2.size() + " inserted field values, but received " + rowCreated);
        }
    }

    private Long insertValues(int requestTypeFieldInternalId, List<RequestTypeFieldValue> values2, DatabaseConnection conn) {
        SQLInsertClause insert = conn.insert((RelationalPath)Tables.REQUEST_TYPE_FIELD_VALUE);
        for (RequestTypeFieldValue fieldValue : values2) {
            insert.set((Path)Tables.REQUEST_TYPE_FIELD_VALUE.VALUE, (Object)fieldValue.getValue());
            insert.set(Tables.REQUEST_TYPE_FIELD_VALUE.VALUE_ORDER, (Object)fieldValue.getOrder());
            insert.set(Tables.REQUEST_TYPE_FIELD_VALUE.FIELD_ID, (Object)requestTypeFieldInternalId);
            insert.set((Path)Tables.REQUEST_TYPE_FIELD_VALUE.FIELD_NAME, (Object)fieldValue.getFieldName());
            insert.addBatch();
        }
        return insert.execute();
    }

    public List<RequestTypeFieldValue> updateValues(int requestTypeFieldInternalId, List<RequestTypeFieldValue> values2) {
        return (List)this.databaseAccessor.runInTransaction(conn -> {
            this.deleteValuesForField(requestTypeFieldInternalId, (DatabaseConnection)conn);
            return this.addValues(requestTypeFieldInternalId, values2, (DatabaseConnection)conn);
        });
    }

    private List<RequestTypeFieldValue> addValues(int requestTypeFieldInternalId, List<RequestTypeFieldValue> values2, DatabaseConnection connection) {
        if (values2.isEmpty()) {
            return null;
        }
        this.insertValues(requestTypeFieldInternalId, values2, connection);
        return this.getValuesForField(requestTypeFieldInternalId, connection);
    }

    private void deleteValuesForField(int requestTypeFieldInternalId, DatabaseConnection conn) {
        conn.delete((RelationalPath)Tables.REQUEST_TYPE_FIELD_VALUE).where((Predicate)Tables.REQUEST_TYPE_FIELD_VALUE.FIELD_ID.eq((Object)requestTypeFieldInternalId)).execute();
    }

    private List<RequestTypeFieldValue> getValuesForField(int requestTypeFieldInternalId, DatabaseConnection databaseConnection) {
        return ((SQLQuery)((SQLQuery)databaseConnection.select((Expression)new RequestTypeFieldValueMapper()).from((Expression)Tables.REQUEST_TYPE_FIELD_VALUE)).where((Predicate)Tables.REQUEST_TYPE_FIELD_VALUE.FIELD_ID.eq((Object)requestTypeFieldInternalId))).fetch();
    }
}

