/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request.requesttype;

import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.RequestTypeFieldQStore;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.RequestTypeFieldValueQStore;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.field.RequestTypeFieldInternal;
import io.atlassian.fugue.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestTypeFieldCreator {
    private final RequestTypeFieldQStore requestTypeFieldQStore;
    private final RequestTypeFieldValueQStore requestTypeFieldValueQStore;

    @Autowired
    public RequestTypeFieldCreator(RequestTypeFieldQStore requestTypeFieldQStore, RequestTypeFieldValueQStore requestTypeFieldValueQStore) {
        this.requestTypeFieldQStore = requestTypeFieldQStore;
        this.requestTypeFieldValueQStore = requestTypeFieldValueQStore;
    }

    public Option<RequestTypeFieldInternal> insertRequestTypeFieldAndValues(RequestType requestType, RequestTypeFieldInternal requestTypeFieldInternal) {
        Integer fieldId = this.createFieldAndValues(requestType, requestTypeFieldInternal);
        return this.requestTypeFieldQStore.getField(fieldId);
    }

    public void silentInsertRequestTypeFieldAndValues(RequestType requestType, RequestTypeFieldInternal requestTypeFieldInternal) {
        this.createFieldAndValues(requestType, requestTypeFieldInternal);
    }

    private int createFieldAndValues(RequestType requestType, RequestTypeFieldInternal requestTypeFieldInternal) {
        Integer fieldId = this.requestTypeFieldQStore.createRequestTypeField(requestType, requestTypeFieldInternal);
        this.requestTypeFieldValueQStore.createValues(fieldId, requestTypeFieldInternal.getValues());
        return fieldId;
    }
}

