/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request.listener;

import com.atlassian.jira.bc.issue.properties.IssuePropertyService;
import com.atlassian.jira.entity.property.EntityPropertyOptions;
import com.atlassian.jira.entity.property.EntityPropertyService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.feature.customer.request.activitystream.RequestActivityManager;
import com.atlassian.servicedesk.internal.issueproperty.ServiceDeskIssuePropertyNames;
import com.atlassian.servicedesk.internal.utils.DateFormatter;
import com.atlassian.servicedesk.internal.utils.ServiceDeskDateFormatterFactory;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Option;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class LastRequestActivityPropertyValidator {
    private static final Logger LOG = LoggerFactory.getLogger(LastRequestActivityPropertyValidator.class);
    private final ServiceDeskDateFormatterFactory serviceDeskDateFormatterFactory;
    private final RequestActivityManager requestActivityManager;
    private final IssuePropertyService issuePropertyService;

    @Autowired
    LastRequestActivityPropertyValidator(ServiceDeskDateFormatterFactory serviceDeskDateFormatterFactory, RequestActivityManager requestActivityManager, IssuePropertyService issuePropertyService) {
        this.serviceDeskDateFormatterFactory = serviceDeskDateFormatterFactory;
        this.requestActivityManager = requestActivityManager;
        this.issuePropertyService = issuePropertyService;
    }

    Option<EntityPropertyService.SetPropertyValidationResult> validatePropertyInput(CheckedUser user, Issue issue) {
        return Option.option((Object)this.issuePropertyService.validateSetProperty(user.forJIRA(), issue.getId(), this.retrievePropertyInput(issue), this.retrieveSkipPermissionOption()));
    }

    private EntityPropertyOptions retrieveSkipPermissionOption() {
        return new EntityPropertyOptions.Builder().skipPermissionChecks().build();
    }

    @VisibleForTesting
    EntityPropertyService.PropertyInput retrievePropertyInput(Issue issue) {
        Date lastCustomerVisibleActivityDate = this.retrieveLastActivityDate(issue);
        String json = this.formatToJson(lastCustomerVisibleActivityDate);
        LOG.debug("Creating property input with key {} and value {}", (Object)ServiceDeskIssuePropertyNames.SD_REQUEST_LAST_PUBLIC_ACTIVITY_KEY(), (Object)json);
        return new EntityPropertyService.PropertyInput(json, ServiceDeskIssuePropertyNames.SD_REQUEST_LAST_PUBLIC_ACTIVITY_KEY());
    }

    private Date retrieveLastActivityDate(Issue issue) {
        return (Date)this.requestActivityManager.getMostRecentActivityDateForReporter(issue).map(Date::from).getOrElse((Object)issue.getCreated());
    }

    private String formatToJson(Date lastCustomerVisibleActivityDate) {
        DateFormatter formatter = this.serviceDeskDateFormatterFactory.getDefaultFormatter();
        String timeString = (String)Option.option((Object)formatter.getTimeLong(lastCustomerVisibleActivityDate)).getOrElse((Object)"");
        return JSONObject.quote((String)timeString);
    }
}

