/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request.list;

import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.servicedesk.api.request.CustomerRequestQuery;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.request.RequestListFilterModel;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.request.RequestListFilterModelParser;
import com.atlassian.servicedesk.internal.feature.customer.request.MultiPortalSearchResult;
import com.atlassian.servicedesk.internal.feature.customer.request.list.AllVisiblePortals;
import com.atlassian.servicedesk.internal.feature.customer.request.list.PortalRequestListUtil;
import com.atlassian.servicedesk.internal.feature.customer.request.list.PortalRequestTypeFilter;
import com.atlassian.servicedesk.internal.feature.customer.request.list.PortalsAndRequestTypesResult;
import com.atlassian.servicedesk.internal.feature.customer.request.list.RequestListFilter;
import com.atlassian.servicedesk.internal.feature.customer.request.list.RequestListPageResponse;
import com.atlassian.servicedesk.internal.feature.customer.request.list.RequestListProvider;
import com.atlassian.servicedesk.internal.feature.customer.request.list.TextSearchFilter;
import com.atlassian.servicedesk.internal.rest.responses.PortalRequestTypes;
import com.atlassian.servicedesk.internal.rest.responses.RequestListResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestListResponseAssembler {
    public static final int DEFAULT_RESULTS_PER_PAGE = 20;
    private final RequestListProvider requestListProvider;
    private final RequestListFilterModelParser requestListFilterModelParser;
    private final PortalRequestListUtil portalRequestListUtil;

    @Autowired
    public RequestListResponseAssembler(RequestListProvider requestListProvider, RequestListFilterModelParser requestListFilterModelParser, PortalRequestListUtil portalRequestListUtil) {
        this.requestListProvider = requestListProvider;
        this.requestListFilterModelParser = requestListFilterModelParser;
        this.portalRequestListUtil = portalRequestListUtil;
    }

    public RequestListResponse getResponse(CheckedUser user, RequestListFilterModel requestListFilterModel) {
        AllVisiblePortals allVisiblePortals = this.requestListProvider.getAllVisiblePortals(user);
        List<PortalRequestTypes> portalRequestTypes = this.getAllPortalsAndRequestTypesForUser(user, allVisiblePortals);
        PortalRequestTypeFilter portalRequestTypeFilter = this.portalRequestListUtil.validateSelectedPortalAndRequestType(portalRequestTypes, requestListFilterModel.getPortal(), requestListFilterModel.getRequestType());
        String portalId = this.portalRequestListUtil.getPortalId(portalRequestTypeFilter);
        String requestTypeId = this.portalRequestListUtil.getRequestTypeId(portalRequestTypeFilter);
        MultiPortalSearchResult searchResult = this.getRequestsMatchingAllReqFilter(user, allVisiblePortals, requestListFilterModel, portalRequestTypeFilter);
        RequestListPageResponse requestListPageResponse = this.portalRequestListUtil.getRequestListPageResponse(searchResult, 20);
        String reporterFilterValue = this.requestListFilterModelParser.getReporterFilterValue(requestListFilterModel);
        String statusFilterValue = this.requestListFilterModelParser.getStatusFilterValue(requestListFilterModel.getStatus());
        return new RequestListResponse(reporterFilterValue, statusFilterValue, portalId, requestTypeId, (String)requestListFilterModel.getFilter().getOrNull(), requestListFilterModel.getPage(), requestListPageResponse.resultsPerPage, requestListPageResponse.totalResults, requestListPageResponse.totalPages, portalRequestTypes, requestListPageResponse.requests);
    }

    private MultiPortalSearchResult getRequestsMatchingAllReqFilter(CheckedUser user, AllVisiblePortals allVisiblePortals, RequestListFilterModel filterModel, PortalRequestTypeFilter portalRequestTypeFilter) {
        PagerFilter pagerFilter = this.portalRequestListUtil.createPager(filterModel.getPage(), 20);
        RequestListFilter filter2 = RequestListFilter.getBuilder().text(TextSearchFilter.summaryAndIssueKeyFilter((String)filterModel.getFilter().getOrElse((Object)""))).ownership(filterModel.getReporter()).status(filterModel.getStatus()).portalRequestType(portalRequestTypeFilter).sharedWithOrganisation((Integer)filterModel.getOrganisationId().getOrNull()).build();
        return this.requestListProvider.getCustomerRequests(user, allVisiblePortals, filter2, pagerFilter);
    }

    private List<PortalRequestTypes> getAllPortalsAndRequestTypesForUser(CheckedUser viewingUser, AllVisiblePortals allVisiblePortals) {
        RequestListFilter filter2 = RequestListFilter.getBuilder().status(CustomerRequestQuery.REQUEST_STATUS.ALL_REQUESTS).ownership(CustomerRequestQuery.REQUEST_OWNERSHIP.ALL_REQUESTS).build();
        PortalsAndRequestTypesResult portalsAndRequestTypes = this.requestListProvider.getPortalsAndRequestTypes(viewingUser, allVisiblePortals, filter2);
        return this.portalRequestListUtil.toPortalRequestTypesResponse(portalsAndRequestTypes);
    }
}

