/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request.avatar;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.api.user.UncheckedUser;
import com.atlassian.servicedesk.internal.feature.customer.request.avatar.SDAgentAvatarManager;
import com.atlassian.servicedesk.internal.feature.customer.request.avatar.SDAgentAvatarService;
import com.atlassian.servicedesk.internal.user.permission.ServiceDeskPermissions;
import io.atlassian.fugue.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SDAgentAvatarServiceImpl
implements SDAgentAvatarService {
    private final SDAgentAvatarManager agentAvatarManager;
    private final ServiceDeskPermissions serviceDeskPermissions;

    @Autowired
    public SDAgentAvatarServiceImpl(SDAgentAvatarManager agentAvatarManager, ServiceDeskPermissions serviceDeskPermissions) {
        this.agentAvatarManager = agentAvatarManager;
        this.serviceDeskPermissions = serviceDeskPermissions;
    }

    @Override
    public Option<Avatar> getAvatar(Long avatarId, UncheckedUser user) {
        if (this.hasExternalCustomerAccess(user) || this.hasJiraAccess(user)) {
            return this.agentAvatarManager.getAvatar(avatarId);
        }
        return this.agentAvatarManager.getDefaultAvatar();
    }

    private boolean hasExternalCustomerAccess(UncheckedUser uncheckedUser) {
        return this.serviceDeskPermissions.hasExternalCustomerAccess((SDUser)uncheckedUser);
    }

    private boolean hasJiraAccess(UncheckedUser uncheckedUser) {
        return this.serviceDeskPermissions.canAccessJIRA((SDUser)uncheckedUser);
    }
}

