/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request.activitystream.providers;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Suppliers;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.comments.CommentPermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.permission.outsider.OutsiderPermissionChecker;
import com.atlassian.servicedesk.internal.api.request.activitystream.items.ActivityItem;
import com.atlassian.servicedesk.internal.comment.InternalSDCommentManager;
import com.atlassian.servicedesk.internal.feature.customer.request.activitystream.providers.CommentActivityProvider;
import com.atlassian.servicedesk.internal.feature.reqparticipants.field.RequestParticipantsInternalService;
import com.atlassian.servicedesk.internal.spi.request.activitystream.items.ActivityItemComparator;
import com.atlassian.servicedesk.internal.spi.request.activitystream.items.CommentActivityItem;
import com.atlassian.servicedesk.internal.user.permission.ServiceDeskPermissions;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommentActivityProviderImpl
implements CommentActivityProvider {
    private final CommentManager commentManager;
    private final InternalSDCommentManager internalSDCommentManager;
    private final CommentPermissionManager commentPermissionManager;
    private final UserFactory userFactory;
    private final ServiceDeskPermissions serviceDeskPermissions;
    private final RequestParticipantsInternalService requestParticipantsInternalService;
    private final FeatureManager featureManager;
    private final OutsiderPermissionChecker outsiderPermissionChecker;

    @Autowired
    public CommentActivityProviderImpl(CommentManager commentManager, InternalSDCommentManager internalSDCommentManager, CommentPermissionManager commentPermissionManager, UserFactory userFactory, ServiceDeskPermissions serviceDeskPermissions, RequestParticipantsInternalService requestParticipantsInternalService, FeatureManager featureManager, OutsiderPermissionChecker outsiderPermissionChecker) {
        this.commentManager = commentManager;
        this.internalSDCommentManager = internalSDCommentManager;
        this.commentPermissionManager = commentPermissionManager;
        this.userFactory = userFactory;
        this.serviceDeskPermissions = serviceDeskPermissions;
        this.requestParticipantsInternalService = requestParticipantsInternalService;
        this.featureManager = featureManager;
        this.outsiderPermissionChecker = outsiderPermissionChecker;
    }

    public List<ActivityItem> getActivityStream(ApplicationUser user, Issue issue) {
        List<Comment> comments = this.getComments(user, issue);
        List<ActivityItem> items = this.buildCommentActivityItems(user, issue, comments);
        items.sort((Comparator<ActivityItem>)new ActivityItemComparator());
        return items;
    }

    @Override
    public CommentActivityItem getActivityItemForComment(ApplicationUser user, Issue issue, Comment comment) {
        return this.buildCommentActivityItem(user, issue, comment);
    }

    private List<Comment> getComments(ApplicationUser user, Issue issue) {
        return this.commentManager.getCommentsForUser(issue, user).stream().filter(comment -> this.internalSDCommentManager.isCommentVisibleInPortal(user, (Comment)comment)).collect(Collectors.toList());
    }

    private List<ActivityItem> buildCommentActivityItems(ApplicationUser currentUser, Issue issue, List<Comment> comments) {
        ArrayList<ActivityItem> items = new ArrayList<ActivityItem>();
        for (Comment comment : comments) {
            CommentActivityItem item = this.buildCommentActivityItem(currentUser, issue, comment);
            items.add((ActivityItem)item);
        }
        return items;
    }

    private CommentActivityItem buildCommentActivityItem(ApplicationUser currentUser, Issue issue, Comment comment) {
        boolean reporterComment = this.isReporterComment(issue, comment);
        boolean anonymousComment = this.isAnonymousComment(comment);
        boolean invisibleToReporter = !reporterComment && this.isInvisibleToReporter(issue, comment);
        boolean outsiderComment = this.isOutsiderComment(comment, issue, false);
        boolean canAddAuthorAsParticipant2 = this.isOutsiderComment(comment, issue, true) && this.canAddAuthorAsParticipant(currentUser, comment, issue);
        return new CommentActivityItem(comment, comment.getCreated().toInstant(), reporterComment, invisibleToReporter, anonymousComment, outsiderComment, canAddAuthorAsParticipant2);
    }

    private boolean isInvisibleToReporter(Issue issue, Comment comment) {
        return !this.commentPermissionManager.hasBrowsePermission(issue.getReporter(), comment);
    }

    private boolean isAnonymousComment(Comment comment) {
        return comment.getAuthorApplicationUser() == null;
    }

    private boolean isReporterComment(Issue issue, Comment comment) {
        return this.commentManager.isUserCommentAuthor(issue.getReporter(), comment);
    }

    private boolean isOutsiderComment(Comment comment, Issue issue, boolean includeFeatureFlagCheck) {
        return this.outsiderPermissionChecker.isUserAnOutsider(comment.getAuthorApplicationUser(), issue, includeFeatureFlagCheck);
    }

    private boolean canAddAuthorAsParticipant(ApplicationUser currentUser, Comment comment, Issue issue) {
        return (Boolean)Steps.begin((Either)this.userFactory.wrap(currentUser)).then(checkedCurrentUser -> this.userFactory.wrap(comment.getAuthorApplicationUser())).yield((checkedCurrentUser, checkedUser) -> this.requestParticipantsInternalService.validateAddOutsiderAsParticipant((CheckedUser)checkedCurrentUser, issue, (CheckedUser)checkedUser).isRight()).getOrElse(Suppliers.alwaysFalse());
    }
}

