/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request.activitystream;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.servicedesk.internal.api.request.activitystream.items.ActivityItem;
import com.atlassian.servicedesk.internal.feature.customer.request.activitystream.RequestActivityManager;
import com.atlassian.servicedesk.internal.feature.customer.request.activitystream.providers.CommentActivityProvider;
import com.atlassian.servicedesk.internal.feature.customer.request.activitystream.providers.StatusAndResolutionActivityProvider;
import com.atlassian.servicedesk.internal.spi.request.activitystream.ActivityProviderRegistry;
import com.atlassian.servicedesk.internal.spi.request.activitystream.items.ActivityItemComparator;
import com.atlassian.servicedesk.internal.spi.request.activitystream.providers.ActivityProvider;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Iterables;
import io.atlassian.fugue.Option;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class RequestActivityManagerImpl
implements RequestActivityManager,
ActivityProviderRegistry {
    private final CommentActivityProvider commentActivityProvider;
    private final StatusAndResolutionActivityProvider statusAndResolutionActivityProvider;
    private Option<ActivityProvider> approvalsActivityProvider;
    private final Logger logger = LoggerFactory.getLogger(RequestActivityManagerImpl.class);

    @Autowired
    public RequestActivityManagerImpl(CommentActivityProvider commentActivityProvider, StatusAndResolutionActivityProvider statusAndResolutionActivityProvider) {
        this.commentActivityProvider = commentActivityProvider;
        this.statusAndResolutionActivityProvider = statusAndResolutionActivityProvider;
        this.approvalsActivityProvider = Option.none();
    }

    @Override
    public Option<Instant> getMostRecentActivityDateForReporter(Issue issue) {
        Option<ActivityItem> recentItem = this.getMostRecentActivityForIssueReporter(issue);
        return (Option)recentItem.fold(Option::none, i -> Option.some((Object)i.getActivityInstant()));
    }

    @Override
    public List<ActivityItem> getActivityItems(ApplicationUser user, Issue issue) {
        List comments = this.commentActivityProvider.getActivityStreamMostRecentFirst(user, issue);
        List statusAndResolutionUpdates = this.statusAndResolutionActivityProvider.getActivityStreamMostRecentFirst(user, issue);
        ArrayList approvalsActivities = new ArrayList();
        if (this.approvalsActivityProvider.isDefined()) {
            approvalsActivities.addAll(((ActivityProvider)this.approvalsActivityProvider.get()).getActivityStreamMostRecentFirst(user, issue));
        }
        return Lists.newArrayList((Iterable)Iterables.concat((Iterable[])new Iterable[]{comments, statusAndResolutionUpdates, approvalsActivities})).stream().sorted(new ActivityItemComparator().reversed()).collect(Collectors.toList());
    }

    public void registerApprovalsActivityProvider(ActivityProvider activityProvider) {
        if (this.approvalsActivityProvider.isDefined()) {
            this.logger.warn("approvals activity provider is already registered");
        }
        this.approvalsActivityProvider = Option.some((Object)activityProvider);
    }

    public void unregisterApprovalsActivityProvider() {
        if (this.approvalsActivityProvider.isEmpty()) {
            this.logger.warn("approvals activity provider wasn't registered");
        }
        this.approvalsActivityProvider = Option.none();
    }

    private Option<ActivityItem> getMostRecentActivityForIssueReporter(Issue issue) {
        List<ActivityItem> activities = this.getActivityItems(issue.getReporterUser(), issue);
        if (activities.isEmpty()) {
            return Option.none();
        }
        ActivityItem recentItem = activities.get(0);
        return Option.some((Object)recentItem);
    }
}

