/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Eithers;
import com.atlassian.fugue.Option;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.request.CustomerRequest;
import com.atlassian.servicedesk.api.request.CustomerRequestCreateParameters;
import com.atlassian.servicedesk.api.request.CustomerRequestQuery;
import com.atlassian.servicedesk.api.request.CustomerRequestStatusQuery;
import com.atlassian.servicedesk.api.request.CustomerRequestUpdateParameters;
import com.atlassian.servicedesk.api.request.RequestTypeUpdateParameters;
import com.atlassian.servicedesk.api.request.ServiceDeskCustomerRequestService;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequest;
import com.atlassian.servicedesk.api.util.paging.PagedResponse;
import com.atlassian.servicedesk.api.util.paging.PagedResponseImpl;
import com.atlassian.servicedesk.internal.api.feature.servicedesk.InternalServiceDeskService;
import com.atlassian.servicedesk.internal.api.project.InternalServiceDeskProjectManager;
import com.atlassian.servicedesk.internal.api.requesttype.RequestTypeInternalService;
import com.atlassian.servicedesk.internal.feature.customer.portal.InternalPortalService;
import com.atlassian.servicedesk.internal.feature.customer.request.CustomerRequestCreateParametersImpl;
import com.atlassian.servicedesk.internal.feature.customer.request.CustomerRequestQueryImpl;
import com.atlassian.servicedesk.internal.feature.customer.request.CustomerRequestStatusQueryImpl;
import com.atlassian.servicedesk.internal.feature.customer.request.CustomerRequestUpdateParametersImpl;
import com.atlassian.servicedesk.internal.feature.customer.request.InternalCustomerRequestService;
import com.atlassian.servicedesk.internal.feature.customer.request.RequestTypeUpdateParametersImpl;
import com.atlassian.servicedesk.internal.feature.customer.request.list.RequestListProvider;
import com.atlassian.servicedesk.internal.feature.jira.issue.ServiceDeskIssueManager;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class ServiceDeskCustomerRequestServiceImpl
implements ServiceDeskCustomerRequestService {
    private final InternalCustomerRequestService internalCustomerRequestService;
    private final ServiceDeskIssueManager serviceDeskIssueManager;
    private final RequestListProvider requestListProvider;
    private final InternalPortalService internalPortalService;
    private final InternalServiceDeskService internalServiceDeskService;
    private final InternalServiceDeskProjectManager internalServiceDeskProjectManager;
    private final RequestTypeInternalService requestTypeInternalService;
    private final UserFactory userFactory;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    @Autowired
    public ServiceDeskCustomerRequestServiceImpl(InternalCustomerRequestService internalCustomerRequestService, ServiceDeskIssueManager serviceDeskIssueManager, RequestListProvider requestListProvider, InternalPortalService internalPortalService, InternalServiceDeskService internalServiceDeskService, InternalServiceDeskProjectManager internalServiceDeskProjectManager, RequestTypeInternalService requestTypeInternalService, UserFactory userFactory, JiraAuthenticationContext jiraAuthenticationContext) {
        this.internalCustomerRequestService = internalCustomerRequestService;
        this.serviceDeskIssueManager = serviceDeskIssueManager;
        this.requestListProvider = requestListProvider;
        this.internalPortalService = internalPortalService;
        this.internalServiceDeskService = internalServiceDeskService;
        this.internalServiceDeskProjectManager = internalServiceDeskProjectManager;
        this.requestTypeInternalService = requestTypeInternalService;
        this.userFactory = userFactory;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    public CustomerRequestCreateParameters.Builder newCreateBuilder() {
        return CustomerRequestCreateParametersImpl.builder();
    }

    public Either<AnError, CustomerRequest> createCustomerRequest(@Nullable ApplicationUser user, @Nonnull CustomerRequestCreateParameters customerRequestCreateParameters) {
        Assertions.notNull((String)"customerRequestCreateParameters", (Object)customerRequestCreateParameters);
        return Steps.begin((Either)this.userFactory.wrap(user)).then(cu -> StepsConverters.olderEither(this.internalCustomerRequestService.createCustomerRequest(cu.forJIRA(), customerRequestCreateParameters))).then((cu, issue) -> StepsConverters.olderEither(this.internalCustomerRequestService.asCustomerRequest(user, (Issue)issue))).yield((cu, issue, cr) -> cr);
    }

    @Nonnull
    public CustomerRequestQuery.Builder newQueryBuilder() {
        return CustomerRequestQueryImpl.builder();
    }

    @Nonnull
    public Either<AnError, PagedResponse<CustomerRequest>> getCustomerRequests(@Nullable ApplicationUser user, @Nonnull CustomerRequestQuery customerRequestQuery) {
        Assertions.notNull((String)"customerRequestQuery", (Object)customerRequestQuery);
        return Steps.begin((Either)this.userFactory.wrap(user)).then(cu -> this.dispatchCustomerRequestQuery(cu.forJIRA(), customerRequestQuery)).yield((cu, customerRequests) -> customerRequests).map(input -> PagedResponseImpl.toPagedResponse((LimitedPagedRequest)customerRequestQuery.pagedRequest(), (List)input));
    }

    private Either<AnError, List<CustomerRequest>> dispatchCustomerRequestQuery(@Nonnull ApplicationUser user, CustomerRequestQuery customerRequestQuery) {
        if (customerRequestQuery.issue().isPresent()) {
            long issueId = (Long)customerRequestQuery.issue().get();
            if (customerRequestQuery.requestOverrideSecurity().orElse(false).booleanValue()) {
                return Steps.begin((Either)StepsConverters.olderEither(this.serviceDeskIssueManager.getIssueById(issueId))).then(issue -> this.getRequestForIssueOverrideSecurityImpl((Issue)issue, user)).yield((i, r) -> Lists.newArrayList((Object[])new CustomerRequest[]{r}));
            }
            return Steps.begin((Either)StepsConverters.olderEither(this.serviceDeskIssueManager.getIssueById(issueId))).then(i -> this.getRequestForIssueImpl(user, (Issue)i)).yield((i, r) -> Lists.newArrayList((Object[])new CustomerRequest[]{r}));
        }
        if (customerRequestQuery.searchTerm().isPresent() || customerRequestQuery.requestOwnership().isPresent() || customerRequestQuery.requestStatus().isPresent() || customerRequestQuery.serviceDesk().isPresent()) {
            return this.getMyRequests(user, customerRequestQuery);
        }
        throw new UnsupportedOperationException("The CustomerRequestQuery is not valid. Please consult the documentation and provide some filters.");
    }

    private Either<AnError, List<CustomerRequest>> getMyRequests(ApplicationUser user, CustomerRequestQuery customerRequestQuery) {
        Option searchFilter = customerRequestQuery.searchTerm().isPresent() ? Option.some(customerRequestQuery.searchTerm().get()) : Option.none();
        CustomerRequestQuery.REQUEST_STATUS status = customerRequestQuery.requestStatus().orElse(CustomerRequestQuery.REQUEST_STATUS.ALL_REQUESTS);
        CustomerRequestQuery.REQUEST_OWNERSHIP requestOwnership = customerRequestQuery.requestOwnership().orElse(CustomerRequestQuery.REQUEST_OWNERSHIP.ALL_REQUESTS);
        Option pagerFilterOpt = Option.some((Object)new PagerFilter(customerRequestQuery.pagedRequest().getStart(), customerRequestQuery.pagedRequest().getMaxLimit() + 1));
        return Steps.begin((Either)this.userFactory.wrap(user)).then(cu -> this.getPortalByServiceDesk(user, customerRequestQuery.serviceDesk())).then((cu, p) -> this.getRequestTypeById(user, (Option<Portal>)p, customerRequestQuery.requestType())).yield((cu, p, rt) -> this.getMyRequests((CheckedUser)cu, (Option<String>)searchFilter, status, (Option<PagerFilter>)pagerFilterOpt, requestOwnership, (Option<Portal>)p, (Option<RequestType>)rt));
    }

    private Either<AnError, Option<Portal>> getPortalByServiceDesk(ApplicationUser user, Optional<Integer> serviceDeskId) {
        if (!serviceDeskId.isPresent()) {
            return Either.right((Object)Option.none());
        }
        return Steps.begin((Either)this.userFactory.wrap(user)).then(cu -> StepsConverters.olderEither((io.atlassian.fugue.Either)this.internalServiceDeskService.getServiceDeskById(cu, (long)((Integer)serviceDeskId.get()).intValue()))).then((cu, sd) -> StepsConverters.olderEither((io.atlassian.fugue.Either)this.internalServiceDeskProjectManager.getProject(Long.valueOf(sd.getProjectId())))).then((cu, sd, pr) -> StepsConverters.olderEither(this.internalPortalService.getPortalByProject((CheckedUser)cu, (Project)pr))).yield((cu, sd, pr, p) -> Option.some((Object)p));
    }

    private Either<AnError, Option<RequestType>> getRequestTypeById(ApplicationUser user, Option<Portal> portalOpt, Optional<Integer> requestTypeId) {
        if (portalOpt.isEmpty() || !requestTypeId.isPresent()) {
            return Either.right((Object)Option.none());
        }
        Portal portal = (Portal)portalOpt.get();
        return Steps.begin((Either)this.userFactory.wrap(user)).then(cu -> StepsConverters.olderEither((io.atlassian.fugue.Either)this.internalServiceDeskProjectManager.getProject(Long.valueOf(this.internalPortalService.toPortalInternal(portal).getProjectId())))).then((cu, p) -> StepsConverters.olderEither((io.atlassian.fugue.Either)this.requestTypeInternalService.getValidRequestTypeByPortal(cu, p, portal, (Integer)requestTypeId.get()))).yield((cu, p, rt) -> Option.some((Object)rt));
    }

    private List<CustomerRequest> getMyRequests(CheckedUser user, Option<String> searchFilterOpt, CustomerRequestQuery.REQUEST_STATUS status, Option<PagerFilter> pagerFilterOpt, CustomerRequestQuery.REQUEST_OWNERSHIP requestOwnership, Option<Portal> portalOpt, Option<RequestType> requestTypeOpt) {
        List<Issue> issues = this.requestListProvider.searchForCustomerRequestsAPI(user, requestOwnership, status, (io.atlassian.fugue.Option<Portal>)StepsConverters.newerOption(portalOpt), (io.atlassian.fugue.Option<RequestType>)StepsConverters.newerOption(requestTypeOpt), (io.atlassian.fugue.Option<String>)StepsConverters.newerOption(searchFilterOpt), (io.atlassian.fugue.Option<PagerFilter>)StepsConverters.newerOption(pagerFilterOpt));
        Iterable customerRequests = Eithers.filterRight((Iterable)Lists.transform(issues, issue -> StepsConverters.olderEither(this.internalCustomerRequestService.asCustomerRequest(user.forJIRA(), (Issue)issue))));
        return Lists.newArrayList((Iterable)customerRequests);
    }

    @Nonnull
    public CustomerRequestUpdateParameters.Builder newUpdateBuilder() {
        return CustomerRequestUpdateParametersImpl.builder();
    }

    @Nonnull
    public Either<AnError, CustomerRequest> updateCustomerRequest(ApplicationUser user, @Nonnull CustomerRequestUpdateParameters customerRequestUpdateParameters) {
        return Steps.begin((Either)this.userFactory.wrap(user)).then(() -> StepsConverters.olderEither(this.internalCustomerRequestService.updateRequestType(user, customerRequestUpdateParameters))).then((cu, issue) -> StepsConverters.olderEither(this.internalCustomerRequestService.asCustomerRequest(user, (Issue)issue))).yield((cu, issue, cr) -> cr);
    }

    @Nonnull
    @Deprecated
    public Either<AnError, CustomerRequest> getRequestForKey(ApplicationUser user, @Nonnull String issueKey) {
        Assertions.notNull((String)"issueKey", (Object)issueKey);
        return Steps.begin((Either)this.userFactory.wrap(user)).then(cu -> StepsConverters.olderEither(this.serviceDeskIssueManager.getIssueByKey(issueKey))).then((cu, issue) -> this.getRequestForIssueImpl(cu.forJIRA(), (Issue)issue)).yield((cu, issue, request) -> request);
    }

    @Nonnull
    @Deprecated
    public Either<AnError, CustomerRequest> getRequestForIssue(ApplicationUser user, @Nonnull Issue issue) {
        Assertions.notNull((String)"issue", (Object)issue);
        return this.getRequestForIssueImpl(user, issue);
    }

    private Either<AnError, CustomerRequest> getRequestForIssueImpl(ApplicationUser user, Issue issue) {
        return Steps.begin((Either)this.userFactory.wrap(user)).then(() -> StepsConverters.olderEither(this.internalCustomerRequestService.getRequestForIssue(user, issue))).then((cu, i) -> StepsConverters.olderEither(this.internalCustomerRequestService.asCustomerRequest(user, (Issue)i))).yield((cu, i, cr) -> cr);
    }

    @Deprecated
    public RequestTypeUpdateParameters.Builder requestTypeUpdateParametersBuilder() {
        return new RequestTypeUpdateParametersImpl.BuilderImpl();
    }

    @Nonnull
    @Deprecated
    public Either<AnError, CustomerRequest> updateRequestType(ApplicationUser user, @Nonnull RequestTypeUpdateParameters requestTypeUpdateParameters) {
        Assertions.notNull((String)"requestTypeUpdateParameters", (Object)requestTypeUpdateParameters);
        return Steps.begin((Either)this.userFactory.wrap(user)).then(cu -> StepsConverters.olderEither(this.internalCustomerRequestService.updateRequestType(cu.forJIRA(), requestTypeUpdateParameters))).then((cu, issue) -> StepsConverters.olderEither(this.internalCustomerRequestService.asCustomerRequest(user, (Issue)issue))).yield((cu, i, cr) -> cr);
    }

    @Nonnull
    @Deprecated
    public Either<AnError, CustomerRequest> getRequestForIssueOverrideSecurity(@Nonnull Issue issue) {
        Assertions.notNull((String)"issue", (Object)issue);
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        return this.getRequestForIssueOverrideSecurityImpl(issue, user);
    }

    private Either<AnError, CustomerRequest> getRequestForIssueOverrideSecurityImpl(Issue issue, ApplicationUser user) {
        return Steps.begin((Either)StepsConverters.olderEither(this.internalCustomerRequestService.getRequestForIssueOverrideSecurity(issue))).then(i -> StepsConverters.olderEither(this.internalCustomerRequestService.asCustomerRequest(user, (Issue)i))).yield((i, cr) -> cr);
    }

    @Nonnull
    @Deprecated
    public Either<AnError, CustomerRequest> getRequestForKeyOverrideSecurity(@Nonnull String issueKey) {
        Assertions.notNull((String)"issueKey", (Object)issueKey);
        return Steps.begin((Either)StepsConverters.olderEither(this.serviceDeskIssueManager.getIssueByKey(issueKey))).then(this::getRequestForIssueOverrideSecurity).yield((i, r) -> r);
    }

    public CustomerRequestStatusQuery.Builder newStatusQueryBuilder() {
        return CustomerRequestStatusQueryImpl.builder();
    }

    @Nonnull
    public Either<AnError, PagedResponse<CustomerRequest.CustomerRequestStatus>> getCustomerRequestStatus(@Nullable ApplicationUser user, @Nonnull CustomerRequestStatusQuery query) {
        Assertions.notNull((String)"query", (Object)query);
        return Steps.begin((Either)this.userFactory.wrap(user)).then(cu -> StepsConverters.olderEither(this.serviceDeskIssueManager.getIssueById(query.issue()))).then((cu, issue) -> StepsConverters.olderEither(this.internalCustomerRequestService.getRequestForIssue(cu.forJIRA(), (Issue)issue))).then((cu, issue, request) -> StepsConverters.olderEither(this.internalCustomerRequestService.getCustomerRequestStatus(user, (Issue)issue))).yield((cu, issue, request, status) -> PagedResponseImpl.toPagedResponse((LimitedPagedRequest)query.pagedRequest(), (List)status));
    }
}

