/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.project.Project;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.internal.feature.customer.portal.PortalInternalManager;
import com.atlassian.servicedesk.internal.feature.customer.request.IssueUrlConverter;
import com.atlassian.servicedesk.internal.user.permission.ServiceDeskPermissions;
import com.atlassian.servicedesk.internal.utils.HardCodedValuesScala;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IssueUrlConverterImpl
implements IssueUrlConverter {
    @Autowired
    private IssueManager jiraIssueManager;
    @Autowired
    private PortalInternalManager portalManager;
    @Autowired
    private ServiceDeskPermissions serviceDeskPermissions;
    private final Pattern BASE_URL_PATTERN = Pattern.compile("(http[s]*://.+?)/browse/([A-Z][\\w]*-[\\d]+)");
    private final String REQUEST_URL_SCHEME = "%s" + HardCodedValuesScala.ServiceDeskWebPortalPrefix() + "/%s/%s";
    private Function<MutableIssue, Option<Project>> getProjectFromIssueFunction;
    private Function<Portal, Option<Integer>> getPortalIdFromPortalFunction;
    private Function<Project, Option<Portal>> getPortalFromProjectFunction;

    @Override
    public String replaceIssueUrlsWithPortalRequestUrls(String comment, Option<CheckedUser> viewingUser) {
        if (!this.hasExternalCustomerAccess(viewingUser)) {
            return comment;
        }
        List<String> issueUrls = this.extractIssueUrls(comment);
        List<String> customerUrls = this.getCustomerUrls(issueUrls, viewingUser);
        String[] issueUrlArray = issueUrls.toArray(new String[issueUrls.size()]);
        String[] customerUrlArray = customerUrls.toArray(new String[customerUrls.size()]);
        return StringUtils.replaceEach((String)comment, (String[])issueUrlArray, (String[])customerUrlArray);
    }

    private boolean hasExternalCustomerAccess(Option<CheckedUser> viewingUser) {
        return viewingUser.isDefined() && this.serviceDeskPermissions.hasExternalCustomerAccess((SDUser)viewingUser.get());
    }

    private List<String> extractIssueUrls(String comment) {
        Matcher matcher = this.BASE_URL_PATTERN.matcher(comment);
        ArrayList urls = Lists.newArrayList();
        while (matcher.find()) {
            String url = matcher.group(0);
            urls.add(url);
        }
        return urls;
    }

    private List<String> getCustomerUrls(@Nonnull List<String> urls, Option<CheckedUser> viewingUser) {
        ArrayList customerUrls = Lists.newArrayList();
        for (String url : urls) {
            String customerUrl = (String)this.convertJiraIssueUrlToPortalRequestUrl(url, viewingUser).getOrNull();
            customerUrls.add(customerUrl);
        }
        return customerUrls;
    }

    @VisibleForTesting
    private Option<String> convertJiraIssueUrlToPortalRequestUrl(String url, Option<CheckedUser> viewingUser) {
        return Option.option((Object)url).flatMap(someUrl -> {
            Matcher matcher = this.BASE_URL_PATTERN.matcher((CharSequence)someUrl);
            if (matcher.find() && matcher.groupCount() == 2) {
                String baseUrl = matcher.group(1);
                String issueKey = matcher.group(2);
                Option<Integer> portalId = this.getPortalId(issueKey);
                if (this.userIsCustomerOfIssue(issueKey, viewingUser) && portalId.isDefined()) {
                    return Option.option((Object)String.format(this.REQUEST_URL_SCHEME, baseUrl, ((Integer)portalId.get()).toString(), issueKey));
                }
            }
            return Option.none();
        });
    }

    @VisibleForTesting
    boolean userIsCustomerOfIssue(String issueKey, Option<CheckedUser> viewingUser) {
        Option issue = Option.option((Object)this.jiraIssueManager.getIssueObject(issueKey));
        return viewingUser.isDefined() && issue.isDefined() && this.serviceDeskPermissions.userIsCustomerOfIssue((SDUser)viewingUser.get(), (Issue)issue.get());
    }

    @VisibleForTesting
    Option<Integer> getPortalId(String issueKey) {
        return Option.option((Object)this.jiraIssueManager.getIssueObject(issueKey)).flatMap(this.getProjectFromIssueFunction()).flatMap(this.getPortalFromProjectFunction()).flatMap(this.getPortalIdFromPortalFunction());
    }

    private Function<MutableIssue, Option<Project>> getProjectFromIssueFunction() {
        if (Option.option(this.getProjectFromIssueFunction).isEmpty()) {
            this.getProjectFromIssueFunction = input -> Option.option((Object)input.getProjectObject());
        }
        return this.getProjectFromIssueFunction;
    }

    private Function<Project, Option<Portal>> getPortalFromProjectFunction() {
        if (Option.option(this.getPortalFromProjectFunction).isEmpty()) {
            this.getPortalFromProjectFunction = input -> this.portalManager.getPortalByProject((Project)input).right().toOption().map(p -> p);
        }
        return this.getPortalFromProjectFunction;
    }

    private Function<Portal, Option<Integer>> getPortalIdFromPortalFunction() {
        if (Option.option(this.getPortalIdFromPortalFunction).isEmpty()) {
            this.getPortalIdFromPortalFunction = portal -> Option.option((Object)portal.getId());
        }
        return this.getPortalIdFromPortalFunction;
    }
}

