/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.renderers.CommentFieldRenderContext;
import com.atlassian.jira.issue.renderers.FieldRenderContext;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.request.CustomerTextRenderer;
import com.atlassian.servicedesk.internal.feature.customer.request.CustomerTextInternalRenderer;
import com.atlassian.servicedesk.internal.feature.customer.request.IssueUrlConverter;
import com.atlassian.servicedesk.internal.utils.CustomerUrlUtil;
import com.google.common.collect.ImmutableSet;
import io.atlassian.fugue.Option;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
@ExportAsService(value={CustomerTextRenderer.class})
public class CustomerTextRendererImpl
implements CustomerTextInternalRenderer {
    private static final Logger log = LoggerFactory.getLogger(CustomerTextRendererImpl.class);
    private static final String WHITE_LIST_PATTERN = "(\\Q" + StringUtils.join(CustomerUrlUtil.SHIM_WHITE_LIST, (String)"\\E|\\Q") + "\\E)";
    private static final String FROM_ISSUE_QUERY_STRING = "fromIssue";
    private final RendererManager rendererManager;
    private final WebResourceUrlProvider webResourceUrlProvider;
    private final IssueUrlConverter issueUrlConverter;
    private final ApplicationProperties applicationProperties;

    @Autowired
    public CustomerTextRendererImpl(RendererManager rendererManager, WebResourceUrlProvider webResourceUrlProvider, IssueUrlConverter issueUrlConverter, ApplicationProperties applicationProperties) {
        this.rendererManager = rendererManager;
        this.webResourceUrlProvider = webResourceUrlProvider;
        this.issueUrlConverter = issueUrlConverter;
        this.applicationProperties = applicationProperties;
    }

    private static boolean isInWebContext() {
        return ExecutingHttpRequest.get() != null;
    }

    @Override
    @Nonnull
    public String renderComment(Comment comment, Option<CheckedUser> viewingUser) {
        String jiraRenderedComment = this.renderCommentNotShimmed(comment);
        return this.updateTextForCustomer(jiraRenderedComment, viewingUser, (Option<Long>)Option.some((Object)comment.getIssue().getId()));
    }

    private void addQueryStringToCustomerLinks(Document document, Long issueId) {
        this.addQueryStringToAttachmentLinks(issueId, document);
        this.addQueryStringToImageLinks(issueId, document);
    }

    private void addQueryStringToImageLinks(Long issueId, Document document) {
        Elements images = document.select("img");
        images.forEach(image -> {
            String imgSrc = image.attr("src");
            if (!image.classNames().contains("icon") && this.isShimmed(imgSrc)) {
                image.attr("src", this.addFromIssueQueryString(imgSrc, issueId));
            }
        });
    }

    private void addQueryStringToAttachmentLinks(Long issueId, Document document) {
        Elements links = document.select("a[href]");
        links.forEach(link -> {
            String href = link.attr("href");
            if (this.isShimmedAttachmentUrl(href)) {
                link.attr("href", this.addFromIssueQueryString(href, issueId));
            }
        });
    }

    private String addFromIssueQueryString(String url, Long issueId) {
        try {
            return UriBuilder.fromUri((String)url).queryParam(FROM_ISSUE_QUERY_STRING, new Object[]{issueId}).build(new Object[0]).toString();
        }
        catch (IllegalArgumentException e) {
            log.warn("Illegal URL passed when trying to add issue parameter to shimmed URL: " + url);
            return url;
        }
    }

    private boolean isShimmedAttachmentUrl(String url) {
        return url.toLowerCase().contains("/servicedesk/customershim/secure/attachment");
    }

    @Override
    @Nonnull
    public String renderCommentNotShimmed(Comment comment) {
        return this.rendererManager.getRenderedContent((FieldRenderContext)new CommentFieldRenderContext(comment));
    }

    @Nonnull
    public String updateTextForCustomer(String renderedValue, Option<CheckedUser> viewingUser, Option<Long> issueIdOpt) {
        return this.updateCustomerTextIntertal(renderedValue, viewingUser, issueIdOpt, true).body().html();
    }

    public String updateEmailTextForCustomer(String renderedValue, Option<CheckedUser> viewingUser, Option<Long> issueIdOpt) {
        return this.updateCustomerTextIntertal(renderedValue, viewingUser, issueIdOpt, false).html();
    }

    private Document updateCustomerTextIntertal(String renderedValue, Option<CheckedUser> viewingUser, Option<Long> issueIdOpt, boolean bodyFragment) {
        String shimmedContent = this.shimJiraUrls(renderedValue);
        shimmedContent = this.issueUrlConverter.replaceIssueUrlsWithPortalRequestUrls(shimmedContent, viewingUser);
        Document document = bodyFragment ? Jsoup.parseBodyFragment((String)shimmedContent) : Jsoup.parse((String)shimmedContent);
        document.outputSettings().prettyPrint(false);
        issueIdOpt.forEach(issueId -> this.addQueryStringToCustomerLinks(document, (Long)issueId));
        return document;
    }

    private String shimJiraUrls(String renderedText) {
        String baseUrlPattern = this.getBaseUrlPattern();
        String renderedUrlsPattern = String.format("(?i)(<\\b(?:a|img)\\b[^>]*?\\b(?:href|src)\\b=\"(?:%s))(%s)", baseUrlPattern, WHITE_LIST_PATTERN);
        String shimmedUrlsPattern = "$1/servicedesk/customershim$2";
        return renderedText.replaceAll(renderedUrlsPattern, shimmedUrlsPattern);
    }

    private boolean isShimmed(String url) {
        return url.contains("/servicedesk/customershim");
    }

    private String getBaseUrlPattern() {
        ImmutableSet.Builder urls = ImmutableSet.builder();
        String baseUrl = StringUtils.removeEnd((String)this.applicationProperties.getString("jira.baseurl"), (String)"/");
        urls.add((Object)baseUrl);
        urls.add((Object)this.webResourceUrlProvider.getBaseUrl(UrlMode.ABSOLUTE));
        if (CustomerTextRendererImpl.isInWebContext()) {
            urls.add((Object)this.webResourceUrlProvider.getBaseUrl(UrlMode.RELATIVE));
            try {
                URI url = new URI(baseUrl);
                urls.add((Object)url.getPath());
            }
            catch (URISyntaxException e) {
                log.warn("There is an issue with the JIRA Base URL", (Throwable)e);
            }
        }
        return StringUtils.join((Collection)urls.build(), (String)"|");
    }
}

