/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request;

import com.atlassian.servicedesk.api.request.CustomerRequestStatusQuery;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequest;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequestImpl;
import com.atlassian.servicedesk.api.util.paging.PagedRequest;
import com.atlassian.util.concurrent.Assertions;

public class CustomerRequestStatusQueryImpl
implements CustomerRequestStatusQuery {
    private Long issue;
    private LimitedPagedRequest pagedRequest;

    private CustomerRequestStatusQueryImpl(long issue, LimitedPagedRequest pagedRequest) {
        this.issue = issue;
        this.pagedRequest = pagedRequest;
    }

    public long issue() {
        return this.issue;
    }

    public LimitedPagedRequest pagedRequest() {
        return this.pagedRequest;
    }

    public static CustomerRequestStatusQuery.Builder builder() {
        return new BuilderImpl();
    }

    public static class BuilderImpl
    implements CustomerRequestStatusQuery.Builder {
        private Long issue;
        private LimitedPagedRequest pagedRequest = LimitedPagedRequestImpl.create((int)100);

        private BuilderImpl() {
        }

        public CustomerRequestStatusQuery.Builder issue(long issue) {
            this.issue = issue;
            return this;
        }

        public CustomerRequestStatusQuery.Builder pagedRequest(PagedRequest pagedRequest) {
            this.pagedRequest = LimitedPagedRequestImpl.create((PagedRequest)pagedRequest, (int)100);
            return this;
        }

        public CustomerRequestStatusQuery build() {
            Assertions.notNull((String)"issue", (Object)this.issue);
            return new CustomerRequestStatusQueryImpl(this.issue, this.pagedRequest);
        }
    }
}

