/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.feature.customer.request.CustomerRequestStatusManager;
import com.atlassian.servicedesk.internal.api.request.requesttype.status.RequestStatusService;
import com.atlassian.servicedesk.internal.api.requesttype.RequestTypeInternalService;
import io.atlassian.fugue.Option;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
class CustomerRequestStatusManagerImpl
implements CustomerRequestStatusManager {
    private final RequestTypeInternalService requestTypeInternalService;
    private final RequestStatusService requestStatusService;
    private final UserFactory userFactory;
    private final WorkflowManager workflowManager;
    private final ErrorResultHelper errorResultHelper;

    @Autowired
    public CustomerRequestStatusManagerImpl(RequestTypeInternalService requestTypeInternalService, RequestStatusService requestStatusService, UserFactory userFactory, WorkflowManager workflowManager, ErrorResultHelper errorResultHelper) {
        this.requestTypeInternalService = requestTypeInternalService;
        this.requestStatusService = requestStatusService;
        this.userFactory = userFactory;
        this.workflowManager = workflowManager;
        this.errorResultHelper = errorResultHelper;
    }

    public io.atlassian.fugue.Either<AnError, String> retrieveRequestStatus(ApplicationUser user, Issue issue) {
        return this.retrieveCustomerVisibleStatus(user, issue, issue.getStatus());
    }

    public io.atlassian.fugue.Either<AnError, String> retrieveCustomerVisibleStatus(ApplicationUser user, Issue issue, String statusId) {
        return this.retrieveStatusForIssue(issue, statusId).flatMap(status -> this.retrieveCustomerVisibleStatus(user, issue, (Status)status));
    }

    private io.atlassian.fugue.Either<AnError, String> retrieveCustomerVisibleStatus(ApplicationUser user, Issue issue, Status status) {
        return Steps.begin(this.getRequestType(user, issue)).then(requestType -> io.atlassian.fugue.Either.right((Object)this.requestStatusService.getStatusMapper(requestType))).yield((requestType, requestStatusMapper) -> requestStatusMapper.translateToCustomerStatus(status));
    }

    private io.atlassian.fugue.Either<AnError, Status> retrieveStatusForIssue(Issue issue, String statusId) {
        return Steps.begin(this.getWorkflow(issue)).then(this::getStatuses).then((workflow, statuses) -> this.getStatusWithId((List<Status>)statuses, statusId)).yield((workflow, statuses, status) -> status);
    }

    private io.atlassian.fugue.Either<AnError, JiraWorkflow> getWorkflow(Issue issue) {
        return Option.option((Object)this.workflowManager.getWorkflow(issue)).toRight(() -> this.errorResultHelper.internalServiceError500("sd.if.customer.visible.status.workflow.missing", new Object[0]).build());
    }

    private io.atlassian.fugue.Either<AnError, List<Status>> getStatuses(JiraWorkflow workflow) {
        return Option.option((Object)workflow.getLinkedStatusObjects()).toRight(() -> this.errorResultHelper.internalServiceError500("sd.if.customer.visible.status.workflow.missing", new Object[0]).build());
    }

    private io.atlassian.fugue.Either<AnError, RequestType> getRequestType(ApplicationUser user, Issue issue) {
        return StepsConverters.newerEither((Either)this.userFactory.wrap(user)).flatMap(checkedUser -> this.requestTypeInternalService.getRequestTypeForIssue(checkedUser, issue));
    }

    private io.atlassian.fugue.Either<AnError, Status> getStatusWithId(List<Status> statuses, String statusId) {
        return Option.option(statuses.stream().filter(status -> status.getId().equals(statusId)).findFirst().orElse(null)).toRight(() -> this.errorResultHelper.internalServiceError500("sd.if.customer.visible.status.with.id.missing", new Object[]{statusId}).build());
    }
}

