/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.request;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.servicedesk.api.request.CustomerRequestChannelSource;
import com.atlassian.servicedesk.api.request.CustomerRequestChannelSourceI18nService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class CustomerRequestChannelSourceI18nServiceImpl
implements CustomerRequestChannelSourceI18nService {
    private final I18nHelper.BeanFactory i18nHelperFactory;

    @Autowired
    public CustomerRequestChannelSourceI18nServiceImpl(I18nHelper.BeanFactory i18nHelperFactory) {
        this.i18nHelperFactory = i18nHelperFactory;
    }

    public CustomerRequestChannelSourceI18nService.CustomerRequestChannelRenderedName getDisplayChannelSource(ApplicationUser user, CustomerRequestChannelSource channelSource) {
        String tooltip;
        String name;
        I18nHelper i18nHelper = this.i18nHelperFactory.getInstance(user);
        if (CustomerRequestChannelSource.PORTAL.equals((Object)channelSource)) {
            name = i18nHelper.getText("sd.portal.issueview.requestchannel.value.portal");
            tooltip = i18nHelper.getText("sd.portal.issueview.requestchannel.tooltip.portal");
        } else if (CustomerRequestChannelSource.EMAIL.equals((Object)channelSource)) {
            name = i18nHelper.getText("sd.portal.issueview.requestchannel.value.email");
            tooltip = i18nHelper.getText("sd.portal.issueview.requestchannel.tooltip.email");
        } else if (CustomerRequestChannelSource.API.equals((Object)channelSource)) {
            name = i18nHelper.getText("sd.portal.issueview.requestchannel.value.api");
            tooltip = i18nHelper.getText("sd.portal.issueview.requestchannel.tooltip.api");
        } else if (CustomerRequestChannelSource.JIRA.equals((Object)channelSource)) {
            name = i18nHelper.getText("sd.portal.issueview.requestchannel.value.jira");
            tooltip = i18nHelper.getText("sd.portal.issueview.requestchannel.tooltip.jira");
        } else {
            String nameKey = "sd.customer.request.channel.source.name." + channelSource.value();
            name = i18nHelper.isKeyDefined(nameKey) ? i18nHelper.getText(nameKey) : channelSource.value();
            String tooltipKey = "sd.customer.request.channel.source.tooltip." + channelSource.value();
            tooltip = i18nHelper.isKeyDefined(tooltipKey) ? i18nHelper.getText(tooltipKey) : "";
        }
        return new CustomerRequestChannelRenderedNameImpl(name, tooltip);
    }

    private final class CustomerRequestChannelRenderedNameImpl
    implements CustomerRequestChannelSourceI18nService.CustomerRequestChannelRenderedName {
        private final String renderedName;
        private final String tooltip;

        private CustomerRequestChannelRenderedNameImpl(String renderedName, String tooltip) {
            this.renderedName = renderedName;
            this.tooltip = tooltip;
        }

        public String getRenderedName() {
            return this.renderedName;
        }

        public String getToolTip() {
            return this.tooltip;
        }
    }
}

