/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal.providers.user;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.timezone.TimeZoneInfo;
import com.atlassian.jira.timezone.TimeZoneService;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.internal.api.project.InternalServiceDeskProjectManager;
import com.atlassian.servicedesk.internal.api.webfragments.WebItemBean;
import com.atlassian.servicedesk.internal.customer.profile.CustomerProfileContext;
import com.atlassian.servicedesk.internal.customer.profile.CustomerProfileCustomMenuLinksService;
import com.atlassian.servicedesk.internal.feature.customer.approvals.ApprovalListProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.PortalInternalManager;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.TimezonesResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.request.list.ApprovalQueryType;
import com.atlassian.servicedesk.internal.feature.customer.request.list.RequestListProvider;
import com.atlassian.servicedesk.internal.feature.customer.user.SDUserPreferencesManager;
import com.atlassian.servicedesk.internal.rest.responses.TimeZoneResponse;
import com.atlassian.servicedesk.internal.user.permission.ServiceDeskPermissions;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserResponseProviderDataHelper {
    private final UserManager userManager;
    private final SDUserPreferencesManager sdUserPreferencesManager;
    private final TimeZoneService timeZoneService;
    private final AvatarService avatarService;
    private final TimezonesResponseProvider timezonesResponseProvider;
    private final RequestListProvider requestListProvider;
    private final ServiceDeskPermissions serviceDeskPermissions;
    private final ApprovalListProvider approvalListProvider;
    private final CustomerProfileCustomMenuLinksService profileCustomMenuLinksService;
    private final PortalInternalManager portalManager;
    private final InternalServiceDeskProjectManager internalServiceDeskProjectManager;

    @Autowired
    public UserResponseProviderDataHelper(UserManager userManager, SDUserPreferencesManager sdUserPreferencesManager, TimeZoneService timeZoneService, AvatarService avatarService, TimezonesResponseProvider timezonesResponseProvider, RequestListProvider requestListProvider, ServiceDeskPermissions serviceDeskPermissions, ApprovalListProvider approvalListProvider, CustomerProfileCustomMenuLinksService profileCustomMenuLinksService, PortalInternalManager portalManager, InternalServiceDeskProjectManager internalServiceDeskProjectManager) {
        this.userManager = userManager;
        this.sdUserPreferencesManager = sdUserPreferencesManager;
        this.timeZoneService = timeZoneService;
        this.avatarService = avatarService;
        this.timezonesResponseProvider = timezonesResponseProvider;
        this.requestListProvider = requestListProvider;
        this.serviceDeskPermissions = serviceDeskPermissions;
        this.approvalListProvider = approvalListProvider;
        this.profileCustomMenuLinksService = profileCustomMenuLinksService;
        this.portalManager = portalManager;
        this.internalServiceDeskProjectManager = internalServiceDeskProjectManager;
    }

    boolean canAdministerJIRA(CheckedUser user) {
        return this.serviceDeskPermissions.canAdministerJIRA((SDUser)user);
    }

    boolean isAgentForPortal(CheckedUser user, Long portalId) {
        return (Boolean)Steps.begin(this.portalManager.getPortalById(portalId)).then(portal -> this.internalServiceDeskProjectManager.getProject(Long.valueOf(portal.getProjectId()))).yield((portal, project) -> this.serviceDeskPermissions.canViewAgentView((SDUser)user, (Project)project)).fold(err -> false, result -> result);
    }

    String getNotificationType(CheckedUser user) {
        return this.sdUserPreferencesManager.getNotificationType(user);
    }

    List<WebItemBean> getCustomMenuLinks(CheckedUser user) {
        return this.profileCustomMenuLinksService.getLinks(new CustomerProfileContext(user.forJIRA()));
    }

    long getApprovalsCount(CheckedUser user) {
        return this.approvalListProvider.getApprovalCount(user, ApprovalQueryType.MY_HISTORY_APPROVAL);
    }

    long getPendingApprovalsCount(CheckedUser user, long approvalCount) {
        if (approvalCount > 0L) {
            return this.approvalListProvider.getApprovalCount(user, ApprovalQueryType.MY_PENDING_APPROVAL);
        }
        return approvalCount;
    }

    long getAllOpenRequestsCount(CheckedUser user) {
        try {
            return this.requestListProvider.getOpenRequestsCountForUser(user);
        }
        catch (SearchException e) {
            return 0L;
        }
    }

    boolean canUpdateUser(CheckedUser user) {
        return this.userManager.userCanUpdateOwnDetails(user.forJIRA());
    }

    boolean canUserChangePassword(CheckedUser user, boolean canUpdateUser) {
        return canUpdateUser && this.userManager.canUpdateUserPassword(user.forJIRA());
    }

    TimeZoneResponse getTimezoneResponse(CheckedUser user) {
        JiraServiceContext jiraServiceContext = this.getJiraServiceContext(user);
        TimeZoneInfo userTimeZoneInfo = this.timeZoneService.getUserTimeZoneInfo(jiraServiceContext);
        if (this.timeZoneService.usesJiraTimeZone(jiraServiceContext)) {
            return this.timezonesResponseProvider.getDefaultJiraTimezone(user);
        }
        return new TimeZoneResponse(userTimeZoneInfo.getTimeZoneId(), userTimeZoneInfo.getRegionKey(), userTimeZoneInfo.getCity(), userTimeZoneInfo.getGMTOffset());
    }

    Map<String, String> getAvatars(CheckedUser user) {
        return ImmutableMap.builder().put((Object)"xsmall", (Object)this.getAvatarUrlString(user, Avatar.Size.SMALL)).put((Object)"small", (Object)this.getAvatarUrlString(user, Avatar.Size.NORMAL)).put((Object)"medium", (Object)this.getAvatarUrlString(user, Avatar.Size.MEDIUM)).put((Object)"large", (Object)this.getAvatarUrlString(user, Avatar.Size.LARGE)).put((Object)"xlarge", (Object)this.getAvatarUrlString(user, this.getXLargeAvatarURI(user))).build();
    }

    private String getAvatarUrlString(CheckedUser user, Avatar.Size size) {
        return this.avatarService.getAvatarUrlNoPermCheck(user.forJIRA(), size).toString();
    }

    private Avatar.Size getXLargeAvatarURI(CheckedUser user) {
        if (this.avatarService.getAvatar(user.forJIRA(), user.forJIRA()).isSystemAvatar()) {
            return Avatar.Size.LARGE;
        }
        return Avatar.Size.XLARGE;
    }

    private JiraServiceContext getJiraServiceContext(CheckedUser user) {
        return new JiraServiceContextImpl(user.forJIRA());
    }
}

