/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal.providers.request;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.feature.customer.portal.InternalPortalService;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.CustomerResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.IssueViewProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.RequestDetailsResponseProviderHelper;
import com.atlassian.servicedesk.internal.feature.customer.request.CreateIssueResponse;
import com.atlassian.servicedesk.internal.feature.jira.issue.IssueHelper;
import com.atlassian.servicedesk.internal.feature.jira.project.ServiceDeskProjectService;
import com.atlassian.servicedesk.internal.rest.requests.ModelsRequest;
import com.atlassian.servicedesk.internal.rest.responses.CustomerRequestView;
import com.atlassian.servicedesk.internal.rest.responses.RequestDetailsResponse;
import io.atlassian.fugue.Pair;
import io.atlassian.fugue.Unit;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
public class RequestDetailsResponseProvider
implements CustomerResponseProvider<RequestDetailsResponse> {
    private final UserFactory userFactory;
    private final IssueViewProvider issueViewProvider;
    private final ServiceDeskProjectService sdProjectService;
    private final ServiceDeskService serviceDeskService;
    private final InternalPortalService internalPortalService;
    private final CommonErrors commonErrors;
    private final RequestDetailsResponseProviderHelper requestDetailsResponseProviderHelper;
    private final IssueHelper issueHelper;

    @Autowired
    public RequestDetailsResponseProvider(UserFactory userFactory, IssueViewProvider issueViewProvider, ServiceDeskProjectService sdProjectService, ServiceDeskService serviceDeskService, InternalPortalService internalPortalService, CommonErrors commonErrors, RequestDetailsResponseProviderHelper requestDetailsResponseProviderHelper, IssueHelper issueHelper) {
        this.userFactory = userFactory;
        this.issueViewProvider = issueViewProvider;
        this.sdProjectService = sdProjectService;
        this.serviceDeskService = serviceDeskService;
        this.internalPortalService = internalPortalService;
        this.commonErrors = commonErrors;
        this.requestDetailsResponseProviderHelper = requestDetailsResponseProviderHelper;
        this.issueHelper = issueHelper;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, RequestDetailsResponse> getResponse(ModelsRequest ctx) {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.getIssue((CheckedUser)user, ctx)).then((user, issue) -> this.getPortalAndProject((CheckedUser)user, (Issue)issue, ctx)).then((user, issue, portalProjectPair) -> this.getServiceDesk((CheckedUser)user, (Project)portalProjectPair.right())).then((user, issue, portalProjectPair, serviceDesk) -> this.getResponse((CheckedUser)user, (Issue)issue, (Portal)portalProjectPair.left(), (Project)portalProjectPair.right(), (ServiceDesk)serviceDesk)).yield((user, issue, portalProjectPair, serviceDesk, response) -> response);
    }

    public io.atlassian.fugue.Either<AnError, RequestDetailsResponse> getRequestDetailsResponse(@Nonnull CheckedUser user, @Nonnull Issue issue) {
        Objects.requireNonNull(user, "user");
        Objects.requireNonNull(issue, "issue");
        return Steps.begin(this.issueHelper.getProjectFromIssue(issue)).then(project -> StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskForProject(user.forJIRA(), project))).then((project, serviceDesk) -> this.internalPortalService.getPortalByProject(user, (Project)project)).then((project, serviceDesk, portal) -> this.getResponse(user, issue, (Portal)portal, (Project)project, (ServiceDesk)serviceDesk)).yield((project, serviceDesk, portal, requestDetailsResponse) -> requestDetailsResponse);
    }

    private io.atlassian.fugue.Either<AnError, Issue> getIssue(CheckedUser user, ModelsRequest ctx) {
        return this.issueViewProvider.getRawIssue(user, ctx.getOptions().getReqDetails().getKey());
    }

    private io.atlassian.fugue.Either<AnError, Pair<Portal, Project>> getPortalAndProject(CheckedUser user, Issue issue, ModelsRequest ctx) {
        return Steps.begin(this.internalPortalService.getPortalById(user, ctx.getOptions().getPortalId())).then(portal -> this.sdProjectService.getProjectById(user, issue.getProjectId())).then((portal, project) -> this.checkPortalAndProjectMatch((Portal)portal, (Project)project)).yield((portal, project, unit) -> Pair.pair((Object)portal, (Object)project));
    }

    private io.atlassian.fugue.Either<AnError, Unit> checkPortalAndProjectMatch(Portal portal, Project project) {
        long projectId = this.internalPortalService.getProjectIdForPortal(portal);
        if (projectId != project.getId()) {
            return io.atlassian.fugue.Either.left((Object)this.commonErrors.PROJECT_NOT_IN_SERVICE_DESK());
        }
        return io.atlassian.fugue.Either.right((Object)Unit.Unit());
    }

    private io.atlassian.fugue.Either<AnError, ServiceDesk> getServiceDesk(CheckedUser user, Project project) {
        return StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskForProject(user.forJIRA(), project));
    }

    private io.atlassian.fugue.Either<AnError, RequestDetailsResponse> getResponse(CheckedUser user, Issue issue, Portal portal, Project project, ServiceDesk serviceDesk) {
        return this.issueViewProvider.getIssueViewOrDefault(user, issue, project, portal).map(issueView -> this.requestDetailsResponseProviderHelper.toResponse(user, new CreateIssueResponse(issue), portal, project, serviceDesk, (CustomerRequestView)issueView));
    }
}

