/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal.providers.request;

import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.internal.api.feature.organization.member.CustomerOrganizationMemberService;
import com.atlassian.servicedesk.internal.api.onboarding.OnBoardingPropertiesService;
import com.atlassian.servicedesk.internal.api.requesttype.RequestTypeInternal;
import com.atlassian.servicedesk.internal.api.requesttype.RequestTypeInternalService;
import com.atlassian.servicedesk.internal.feature.customer.portal.CustomerUserPickerPermissionService;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.KbsResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.field.RequestTypeFieldInternalService;
import com.atlassian.servicedesk.internal.feature.customer.user.CustomerServiceValidator;
import com.atlassian.servicedesk.internal.feature.usermanagement.ServiceDeskUserPickerService;
import com.atlassian.servicedesk.internal.fields.Attachment;
import com.atlassian.servicedesk.internal.rest.responses.CustomerOrganisationResponse;
import com.atlassian.servicedesk.internal.rest.responses.RequestCreateResponse;
import com.atlassian.servicedesk.internal.rest.responses.UserFieldView;
import com.atlassian.servicedesk.internal.rest.responses.UserRequestTypeView;
import com.atlassian.servicedesk.internal.rest.responses.kb.KBResponse;
import com.atlassian.servicedesk.internal.soy.RenderOption;
import com.atlassian.servicedesk.internal.soy.RichTextRenderer;
import com.atlassian.servicedesk.internal.user.permission.ServiceDeskPermissions;
import com.atlassian.servicedesk.internal.utils.CustomerUrlUtil;
import com.atlassian.servicedesk.internal.web.CalendarControlSettings;
import com.atlassian.servicedesk.internal.web.LanguageSpecificCalendarResourceProvider;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestCreateResponseProviderHelper {
    private final CustomerUserPickerPermissionService customerUserPickerPermissionService;
    private final RequestTypeFieldInternalService requestTypeFieldInternalService;
    private final RequestTypeInternalService requestTypeInternalService;
    private final CustomerOrganizationMemberService organisationMemberService;
    private final RichTextRenderer richTextRenderer;
    private final LanguageSpecificCalendarResourceProvider languageSpecificCalendarResourceProvider;
    private final CustomerUrlUtil customerUrlUtil;
    private final CustomerServiceValidator customerServiceValidator;
    private final ServiceDeskPermissions serviceDeskPermissions;
    private final OnBoardingPropertiesService onBoardingPropertiesService;
    private final KbsResponseProvider kbsResponseProvider;
    private final ServiceDeskUserPickerService serviceDeskUserPickerService;

    @Autowired
    public RequestCreateResponseProviderHelper(CustomerUserPickerPermissionService customerUserPickerPermissionService, RequestTypeFieldInternalService requestTypeFieldInternalService, RequestTypeInternalService requestTypeInternalService, CustomerOrganizationMemberService organisationMemberService, RichTextRenderer richTextRenderer, LanguageSpecificCalendarResourceProvider languageSpecificCalendarResourceProvider, CustomerUrlUtil customerUrlUtil, CustomerServiceValidator customerServiceValidator, ServiceDeskPermissions serviceDeskPermissions, OnBoardingPropertiesService onBoardingPropertiesService, KbsResponseProvider kbsResponseProvider, ServiceDeskUserPickerService serviceDeskUserPickerService) {
        this.customerUserPickerPermissionService = customerUserPickerPermissionService;
        this.requestTypeFieldInternalService = requestTypeFieldInternalService;
        this.requestTypeInternalService = requestTypeInternalService;
        this.organisationMemberService = organisationMemberService;
        this.richTextRenderer = richTextRenderer;
        this.languageSpecificCalendarResourceProvider = languageSpecificCalendarResourceProvider;
        this.customerUrlUtil = customerUrlUtil;
        this.customerServiceValidator = customerServiceValidator;
        this.serviceDeskPermissions = serviceDeskPermissions;
        this.onBoardingPropertiesService = onBoardingPropertiesService;
        this.kbsResponseProvider = kbsResponseProvider;
        this.serviceDeskUserPickerService = serviceDeskUserPickerService;
    }

    RequestCreateResponse buildResponse(CheckedUser user, Portal portal, Project project, ServiceDesk serviceDesk, RequestType requestType, IssueType issueType) {
        List<UserFieldView> fieldViews = this.getFieldViews(user, project, requestType, issueType);
        RequestTypeInternal requestTypeInternal = this.requestTypeInternalService.toRequestTypeInternal(requestType);
        boolean attachmentRequiredField = this.attachmentRequiredField(fieldViews);
        boolean welcomeGuideItemAlreadyCompleted = this.welcomeGuideItemAlreadyCompleted(user);
        boolean hasGroups = requestType.getGroups().size() > 0;
        Collection<CustomerOrganisationResponse> userOrganisations = this.getUserOrganisations(user, project);
        boolean canBrowseUsers = this.canBrowseUsers(user, project, serviceDesk);
        boolean canRaiseOnBehalf = this.canRaiseOnBehalf(fieldViews);
        boolean canSignupCustomers = this.canSignupCustomers(canRaiseOnBehalf, user, project, serviceDesk);
        boolean canSubmitWithEmailAddress = this.canSubmitWithEmailAddress(user, project, serviceDesk);
        boolean canCreateAttachments = this.canCreateAttachments(user, project);
        return new RequestCreateResponse(requestTypeInternal.getKey(), requestTypeInternal.getId(), project.getId(), this.buildUserRequestTypeView(requestType, requestTypeInternal), fieldViews, userOrganisations, canBrowseUsers, this.getRequestCreateBaseUrl(portal, requestType), this.getCalendarControlSettings(), this.getKBResponse(user, project, requestType), canRaiseOnBehalf, canSignupCustomers, canCreateAttachments, attachmentRequiredField, welcomeGuideItemAlreadyCompleted, hasGroups, canSubmitWithEmailAddress);
    }

    private Collection<CustomerOrganisationResponse> getUserOrganisations(CheckedUser user, Project project) {
        return ((Collection)this.organisationMemberService.getUserOrganizationsInProjectAsCustomer(user, project).getOrElse(Collections.emptyList())).stream().map(org -> new CustomerOrganisationResponse(org.getId(), org.getName())).collect(Collectors.toList());
    }

    private List<UserFieldView> getFieldViews(CheckedUser user, Project project, RequestType requestType, IssueType issueType) {
        return this.requestTypeFieldInternalService.getUserFieldViewForRequestType(user, project, requestType, issueType);
    }

    private UserRequestTypeView buildUserRequestTypeView(RequestType requestType, RequestTypeInternal requestTypeInternal) {
        return new UserRequestTypeView(requestTypeInternal.getKey(), requestType.getName(), this.richTextRenderer.renderWiki(requestTypeInternal.getHelpText(), new RenderOption[0]), requestType.getName(), this.richTextRenderer.renderWiki(requestType.getDescription(), new RenderOption[0]), this.richTextRenderer.renderWiki(requestTypeInternal.getHelpText(), new RenderOption[0]), requestType.getIconId());
    }

    private boolean canBrowseUsers(CheckedUser user, Project project, ServiceDesk serviceDesk) {
        return this.customerUserPickerPermissionService.canSearchAllUsersOfProject(user, project, serviceDesk) || this.customerUserPickerPermissionService.canSearchAnyOrganizations(user, project);
    }

    private boolean canRaiseOnBehalf(List<UserFieldView> fieldViews) {
        return fieldViews.stream().anyMatch(fieldView -> "reporter".equals(fieldView.getFieldId()));
    }

    private boolean canSignupCustomers(boolean canRaiseOnBehalf, CheckedUser user, Project project, ServiceDesk serviceDesk) {
        return canRaiseOnBehalf && this.customerServiceValidator.isUserAllowedInviteCustomers(user, project, serviceDesk);
    }

    private boolean canSubmitWithEmailAddress(CheckedUser user, Project project, ServiceDesk serviceDesk) {
        return this.serviceDeskUserPickerService.canSubmitWithEmailAddress(user, project, serviceDesk);
    }

    private boolean canCreateAttachments(CheckedUser user, Project project) {
        return this.serviceDeskPermissions.canCreateAttachment((SDUser)user, project);
    }

    private boolean attachmentRequiredField(List<UserFieldView> fieldViews) {
        return fieldViews.stream().anyMatch(fieldView -> fieldView.isRequired() && Attachment.sdFieldType().equals(fieldView.getFieldType()));
    }

    private boolean welcomeGuideItemAlreadyCompleted(CheckedUser user) {
        return this.onBoardingPropertiesService.isChecklistItemCompleted(user.forJIRA(), "create-request");
    }

    private String getRequestCreateBaseUrl(Portal portal, RequestType requestType) {
        return this.customerUrlUtil.getPortalUrl(portal, "create/" + requestType.getId());
    }

    private CalendarControlSettings getCalendarControlSettings() {
        return this.languageSpecificCalendarResourceProvider.getParams();
    }

    private KBResponse getKBResponse(CheckedUser user, Project project, RequestType requestType) {
        return this.kbsResponseProvider.getResponse(user, project, (Option<RequestType>)Option.some((Object)requestType));
    }
}

