/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal.providers.organization;

import com.atlassian.fugue.Either;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.feature.organization.member.CustomerOrganizationMemberService;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.CustomerResponseProvider;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.atlassian.servicedesk.internal.rest.requests.ModelsRequest;
import com.atlassian.servicedesk.internal.rest.responses.CustomerOrganisationResponse;
import com.atlassian.servicedesk.internal.rest.responses.OrganisationsResponse;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerOrganisationResponseProvider
implements CustomerResponseProvider<OrganisationsResponse> {
    private final UserFactory userFactory;
    private final CustomerOrganizationMemberService organisationMemberService;
    private final FeatureManager featureManager;

    @Autowired
    public CustomerOrganisationResponseProvider(UserFactory userFactory, CustomerOrganizationMemberService organisationMemberService, FeatureManager featureManager) {
        this.userFactory = userFactory;
        this.organisationMemberService = organisationMemberService;
        this.featureManager = featureManager;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, OrganisationsResponse> getResponse(ModelsRequest ctx) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return io.atlassian.fugue.Either.right((Object)new OrganisationsResponse(Collections.emptyList()));
        }
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> io.atlassian.fugue.Either.right((Object)this.organisationMemberService.getMyOrganizations(user).getOrElse(Collections.emptyList()))).yield((user, organisations) -> this.mapResponse((Collection<CustomerOrganization>)organisations));
    }

    private OrganisationsResponse mapResponse(Collection<CustomerOrganization> organisations) {
        List<CustomerOrganisationResponse> organisationResponses = this.mapOrganisations(organisations);
        return new OrganisationsResponse(organisationResponses);
    }

    private List<CustomerOrganisationResponse> mapOrganisations(Collection<CustomerOrganization> organisations) {
        return organisations.stream().map(org -> new CustomerOrganisationResponse((CustomerOrganization)org)).collect(Collectors.toList());
    }
}

