/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal.providers.issue;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.api.customer.CustomerContextService;
import com.atlassian.servicedesk.api.customer.NoExceptionsCallable;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.api.project.ProjectUrls;
import com.atlassian.servicedesk.internal.api.project.ProjectUrlsProvider;
import com.atlassian.servicedesk.internal.api.requesttype.RequestTypeInternalService;
import com.atlassian.servicedesk.internal.api.user.permission.ServiceDeskLicenseAndPermissionService;
import com.atlassian.servicedesk.internal.customfields.origin.VpOrigin;
import com.atlassian.servicedesk.internal.customfields.origin.VpOriginManager;
import com.atlassian.servicedesk.internal.feature.customer.portal.InternalPortalService;
import com.atlassian.servicedesk.internal.feature.customer.portal.PortalInternal;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.IssueViewProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.issue.IssueViewProviderHelper;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.RequestTypeWithFields;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.field.RequestTypeFieldInternal;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.field.RequestTypeFieldInternalService;
import com.atlassian.servicedesk.internal.rest.responses.CustomerRequestView;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IssueViewProviderImpl
implements IssueViewProvider {
    private final IssueManager issueManager;
    private final ServiceDeskLicenseAndPermissionService serviceDeskPermissions;
    private final CommonErrors commonErrors;
    private final CustomerContextService customerContextService;
    private final ProjectUrlsProvider projectUrlsProvider;
    private final VpOriginManager vpOriginManager;
    private final RequestTypeInternalService requestTypeInternalService;
    private final IssueViewProviderHelper issueViewProviderHelper;
    private final RequestTypeFieldInternalService requestTypeFieldInternalService;
    private final InternalPortalService internalPortalService;

    @Autowired
    public IssueViewProviderImpl(IssueManager issueManager, ServiceDeskLicenseAndPermissionService serviceDeskPermissions, CommonErrors commonErrors, CustomerContextService customerContextService, ProjectUrlsProvider projectUrlsProvider, VpOriginManager vpOriginManager, RequestTypeInternalService requestTypeInternalService, IssueViewProviderHelper issueViewProviderHelper, RequestTypeFieldInternalService requestTypeFieldInternalService, InternalPortalService internalPortalService) {
        this.issueManager = issueManager;
        this.serviceDeskPermissions = serviceDeskPermissions;
        this.commonErrors = commonErrors;
        this.customerContextService = customerContextService;
        this.projectUrlsProvider = projectUrlsProvider;
        this.vpOriginManager = vpOriginManager;
        this.requestTypeInternalService = requestTypeInternalService;
        this.issueViewProviderHelper = issueViewProviderHelper;
        this.requestTypeFieldInternalService = requestTypeFieldInternalService;
        this.internalPortalService = internalPortalService;
    }

    @Override
    public Either<AnError, Issue> getRawIssue(CheckedUser user, String issueKey) {
        return Steps.begin(this.getIssue(issueKey)).then(issue -> this.checkPermissionToView(user, (Issue)issue)).yield((issue, unit) -> issue);
    }

    @Override
    public Either<AnError, CustomerRequestView> getIssueViewOrDefault(CheckedUser user, Issue issue, Project project, Portal portal) {
        return (Either)Option.option((Object)this.vpOriginManager.lookup(issue)).fold(() -> Either.left((Object)this.commonErrors.WRONG_REQUEST_TYPE()), origin -> this.getIssueViewFromOrigin(user, issue, project, portal, (VpOrigin)origin));
    }

    @Override
    public String getIssueLinkURL(CheckedUser user, Issue issue, Project project) {
        NoExceptionsCallable permissionCheck = () -> this.serviceDeskPermissions.canViewAgentView((SDUser)user, issue);
        if (((Boolean)this.customerContextService.runOutOfCustomerContext(permissionCheck)).booleanValue()) {
            ProjectUrls projectUrls = this.projectUrlsProvider.getUrls(project.getKey(), ProjectUrlsProvider.UrlMode.WITHOUT_CONTEXT);
            return projectUrls.issue(issue.getKey()).toASCIIString();
        }
        return "/browse/" + issue.getKey();
    }

    @Override
    public Either<AnError, String> getRequestViewUrl(CheckedUser user, String issueKey) {
        return Steps.begin(this.getIssue(issueKey)).then(issue -> this.getPortalByProject(issue.getProjectObject())).then((issue, portal) -> Either.right((Object)String.format("%d/%s", portal.getId(), issue.getKey()))).yield((issue, portal, url) -> url);
    }

    private Either<AnError, MutableIssue> getIssue(String issueKey) {
        return Option.option((Object)this.issueManager.getIssueObject(issueKey)).toRight(() -> this.commonErrors.ISSUE_NOT_FOUND());
    }

    private Either<AnError, Unit> checkPermissionToView(CheckedUser user, Issue issue) {
        if (!this.serviceDeskPermissions.canViewRequestInPortal((SDUser)user, issue)) {
            return Either.left((Object)this.commonErrors.NO_PERMISSION_TO_VIEW_REQUEST());
        }
        return Either.right((Object)Unit.Unit());
    }

    private Either<AnError, PortalInternal> getPortalByProject(Project project) {
        Either<AnError, PortalInternal> portalInternalEither = this.internalPortalService.getPortalByProjectWithoutPermission(project);
        return portalInternalEither.leftMap(err -> this.commonErrors.PROJECT_NOT_IN_SERVICE_DESK());
    }

    private Either<AnError, CustomerRequestView> getIssueViewFromOrigin(CheckedUser user, Issue issue, Project project, Portal portal, VpOrigin origin) {
        return (Either)this.requestTypeInternalService.getRequestTypeByKey(user, origin.getRequestTypeKey(), project, portal).fold(err -> Either.right((Object)this.issueViewProviderHelper.getDefaultIssueView(user, issue, portal, origin)), requestType -> this.getIssueViewFromRequestType(user, issue, project, portal, (RequestType)requestType));
    }

    private Either<AnError, CustomerRequestView> getIssueViewFromRequestType(CheckedUser user, Issue issue, Project project, Portal portal, RequestType requestType) {
        return Steps.begin(this.requestTypeFieldInternalService.getRequestTypeFields(user, project, requestType)).then(requestTypeFields -> this.getRequestTypeWithFields(requestType, (List<RequestTypeFieldInternal>)requestTypeFields)).then((requestTypeFields, requestTypeWithFields) -> this.getIssueView(user, issue, portal, (RequestTypeWithFields)requestTypeWithFields)).yield((requestTypeFields, requestTypeWithFields, issueView) -> issueView);
    }

    private Either<AnError, RequestTypeWithFields> getRequestTypeWithFields(RequestType requestType, List<RequestTypeFieldInternal> requestTypeFields) {
        Option<RequestTypeWithFields> requestTypeWithFieldsOption = RequestTypeWithFields.build(requestType, requestTypeFields);
        return requestTypeWithFieldsOption.toRight(() -> this.commonErrors.REQUEST_TYPE_INTEGRITY_ERROR());
    }

    private Either<AnError, CustomerRequestView> getIssueView(CheckedUser user, Issue issue, Portal portal, RequestTypeWithFields requestTypeWithFields) {
        Option<CustomerRequestView> customerRequestViewOption = this.issueViewProviderHelper.getIssueView(user, portal, requestTypeWithFields, issue);
        return customerRequestViewOption.toRight(() -> this.commonErrors.REQUEST_TYPE_INTEGRITY_ERROR());
    }
}

