/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal.providers.issue;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.IssueKey;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.internal.api.feature.reqparticipants.organization.CustomerOrganizationParticipantService;
import com.atlassian.servicedesk.internal.api.request.activitystream.items.ActivityItem;
import com.atlassian.servicedesk.internal.api.request.requesttype.status.RequestStatusMapper;
import com.atlassian.servicedesk.internal.api.user.permission.ServiceDeskLicenseAndPermissionService;
import com.atlassian.servicedesk.internal.feature.customer.portal.InternalPortalService;
import com.atlassian.servicedesk.internal.feature.customer.request.activitystream.RequestActivityManager;
import com.atlassian.servicedesk.internal.feature.customer.request.activitystream.providers.StatusAndResolutionActivityProvider;
import com.atlassian.servicedesk.internal.feature.customer.request.activitystream.responses.ActivityItemResponse;
import com.atlassian.servicedesk.internal.feature.customer.request.activitystream.responses.ActivityResponseManager;
import com.atlassian.servicedesk.internal.feature.customer.request.avatar.SDAgentAvatarManager;
import com.atlassian.servicedesk.internal.feature.customer.request.fields.FieldAndValue;
import com.atlassian.servicedesk.internal.feature.jira.issue.IssueHelper;
import com.atlassian.servicedesk.internal.feature.reqparticipants.field.RequestParticipantsInternalService;
import com.atlassian.servicedesk.internal.rest.responses.CustomerOrganisationResponse;
import com.atlassian.servicedesk.internal.rest.responses.CustomerRequestView;
import com.atlassian.servicedesk.internal.rest.responses.SimpleUserResponse;
import com.atlassian.servicedesk.internal.utils.DateFormatter;
import com.atlassian.servicedesk.internal.utils.ServiceDeskDateFormatterFactory;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IssueViewProviderHelperCommon {
    private final ServiceDeskDateFormatterFactory serviceDeskDateFormatterFactory;
    private final RequestActivityManager requestActivityManager;
    private final ActivityResponseManager activityResponseManager;
    private final StatusAndResolutionActivityProvider statusAndResolutionActivityProvider;
    private final ServiceDeskLicenseAndPermissionService serviceDeskLicenseAndPermissionService;
    private final RequestParticipantsInternalService requestParticipantInternalService;
    private final SDAgentAvatarManager agentAvatarManager;
    private final CustomerOrganizationParticipantService organisationParticipantService;
    private final IssueHelper issueHelper;
    private final InternalPortalService internalPortalService;

    @Autowired
    public IssueViewProviderHelperCommon(ServiceDeskDateFormatterFactory serviceDeskDateFormatterFactory, RequestActivityManager requestActivityManager, ActivityResponseManager activityResponseManager, StatusAndResolutionActivityProvider statusAndResolutionActivityProvider, ServiceDeskLicenseAndPermissionService serviceDeskLicenseAndPermissionService, RequestParticipantsInternalService requestParticipantInternalService, SDAgentAvatarManager agentAvatarManager, CustomerOrganizationParticipantService organisationParticipantService, IssueHelper issueHelper, InternalPortalService internalPortalService) {
        this.serviceDeskDateFormatterFactory = serviceDeskDateFormatterFactory;
        this.requestActivityManager = requestActivityManager;
        this.activityResponseManager = activityResponseManager;
        this.statusAndResolutionActivityProvider = statusAndResolutionActivityProvider;
        this.serviceDeskLicenseAndPermissionService = serviceDeskLicenseAndPermissionService;
        this.requestParticipantInternalService = requestParticipantInternalService;
        this.agentAvatarManager = agentAvatarManager;
        this.organisationParticipantService = organisationParticipantService;
        this.issueHelper = issueHelper;
        this.internalPortalService = internalPortalService;
    }

    CustomerRequestView getIssueViewCommon(CheckedUser user, Issue issue, Portal portal, int requestTypeId, String requestTypeKey, String requestTypeName, RequestStatusMapper statusMapper, List<FieldAndValue> fields, long requestIcon) {
        DateFormatter dateFormatter = this.serviceDeskDateFormatterFactory.forUser(user);
        String resolution = (String)Option.option((Object)issue.getResolution()).map(IssueConstant::getNameTranslation).getOrNull();
        Status statusObj = issue.getStatus();
        String status = statusMapper.translateToCustomerStatus(statusObj);
        List<ActivityItem> activities = this.requestActivityManager.getActivityItems(user.forJIRA(), issue);
        List<ActivityItemResponse> activityResponses = this.activityResponseManager.getResponses(user.forJIRA(), activities, dateFormatter);
        boolean isNew = this.statusAndResolutionActivityProvider.isIssueNew(user.forJIRA(), issue);
        boolean canBrowse = this.serviceDeskLicenseAndPermissionService.canViewIssue((SDUser)user, issue);
        boolean canAttach = this.serviceDeskLicenseAndPermissionService.canCreateAttachment((SDUser)user, issue);
        List<SimpleUserResponse> participantsResponses = this.getCheckedParticipantResponses(user, issue);
        List<CustomerOrganisationResponse> organisations = this.getOrganisationsResponse(user, issue);
        Option reporterResponse = this.issueHelper.getReporterOpt(issue).map(this::toSimpleUserResponse);
        Option assigneeResponse = this.issueHelper.getAssigneeOpt(issue).map(this::toSimpleUserResponse);
        Option creatorName = Option.option((Object)issue.getCreator()).map(ApplicationUser::getName);
        String portalKey = this.internalPortalService.toPortalInternal(portal).getKey();
        long issueNumber = IssueKey.from((String)issue.getKey()).getIssueNumber();
        String issueCreatedTime = dateFormatter.getTimeLong(issue.getCreated());
        String issueCreatedTimeRelative = dateFormatter.getTimeRelative(issue.getCreated());
        return new CustomerRequestView(issue.getId(), issue.getKey(), (String)creatorName.getOrElse((Object)""), (SimpleUserResponse)reporterResponse.getOrNull(), (SimpleUserResponse)assigneeResponse.getOrNull(), participantsResponses, organisations, issueNumber, portalKey, requestTypeKey, requestTypeName, requestTypeId, issue.getSummary(), isNew, status, resolution, issueCreatedTime, issueCreatedTimeRelative, fields, activityResponses, requestIcon, canBrowse, canAttach, issue.getStatus().getStatusCategory().getKey());
    }

    private List<SimpleUserResponse> getCheckedParticipantResponses(CheckedUser user, Issue issue) {
        return (List)this.requestParticipantInternalService.getValidParticipants(user, issue).map(this::toSimpleUserResponses).getOrElse(Collections.emptyList());
    }

    private List<CustomerOrganisationResponse> getOrganisationsResponse(CheckedUser user, Issue issue) {
        return (List)this.organisationParticipantService.getOrganizationsForIssue(user, issue).map(this::toOrganisationsResponses).getOrElse(Collections.emptyList());
    }

    private List<CustomerOrganisationResponse> toOrganisationsResponses(Collection<CustomerOrganization> organisations) {
        return organisations.stream().map(org -> new CustomerOrganisationResponse(org.getId(), org.getName())).collect(Collectors.toList());
    }

    private List<SimpleUserResponse> toSimpleUserResponses(List<CheckedUser> responseUsers) {
        return responseUsers.stream().map(this::toSimpleUserResponse).collect(Collectors.toList());
    }

    private SimpleUserResponse toSimpleUserResponse(CheckedUser responseUser) {
        String avatarUrl = this.agentAvatarManager.processAvatarRequest(responseUser.forJIRA(), Avatar.Size.NORMAL);
        return new SimpleUserResponse(responseUser, avatarUrl);
    }
}

