/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal.providers.issue;

import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.request.requesttype.status.RequestStatusMapper;
import com.atlassian.servicedesk.internal.api.request.requesttype.status.RequestStatusService;
import com.atlassian.servicedesk.internal.api.requesttype.RequestTypeInternal;
import com.atlassian.servicedesk.internal.api.requesttype.RequestTypeInternalService;
import com.atlassian.servicedesk.internal.customfields.origin.VpOrigin;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.issue.IssueViewProviderHelperCommon;
import com.atlassian.servicedesk.internal.feature.customer.request.fields.FieldAndValue;
import com.atlassian.servicedesk.internal.feature.customer.request.fields.FieldValue;
import com.atlassian.servicedesk.internal.feature.customer.request.fields.HtmlValue;
import com.atlassian.servicedesk.internal.feature.customer.request.fields.TextValue;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.RequestTypeWithFields;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.field.RequestTypeFieldInternal;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.icon.RequestTypeIconDefinition;
import com.atlassian.servicedesk.internal.fields.ServiceDeskJIRAFieldService;
import com.atlassian.servicedesk.internal.rest.responses.CustomerRequestView;
import com.atlassian.servicedesk.internal.utils.DateFormatter;
import com.atlassian.servicedesk.internal.utils.ServiceDeskDateFormatterFactory;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Pair;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IssueViewProviderHelper {
    private final ServiceDeskDateFormatterFactory serviceDeskDateFormatterFactory;
    private final RequestStatusService requestStatusService;
    private final AvatarManager avatarManager;
    private final ServiceDeskJIRAFieldService serviceDeskJIRAFieldService;
    private final RequestTypeInternalService requestTypeInternalService;
    private final IssueViewProviderHelperCommon issueViewProviderHelperCommon;

    @Autowired
    public IssueViewProviderHelper(ServiceDeskDateFormatterFactory serviceDeskDateFormatterFactory, RequestStatusService requestStatusService, AvatarManager avatarManager, ServiceDeskJIRAFieldService serviceDeskJIRAFieldService, RequestTypeInternalService requestTypeInternalService, IssueViewProviderHelperCommon issueViewProviderHelperCommon) {
        this.serviceDeskDateFormatterFactory = serviceDeskDateFormatterFactory;
        this.requestStatusService = requestStatusService;
        this.avatarManager = avatarManager;
        this.serviceDeskJIRAFieldService = serviceDeskJIRAFieldService;
        this.requestTypeInternalService = requestTypeInternalService;
        this.issueViewProviderHelperCommon = issueViewProviderHelperCommon;
    }

    CustomerRequestView getDefaultIssueView(CheckedUser user, Issue issue, Portal portal, VpOrigin origin) {
        RequestStatusMapper statusMapper = this.requestStatusService.getStatusMapperForMissingRequestType();
        long defaultIconId = this.avatarManager.getDefaultAvatarId(RequestTypeIconDefinition.ICON_TYPE);
        return this.issueViewProviderHelperCommon.getIssueViewCommon(user, issue, portal, -1, origin.getRequestTypeKey(), "", statusMapper, Collections.emptyList(), defaultIconId);
    }

    Option<CustomerRequestView> getIssueView(CheckedUser user, Portal portal, RequestTypeWithFields requestTypeWithFields, Issue rawIssue) {
        RequestType requestType = requestTypeWithFields.getRequestType();
        RequestTypeInternal requestTypeInternal = this.requestTypeInternalService.toRequestTypeInternal(requestType);
        if (requestType == null || requestTypeInternal == null) {
            return Option.none();
        }
        DateFormatter dateFormatter = this.serviceDeskDateFormatterFactory.forSystem();
        RequestStatusMapper statusMapper = this.requestStatusService.getStatusMapper(requestType);
        List<FieldAndValue> fieldsExceptSummary = requestTypeWithFields.getFields().stream().map(field -> this.getFieldValue(user, (RequestTypeFieldInternal)field, dateFormatter, rawIssue)).filter(this::canDisplayField).map(this::getFieldAndValue).collect(Collectors.toList());
        return Option.some((Object)this.issueViewProviderHelperCommon.getIssueViewCommon(user, rawIssue, portal, requestType.getId(), requestTypeInternal.getKey(), requestType.getName(), statusMapper, fieldsExceptSummary, requestType.getIconId()));
    }

    Pair<RequestTypeFieldInternal, FieldValue> getFieldValue(CheckedUser user, RequestTypeFieldInternal field, DateFormatter fmt, Issue rawIssue) {
        Option<ServiceDeskJIRAFieldService.FieldValueRenderer> fieldValueRenderer = this.serviceDeskJIRAFieldService.getFieldValueRenderer(field.getFieldId(), fmt, user, rawIssue);
        Option valueOption = (Option)fieldValueRenderer.map(f -> f.apply(rawIssue)).fold(() -> Option.none(), v -> v);
        FieldValue value = (FieldValue)valueOption.getOrElse((Object)new TextValue(""));
        return new Pair((Object)field, (Object)value);
    }

    protected boolean canDisplayField(Pair<RequestTypeFieldInternal, FieldValue> pair) {
        RequestTypeFieldInternal field = (RequestTypeFieldInternal)pair.left();
        FieldValue value = (FieldValue)pair.right();
        String displayedValue = null;
        if (value instanceof TextValue) {
            displayedValue = ((TextValue)value).getText();
        } else if (value instanceof HtmlValue) {
            displayedValue = ((HtmlValue)value).getHtml();
        }
        return field.isDisplayed() && !"summary".equals(field.getFieldId()) && !"attachment".equals(field.getFieldId()) && StringUtils.isNotBlank((String)displayedValue);
    }

    private FieldAndValue getFieldAndValue(Pair<RequestTypeFieldInternal, FieldValue> pair) {
        RequestTypeFieldInternal field = (RequestTypeFieldInternal)pair.left();
        FieldValue value = (FieldValue)pair.right();
        return new FieldAndValue(field.getFieldId(), field.getLabel(), value);
    }
}

