/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal.providers;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.api.project.InternalServiceDeskProjectManager;
import com.atlassian.servicedesk.internal.feature.customer.portal.PortalInternal;
import com.atlassian.servicedesk.internal.feature.customer.portal.PortalInternalManager;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.CustomerResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.user.ServiceDeskUserManager;
import com.atlassian.servicedesk.internal.feature.customer.user.invite.InviteService;
import com.atlassian.servicedesk.internal.rest.requests.ModelsRequest;
import com.atlassian.servicedesk.internal.rest.requests.ModelsRequestOptions;
import com.atlassian.servicedesk.internal.rest.responses.VisitPortalResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VisitPortalResponseProvider
implements CustomerResponseProvider<VisitPortalResponse> {
    private final PortalInternalManager portalInternalManager;
    private final InternalServiceDeskProjectManager internalServiceDeskProjectManager;
    private final UserFactory userFactory;
    private final ServiceDeskUserManager serviceDeskUserManager;
    private final InviteService inviteService;
    private final CommonErrors commonErrors;

    @Autowired
    public VisitPortalResponseProvider(PortalInternalManager portalInternalManager, InternalServiceDeskProjectManager internalServiceDeskProjectManager, UserFactory userFactory, ServiceDeskUserManager serviceDeskUserManager, InviteService inviteService, CommonErrors commonErrors) {
        this.portalInternalManager = portalInternalManager;
        this.internalServiceDeskProjectManager = internalServiceDeskProjectManager;
        this.userFactory = userFactory;
        this.serviceDeskUserManager = serviceDeskUserManager;
        this.inviteService = inviteService;
        this.commonErrors = commonErrors;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, VisitPortalResponse> getResponse(ModelsRequest ctx) {
        ModelsRequestOptions ctxOptions = ctx.getOptions();
        return Steps.begin(this.getPortalInternal(ctxOptions.getPortalId())).then(portalInternal -> this.getProject(portalInternal.getProjectId())).then((portalInternal, project) -> this.getCustomer(ctxOptions)).then((portalInternal, project, customer) -> this.validateVisitPortal((CheckedUser)customer, (Project)project, ctxOptions.getVisitPortal().getToken())).yield((portalInternal, project, customer, result) -> result);
    }

    private io.atlassian.fugue.Either<AnError, VisitPortalResponse> validateVisitPortal(CheckedUser customer, Project project, String token) {
        return this.inviteService.validateInviteToken(customer, project, token).flatMap(success -> this.buildResponse(customer));
    }

    private io.atlassian.fugue.Either<AnError, VisitPortalResponse> buildResponse(CheckedUser customer) {
        boolean loggedIn = this.serviceDeskUserManager.hasLoggedInBefore(customer);
        if (loggedIn) {
            this.inviteService.clearInviteTokens(customer);
            return io.atlassian.fugue.Either.left((Object)this.commonErrors.INVALID_TOKEN());
        }
        return io.atlassian.fugue.Either.right((Object)new VisitPortalResponse(false));
    }

    private io.atlassian.fugue.Either<AnError, CheckedUser> getCustomer(ModelsRequestOptions ctxOptions) {
        return StepsConverters.newerEither((Either)this.userFactory.wrapUsername(ctxOptions.getVisitPortal().getUsername())).leftMap(err -> this.commonErrors.INVALID_TOKEN());
    }

    private io.atlassian.fugue.Either<AnError, PortalInternal> getPortalInternal(long portalId) {
        return this.portalInternalManager.getPortalById(portalId);
    }

    private io.atlassian.fugue.Either<AnError, Project> getProject(long projectId) {
        return this.internalServiceDeskProjectManager.getProject(Long.valueOf(projectId));
    }
}

