/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal.providers;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.timezone.TimeZoneInfo;
import com.atlassian.jira.timezone.TimeZoneService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.CustomerResponseProvider;
import com.atlassian.servicedesk.internal.rest.requests.ModelsRequest;
import com.atlassian.servicedesk.internal.rest.responses.TimeZoneResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TimezonesResponseProvider
implements CustomerResponseProvider<List<TimeZoneResponse>> {
    private final TimeZoneService timeZoneService;
    private final UserFactory userFactory;

    @Autowired
    public TimezonesResponseProvider(TimeZoneService timeZoneService, UserFactory userFactory) {
        this.timeZoneService = timeZoneService;
        this.userFactory = userFactory;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, List<TimeZoneResponse>> getResponse(ModelsRequest ctx) {
        return StepsConverters.newerEither((Either)this.userFactory.getCheckedUser()).map(user -> this.getTimeZones((JiraServiceContext)new JiraServiceContextImpl(user.forJIRA())));
    }

    public TimeZoneResponse getDefaultJiraTimezone(CheckedUser user) {
        return this.getDefaultJiraTimezone((JiraServiceContext)new JiraServiceContextImpl(user.forJIRA()));
    }

    private List<TimeZoneResponse> getTimeZones(JiraServiceContext serviceContext) {
        ArrayList<TimeZoneResponse> timeZoneInfos = new ArrayList<TimeZoneResponse>();
        timeZoneInfos.add(this.getDefaultJiraTimezone(serviceContext));
        timeZoneInfos.addAll(this.getJiraTimeZones(serviceContext));
        return timeZoneInfos;
    }

    private List<TimeZoneResponse> getJiraTimeZones(JiraServiceContext context) {
        return this.timeZoneService.getTimeZoneInfos(context).stream().map(this::toTimeZoneResponse).collect(Collectors.toList());
    }

    private TimeZoneResponse getDefaultJiraTimezone(JiraServiceContext serviceContext) {
        TimeZoneInfo info = this.timeZoneService.getDefaultTimeZoneInfo(serviceContext);
        return new TimeZoneResponse("JIRA", "JIRA", info.getCity(), info.getGMTOffset());
    }

    private TimeZoneResponse toTimeZoneResponse(TimeZoneInfo info) {
        return new TimeZoneResponse(info.getTimeZoneId(), info.getRegionKey(), info.getCity(), info.getGMTOffset());
    }
}

