/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal.providers;

import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.internal.api.project.InternalServiceDeskProjectManager;
import com.atlassian.servicedesk.internal.feature.customer.portal.PortalInternalManager;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.CustomerResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.user.signup.ServiceDeskSignupValidator;
import com.atlassian.servicedesk.internal.feature.servicedesk.ServiceDeskInternalManager;
import com.atlassian.servicedesk.internal.rest.requests.ModelsRequest;
import com.atlassian.servicedesk.internal.rest.responses.SignUpResponse;
import io.atlassian.fugue.Either;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SignupResponseProvider
implements CustomerResponseProvider<SignUpResponse> {
    private final ServiceDeskSignupValidator serviceDeskSignupValidator;
    private final PortalInternalManager portalInternalManager;
    private final InternalServiceDeskProjectManager internalServiceDeskProjectManager;
    private final ServiceDeskInternalManager serviceDeskInternalManager;

    @Autowired
    public SignupResponseProvider(ServiceDeskSignupValidator serviceDeskSignupValidator, PortalInternalManager portalInternalManager, InternalServiceDeskProjectManager internalServiceDeskProjectManager, ServiceDeskInternalManager serviceDeskInternalManager) {
        this.serviceDeskSignupValidator = serviceDeskSignupValidator;
        this.portalInternalManager = portalInternalManager;
        this.internalServiceDeskProjectManager = internalServiceDeskProjectManager;
        this.serviceDeskInternalManager = serviceDeskInternalManager;
    }

    @Override
    public Either<AnError, SignUpResponse> getResponse(ModelsRequest ctx) {
        SignUpResponse response = new SignUpResponse(this.serviceDeskSignupValidator.isCaptchaSupported());
        if (this.isSignUpViaHelpCenter(ctx)) {
            return Either.right((Object)response);
        }
        return Steps.begin(this.portalInternalManager.getPortalById(ctx.getOptions().getPortalId())).then(portal -> this.internalServiceDeskProjectManager.getProject(Long.valueOf(portal.getProjectId()))).then((portal, project) -> this.serviceDeskInternalManager.getServiceDesk((Project)project, false)).yield((portal, project, serviceDesk) -> response);
    }

    private boolean isSignUpViaHelpCenter(ModelsRequest ctx) {
        return ctx.getOptions().getPortalId() < 0L;
    }
}

