/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal.providers;

import com.atlassian.fugue.Either;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.feature.customer.helpcenter.HelpCenterBrandingService;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.CustomerResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.SharedPortalKbsResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.response.SharedPortalResponse;
import com.atlassian.servicedesk.internal.rest.requests.ModelsRequest;
import com.atlassian.servicedesk.internal.soy.RenderOption;
import com.atlassian.servicedesk.internal.soy.RichTextRenderer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SharedPortalResponseProvider
implements CustomerResponseProvider<SharedPortalResponse> {
    private final UserFactory userFactory;
    private final SharedPortalKbsResponseProvider kbsResponseProvider;
    private final HelpCenterBrandingService helpCenterBrandingService;
    private final RichTextRenderer richTextRenderer;

    @Autowired
    public SharedPortalResponseProvider(UserFactory userFactory, SharedPortalKbsResponseProvider kbsResponseProvider, HelpCenterBrandingService helpCenterBrandingService, RichTextRenderer richTextRenderer) {
        this.userFactory = userFactory;
        this.kbsResponseProvider = kbsResponseProvider;
        this.helpCenterBrandingService = helpCenterBrandingService;
        this.richTextRenderer = richTextRenderer;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, SharedPortalResponse> getResponse(ModelsRequest ctx) {
        return StepsConverters.newerEither((Either)this.userFactory.getCheckedUser()).map(this::toSharedPortalResponse);
    }

    public SharedPortalResponse toSharedPortalResponse(CheckedUser user) {
        return new SharedPortalResponse(this.helpCenterBrandingService.getSharedPortalName(), this.richTextRenderer.renderWiki(user.i18NHelper().getText("sd.customerview.sharedportal.default.introduction.text"), new RenderOption[0]), this.kbsResponseProvider.getResponse(user));
    }
}

