/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal.providers;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.application.confluence.ConfluenceApplicationType;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.feature.applink.ServiceDeskAppLinkService;
import com.atlassian.servicedesk.internal.api.feature.servicedesk.InternalServiceDeskService;
import com.atlassian.servicedesk.internal.api.knowledgebase.ConfluenceKnowledgeBaseInternalService;
import com.atlassian.servicedesk.internal.feature.customer.portal.InternalPortalService;
import com.atlassian.servicedesk.internal.rest.responses.kb.SharedPortalKBResponse;
import io.atlassian.fugue.Either;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SharedPortalKbsResponseProvider {
    private final ConfluenceKnowledgeBaseInternalService knowledgeBaseService;
    private final ServiceDeskAppLinkService serviceDeskAppLinkService;
    private final InternalPortalService internalPortalService;
    private final InternalServiceDeskService internalServiceDeskService;

    @Autowired
    public SharedPortalKbsResponseProvider(ConfluenceKnowledgeBaseInternalService knowledgeBaseService, ServiceDeskAppLinkService serviceDeskAppLinkService, InternalPortalService internalPortalService, InternalServiceDeskService internalServiceDeskService) {
        this.knowledgeBaseService = knowledgeBaseService;
        this.serviceDeskAppLinkService = serviceDeskAppLinkService;
        this.internalPortalService = internalPortalService;
        this.internalServiceDeskService = internalServiceDeskService;
    }

    public SharedPortalKBResponse getResponse(CheckedUser user) {
        List<Portal> visiblePortals = this.internalPortalService.getCustomerVisiblePortals(user);
        List serviceDesks = this.internalServiceDeskService.getServiceDeskByVisiblePortalAsCustomer(user, visiblePortals);
        return (SharedPortalKBResponse)this.getApplicationLink(serviceDesks).fold(error -> new SharedPortalKBResponse(false, null), appLink -> new SharedPortalKBResponse(true, appLink.getDisplayUrl().toString()));
    }

    private Either<AnError, ApplicationLink> getApplicationLink(List<ServiceDesk> serviceDesks) {
        return Steps.begin((Either)this.serviceDeskAppLinkService.getPrimaryApplicationLinkForType(ConfluenceApplicationType.class)).then(primaryAppLink -> this.knowledgeBaseService.getPrimaryOrFirstAssociatedAppLink(serviceDesks, primaryAppLink.getId().get())).then((primaryAppLink, appLink) -> this.serviceDeskAppLinkService.getApplicationLink(appLink.getApplicationId())).yield((primaryAppLink, appLink, sharedPortalAppLink) -> sharedPortalAppLink);
    }
}

