/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal.providers;

import com.atlassian.fugue.Either;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.request.CustomerRequestQuery;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.requesttype.RequestTypeInternalService;
import com.atlassian.servicedesk.internal.errors.ServiceDeskHttpError;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.CustomerResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.response.RecentRequestTypeResponse;
import com.atlassian.servicedesk.internal.feature.customer.request.MultiPortalSearchResult;
import com.atlassian.servicedesk.internal.feature.customer.request.list.PortalRequestTypeFilter;
import com.atlassian.servicedesk.internal.feature.customer.request.list.RequestListFilter;
import com.atlassian.servicedesk.internal.feature.customer.request.list.RequestListProvider;
import com.atlassian.servicedesk.internal.feature.customer.request.list.TextSearchFilter;
import com.atlassian.servicedesk.internal.rest.requests.ModelsRequest;
import com.atlassian.servicedesk.internal.utils.Convert;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RecentRequestTypeResponseProvider
implements CustomerResponseProvider<List<RecentRequestTypeResponse>> {
    private static final Integer MAX_RECENT_REQUEST_TYPES = 4;
    private final RequestListProvider requestListProvider;
    private final UserFactory userFactory;
    private final RequestTypeInternalService requestTypeInternalService;
    private final ErrorResultHelper errorResultHelper;

    @Autowired
    public RecentRequestTypeResponseProvider(RequestListProvider requestListProvider, UserFactory userFactory, RequestTypeInternalService requestTypeInternalService, ErrorResultHelper errorResultHelper) {
        this.requestListProvider = requestListProvider;
        this.userFactory = userFactory;
        this.requestTypeInternalService = requestTypeInternalService;
        this.errorResultHelper = errorResultHelper;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, List<RecentRequestTypeResponse>> getResponse(ModelsRequest ctx) {
        io.atlassian.fugue.Either checkedUserEither = StepsConverters.newerEither((Either)this.userFactory.getCheckedUser());
        if (checkedUserEither.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)checkedUserEither.left().get());
        }
        CheckedUser user = (CheckedUser)checkedUserEither.right().get();
        RequestListFilter filter2 = new RequestListFilter((Option<TextSearchFilter>)Option.none(), CustomerRequestQuery.REQUEST_STATUS.ALL_REQUESTS, CustomerRequestQuery.REQUEST_OWNERSHIP.OWNED_REQUESTS, new PortalRequestTypeFilter(), (Option<Integer>)Option.none());
        MultiPortalSearchResult multiPortalSearchResult = this.requestListProvider.getCustomerRequests(user, filter2, PagerFilter.newPageAlignedFilter((int)0, (int)10));
        ArrayList requestTypeResponses = Lists.newArrayList();
        for (MultiPortalSearchResult.PortalRequestListItemView item : multiPortalSearchResult.getResultList()) {
            RequestType requestType;
            Portal portal = item.getPortal();
            if (item.getRequestType().isEmpty() || this.requestTypeHasNoGroup(requestType = (RequestType)item.getRequestType().get())) continue;
            if (!this.isInResponse(requestTypeResponses, portal.getId(), requestType.getId())) {
                requestTypeResponses.add(new RecentRequestTypeResponse(this.requestTypeInternalService.toRequestTypeInternal(requestType), portal));
            }
            if (requestTypeResponses.size() < MAX_RECENT_REQUEST_TYPES) continue;
            break;
        }
        return io.atlassian.fugue.Either.right((Object)Lists.newArrayList((Iterable)requestTypeResponses));
    }

    private boolean isInResponse(Iterable<RecentRequestTypeResponse> recentRequestTypeResponses, int portalId, Integer requestTypeId) {
        return Iterators.any(recentRequestTypeResponses.iterator(), recentRequestTypeResponse -> recentRequestTypeResponse.getPortalId() == (long)portalId && recentRequestTypeResponse.getId().equals(requestTypeId));
    }

    private boolean requestTypeHasNoGroup(RequestType requestType) {
        return requestType.getGroups().size() == 0;
    }

    AnError toAnError(ServiceDeskHttpError error) {
        return Convert.toAnError(error, this.errorResultHelper);
    }
}

