/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal.providers;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.request.CustomerRequest;
import com.atlassian.servicedesk.api.request.CustomerRequestQuery;
import com.atlassian.servicedesk.api.request.ServiceDeskCustomerRequestService;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.requesttype.RequestTypeQuery;
import com.atlassian.servicedesk.api.requesttype.RequestTypeService;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.feature.servicedesk.InternalServiceDeskService;
import com.atlassian.servicedesk.internal.api.webfragments.PortalPage;
import com.atlassian.servicedesk.internal.customer.PortalContext;
import com.atlassian.servicedesk.internal.customer.portal.PortalWebFragmentsService;
import com.atlassian.servicedesk.internal.feature.customer.portal.PortalInternal;
import com.atlassian.servicedesk.internal.feature.customer.portal.PortalInternalManager;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.CustomerResponseProvider;
import com.atlassian.servicedesk.internal.rest.requests.ModelsRequest;
import com.atlassian.servicedesk.internal.rest.responses.PortalWebFragmentsResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PortalWebFragmentsResponseProvider
implements CustomerResponseProvider<PortalWebFragmentsResponse> {
    private final UserFactory userFactory;
    private final InternalServiceDeskService internalServiceDeskService;
    private final PortalInternalManager portalInternalManager;
    private final IssueManager issueManager;
    private final ServiceDeskCustomerRequestService serviceDeskCustomerRequestService;
    private final RequestTypeService requestTypeService;
    private final PortalWebFragmentsService portalWebFragmentsService;

    @Autowired
    public PortalWebFragmentsResponseProvider(UserFactory userFactory, InternalServiceDeskService internalServiceDeskService, PortalInternalManager portalInternalManager, IssueManager issueManager, ServiceDeskCustomerRequestService serviceDeskCustomerRequestService, RequestTypeService requestTypeService, PortalWebFragmentsService portalWebFragmentsService) {
        this.userFactory = userFactory;
        this.internalServiceDeskService = internalServiceDeskService;
        this.portalInternalManager = portalInternalManager;
        this.issueManager = issueManager;
        this.serviceDeskCustomerRequestService = serviceDeskCustomerRequestService;
        this.requestTypeService = requestTypeService;
        this.portalWebFragmentsService = portalWebFragmentsService;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, PortalWebFragmentsResponse> getResponse(ModelsRequest ctx) {
        PortalPage portalPage = ctx.getOptions().getPortalWebFragments().getPortalPage();
        ApplicationUser applicationUser = this.getApplicationUser();
        PortalInternal portal = this.getPortal(ctx.getOptions().getPortal().getId());
        ServiceDesk serviceDesk = this.getServiceDesk(portal);
        Issue issue = this.getIssue(ctx.getOptions().getReqDetails().getKey());
        CustomerRequest customerRequest = this.getCustomerRequest(issue);
        RequestType requestType = this.hasRequestTypeId(ctx) != false ? this.getRequestTypeFromContext(ctx) : this.getRequestTypeFromRequest(customerRequest);
        PortalContext portalContext = PortalContext.builder().setUser(applicationUser).setPortal(portal).setServiceDesk(serviceDesk).setIssue(issue).setCustomerRequest(customerRequest).setRequestType(requestType).build();
        return io.atlassian.fugue.Either.right((Object)new PortalWebFragmentsResponse(this.portalWebFragmentsService.getHeaderPanels(portalContext, portalPage), this.portalWebFragmentsService.getSubheaderPanels(portalContext, portalPage), this.portalWebFragmentsService.getFooterPanels(portalContext, portalPage), this.portalWebFragmentsService.getPagePanels(portalContext, portalPage)));
    }

    private ApplicationUser getApplicationUser() {
        return (ApplicationUser)Steps.begin((Either)this.userFactory.getCheckedUser()).yield(CheckedUser::forJIRA).getOrNull();
    }

    private PortalInternal getPortal(Long portalId) {
        if (portalId == null) {
            return null;
        }
        return (PortalInternal)this.portalInternalManager.getPortalById(portalId).getOrNull();
    }

    private ServiceDesk getServiceDesk(PortalInternal portal) {
        if (portal == null) {
            return null;
        }
        return (ServiceDesk)Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.internalServiceDeskService.getServiceDeskForProjectId(user, portal.getProjectId(), false)).yield((user, sd) -> sd).getOrNull();
    }

    private Issue getIssue(String issueKey) {
        if (issueKey == null) {
            return null;
        }
        return this.issueManager.getIssueObject(issueKey);
    }

    private CustomerRequest getCustomerRequest(Issue issue) {
        if (issue == null) {
            return null;
        }
        ApplicationUser applicationUser = this.getApplicationUser();
        CustomerRequestQuery customerRequestQuery = this.serviceDeskCustomerRequestService.newQueryBuilder().issue(issue.getId()).build();
        return (CustomerRequest)this.serviceDeskCustomerRequestService.getCustomerRequests(applicationUser, customerRequestQuery).fold(anError -> null, customerRequests -> customerRequests.findFirst().orElse(null));
    }

    private Boolean hasRequestTypeId(ModelsRequest ctx) {
        return ctx.getOptions().getReqCreate().getId() > -1L;
    }

    private RequestType getRequestTypeFromContext(ModelsRequest ctx) {
        if (ctx == null) {
            return null;
        }
        return this.getRequestType(Math.toIntExact(ctx.getOptions().getReqCreate().getId()));
    }

    private RequestType getRequestTypeFromRequest(CustomerRequest request) {
        if (request == null) {
            return null;
        }
        return this.getRequestType(request.getRequestTypeId());
    }

    private RequestType getRequestType(Integer requestTypeId) {
        if (requestTypeId == null) {
            return null;
        }
        ApplicationUser applicationUser = this.getApplicationUser();
        RequestTypeQuery requestTypeQuery = this.requestTypeService.newQueryBuilder().requestType(requestTypeId).build();
        return (RequestType)this.requestTypeService.getRequestTypes(applicationUser, requestTypeQuery).fold(anError -> null, requestTypes -> requestTypes.findFirst().orElse(null));
    }
}

